/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core;

import com.nokia.helium.core.HlmAntLibException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class EmailDataSender {
    private static Logger log = Logger.getLogger(EmailDataSender.class);
    private String from;
    private String[] toAddressList;
    private String ldapURL;
    private String rootdn = "o=Nokia";
    private String smtpServerAddress;

    public EmailDataSender(String toStrings, String smtpServer, String ldapAddress) {
        if (toStrings != null) {
            String[] splitList = toStrings.split(",");
            this.toAddressList = splitList;
        }
        this.smtpServerAddress = smtpServer;
        this.ldapURL = ldapAddress;
    }

    public EmailDataSender(String[] toList, String smtpServer, String ldapAddress) {
        this.toAddressList = toList;
        this.smtpServerAddress = smtpServer;
        this.ldapURL = ldapAddress;
    }

    public EmailDataSender(String[] toList, String smtpServer, String ldapAddress, String rootdn) {
        this.toAddressList = toList;
        this.smtpServerAddress = smtpServer;
        this.ldapURL = ldapAddress;
        this.rootdn = rootdn;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void addCurrentUserToAddressList() {
        if (this.toAddressList == null) {
            this.toAddressList = new String[0];
        }
        try {
            String userEmail = this.getUserEmail();
            this.toAddressList = Arrays.copyOf(this.toAddressList, this.toAddressList.length + 1);
            this.toAddressList[this.toAddressList.length - 1] = userEmail;
        }
        catch (Exception e) {
            return;
        }
    }

    private InternetAddress[] getToAddressList() {
        int toListLength = 0;
        if (this.toAddressList != null) {
            toListLength = this.toAddressList.length;
        }
        InternetAddress[] addressList = new InternetAddress[toListLength];
        try {
            log.debug((Object)("getToAddressList:length: " + toListLength));
            for (int i = 0; i < toListLength; ++i) {
                log.debug((Object)("getToAddressList:address:" + this.toAddressList[i]));
                addressList[i] = new InternetAddress(this.toAddressList[i]);
            }
        }
        catch (Exception aex) {
            log.error((Object)("AddressException: " + aex));
        }
        return addressList;
    }

    public void sendData(String purpose, String fileToSend, String mimeType, String subject, String header) {
        this.sendData(purpose, fileToSend, mimeType, subject, header, false);
    }

    public void compresseAndSendData(String purpose, String fileToSend, String subject, String header) {
        this.sendData(purpose, fileToSend, null, subject, header, true);
    }

    public void sendData(String purpose, String fileToSend, String mimeType, String subject, String header, boolean compressData) {
        block10: {
            try {
                log.debug((Object)("sendData:Send file: " + fileToSend + " and mimetype: " + mimeType));
                if (fileToSend == null) break block10;
                log.debug((Object)("sendData:smtp address: " + this.smtpServerAddress));
                InternetAddress[] toAddresses = this.getToAddressList();
                Properties props = new Properties();
                props.setProperty("mail.smtp.host", this.smtpServerAddress);
                Session mailSession = Session.getDefaultInstance((Properties)props, null);
                MimeMessage message = new MimeMessage(mailSession);
                String subjectToSend = subject;
                if (subject == null) {
                    subjectToSend = "";
                }
                message.setSubject(subjectToSend);
                MimeMultipart multipart = new MimeMultipart("related");
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                ByteArrayDataSource dataSrc = null;
                String fileName = new File(fileToSend).getName();
                if (compressData) {
                    log.debug((Object)"Sending compressed data");
                    dataSrc = this.compressFile(fileToSend);
                    dataSrc.setName(fileName + ".gz");
                    messageBodyPart.setFileName(fileName + ".gz");
                } else {
                    log.debug((Object)"Sending uncompressed data:");
                    dataSrc = new ByteArrayDataSource((InputStream)new FileInputStream(new File(fileToSend)), mimeType);
                    message.setContent((Object)FileUtils.readFileToString((File)new File(fileToSend)), "text/html");
                    multipart = null;
                }
                String headerToSend = null;
                if (header == null) {
                    headerToSend = "";
                }
                messageBodyPart.setHeader("helium-bld-data", headerToSend);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSrc));
                if (multipart != null) {
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                    message.setContent((Multipart)multipart);
                }
                try {
                    InternetAddress fromAddress = this.getFromAddress();
                    message.setFrom((Address)fromAddress);
                }
                catch (Exception e) {
                    log.debug((Object)("Error retrieving current user email address: " + e.getMessage()), (Throwable)e);
                }
                message.addRecipients(Message.RecipientType.TO, (Address[])toAddresses);
                log.info((Object)("Sending email alert: " + subject));
                Transport.send((Message)message);
            }
            catch (Exception e) {
                String errorMessage = e.getMessage();
                String fullErrorMessage = "Failed sending e-mail: " + purpose;
                if (errorMessage != null) {
                    fullErrorMessage = fullErrorMessage + " " + errorMessage;
                }
                log.info((Object)fullErrorMessage);
            }
        }
    }

    protected ByteArrayDataSource compressFile(String fileName) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gz = new GZIPOutputStream(out);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(fileName)));
        byte[] dataBuffer = new byte[512];
        while (bufferedInputStream.read(dataBuffer) != -1) {
            gz.write(dataBuffer);
        }
        gz.close();
        bufferedInputStream.close();
        ByteArrayDataSource dataSrc = new ByteArrayDataSource(out.toByteArray(), "application/x-gzip");
        return dataSrc;
    }

    private InternetAddress getFromAddress() throws Exception {
        if (this.from != null) {
            return new InternetAddress(this.from);
        }
        return new InternetAddress(this.getUserEmail());
    }

    protected String getUserEmail() throws Exception {
        String username = System.getProperty("user.name");
        log.debug((Object)("EmailDataSender:getUserEmail:username: " + username));
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapURL + "/" + this.rootdn);
        InitialDirContext ctx = new InitialDirContext(env);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> en = ctx.search("", "uid=" + username, controls);
            if (en.hasMore()) {
                SearchResult sr = en.next();
                String email = (String)sr.getAttributes().get("mail").get();
                log.debug((Object)("getUserEmail:" + email));
                return email;
            }
        }
        catch (NameNotFoundException ex) {
            throw new HlmAntLibException("Error finding user email for " + username);
        }
        throw new HlmAntLibException("Could not find user email in LDAP.");
    }
}

