/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;

class IndexRowToBaseRowResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private GeneratedMethod restriction;
    public FormatableBitSet accessedHeapCols;
    private FormatableBitSet accessedAllCols;
    public String indexName;
    private int[] indexCols;
    private DynamicCompiledOpenConglomInfo dcoci;
    private StaticCompiledOpenConglomInfo scoci;
    private ConglomerateController baseCC;
    private boolean closeBaseCCHere;
    private ExecRow resultRow;
    private boolean forUpdate;
    private DataValueDescriptor[] rowArray;
    RowLocation baseRowLocation;
    boolean copiedFromSource;
    public long restrictionTime;
    protected boolean currentRowPrescanned;
    private boolean sourceIsForUpdateIndexScan;

    IndexRowToBaseRowResultSet(long l, int n, Activation activation, NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, int n2, String string, int n3, int n4, int n5, int n6, GeneratedMethod generatedMethod2, boolean bl, double d, double d2) throws StandardException {
        super(activation, n2, d, d2);
        GenericPreparedStatement genericPreparedStatement = (GenericPreparedStatement)activation.getPreparedStatement();
        Object[] objectArray = genericPreparedStatement.getSavedObjects();
        this.scoci = (StaticCompiledOpenConglomInfo)objectArray[n];
        TransactionController transactionController = this.activation.getTransactionController();
        this.dcoci = transactionController.getDynamicCompiledConglomInfo(l);
        this.source = noPutResultSet;
        this.indexName = string;
        this.forUpdate = bl;
        this.restriction = generatedMethod2;
        if (n3 != -1) {
            this.accessedHeapCols = (FormatableBitSet)objectArray[n3];
        }
        if (n4 != -1) {
            this.accessedAllCols = (FormatableBitSet)objectArray[n4];
        }
        this.indexCols = ((ReferencedColumnsDescriptorImpl)objectArray[n6]).getReferencedColumnPositions();
        this.resultRow = (ExecRow)generatedMethod.invoke(this.activation);
        this.getCompactRow(this.resultRow, this.accessedAllCols, false);
        if (this.accessedHeapCols == null) {
            this.rowArray = this.resultRow.getRowArray();
        } else {
            DataValueDescriptor[] dataValueDescriptorArray = this.resultRow.getRowArray();
            FormatableBitSet formatableBitSet = (FormatableBitSet)objectArray[n5];
            int n7 = formatableBitSet.getLength();
            this.rowArray = new DataValueDescriptor[n7];
            int n8 = Math.min(dataValueDescriptorArray.length, n7);
            for (int i = 0; i < n8; ++i) {
                if (dataValueDescriptorArray[i] == null || !formatableBitSet.isSet(i)) continue;
                this.rowArray[i] = dataValueDescriptorArray[i];
            }
        }
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        boolean bl = false;
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        if (this.source instanceof TableScanResultSet && ((TableScanResultSet)this.source).indexCols != null) {
            this.sourceIsForUpdateIndexScan = true;
        }
        if (this.source.requiresRelocking()) {
            bl = true;
        }
        TransactionController transactionController = this.activation.getTransactionController();
        int n = this.forUpdate ? 4 : 0;
        int n2 = this.source.getScanIsolationLevel();
        if (!bl) {
            n |= 0x2000;
        }
        if (this.forUpdate) {
            this.baseCC = this.activation.getHeapConglomerateController();
        }
        if (this.baseCC == null) {
            this.baseCC = transactionController.openCompiledConglomerate(this.activation.getResultSetHoldability(), n, 6, n2, this.scoci, this.dcoci);
            this.closeBaseCCHere = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        long l = 0L;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (this.sourceIsForUpdateIndexScan && ((TableScanResultSet)this.source).futureForUpdateRows != null) {
            this.currentRowPrescanned = false;
            TableScanResultSet tableScanResultSet = (TableScanResultSet)this.source;
            if (tableScanResultSet.futureRowResultSet == null) {
                tableScanResultSet.futureRowResultSet = (TemporaryRowHolderResultSet)tableScanResultSet.futureForUpdateRows.getResultSet();
                tableScanResultSet.futureRowResultSet.openCore();
            }
            ExecRow execRow3 = tableScanResultSet.futureRowResultSet.getNextRowCore();
            this.currentRow = null;
            if (execRow3 != null) {
                tableScanResultSet.futureRowResultSet.deleteCurrentRow();
                this.baseRowLocation = (RowLocation)execRow3.getColumn(1);
                this.baseCC.fetch(this.baseRowLocation, this.compactRow.getRowArray(), this.accessedAllCols);
                this.currentRow = this.compactRow;
                this.currentRowPrescanned = true;
            } else if (tableScanResultSet.sourceDrained) {
                this.currentRowPrescanned = true;
            }
            if (this.currentRowPrescanned) {
                this.setCurrentRow(this.currentRow);
                this.nextTime += this.getElapsedMillis(this.beginTime);
                return this.currentRow;
            }
        }
        do {
            if ((execRow = this.source.getNextRowCore()) != null) {
                this.baseRowLocation = (RowLocation)execRow.getColumn(execRow.nColumns());
                boolean bl2 = this.baseCC.fetch(this.baseRowLocation, this.rowArray, this.accessedHeapCols);
                if (bl2) {
                    if (!this.copiedFromSource) {
                        this.copiedFromSource = true;
                        for (int i = 0; i < this.indexCols.length; ++i) {
                            if (this.indexCols[i] == -1) continue;
                            this.compactRow.setColumn(i + 1, execRow.getColumn(this.indexCols[i] + 1));
                        }
                    }
                    this.setCurrentRow(this.compactRow);
                    DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                    this.restrictionTime += this.getElapsedMillis(l);
                    boolean bl3 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                }
                if (!bl || !bl2) {
                    ++this.rowsFiltered;
                    this.clearCurrentRow();
                    this.baseRowLocation = null;
                } else {
                    this.currentRow = this.compactRow;
                }
                ++this.rowsSeen;
                execRow2 = this.currentRow;
                continue;
            }
            this.clearCurrentRow();
            this.baseRowLocation = null;
            execRow2 = null;
        } while (execRow != null && !bl);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow2;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.closeBaseCCHere && this.baseCC != null) {
                this.baseCC.close();
            }
            this.baseCC = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        return this.baseRowLocation;
    }

    public void positionScanAtRowLocation(RowLocation rowLocation) throws StandardException {
        this.baseRowLocation = rowLocation;
        this.source.positionScanAtRowLocation(rowLocation);
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow execRow = null;
        if (this.currentRowPrescanned) {
            return this.currentRow;
        }
        if (this.currentRow == null) {
            return null;
        }
        execRow = this.activation.getExecutionFactory().getValueRow(this.indexCols.length);
        execRow.setRowArray(this.rowArray);
        boolean bl = this.baseCC.fetch(this.baseRowLocation, this.rowArray, null);
        if (bl) {
            this.setCurrentRow(execRow);
        } else {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }
}

