/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.latex.PropertyManager;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.LaTeXConverter;
import info.bliki.wiki.filter.WPTable;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import info.bliki.wiki.tags.util.INoBodyParsingTag;
import java.io.IOException;
import java.util.Map;

public class SourceTag
extends HTMLTag
implements INoBodyParsingTag {
    protected static final String SOURCE_START = "<pre class=\"code\">";
    protected static final String SOURCE_END = "</pre>";

    public SourceTag() {
        super("source");
    }

    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        Map<String, String> attributes;
        String sourceCodeLanguage;
        String content = this.getBodyString();
        if (content != null && content.length() > 0 && (sourceCodeLanguage = (attributes = this.getAttributes()).get("lang")) != null) {
            boolean show = model.showSyntax(sourceCodeLanguage);
            if (show) {
                SourceCodeFormatter formatter = model.getCodeFormatterMap().get(sourceCodeLanguage);
                if (formatter != null) {
                    String result = formatter.filter(content);
                    writer.append(SOURCE_START);
                    writer.append(result);
                    writer.append(SOURCE_END);
                }
            } else {
                writer.append(SOURCE_START);
                writer.append(content);
                writer.append(SOURCE_END);
            }
        }
    }

    public void renderLaTeX(ITextConverter converter, Appendable _out, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            boolean inTable = this.getParent() instanceof WPTable;
            if (inTable) {
                _out.append(PropertyManager.get("CodeBlock.inTable.Begin"));
                _out.append(LaTeXConverter.verbToText(content));
                _out.append(PropertyManager.get("CodeBlock.inTable.End"));
            } else {
                _out.append(PropertyManager.get("CodeBlock.Begin"));
                _out.append(content);
                _out.append(PropertyManager.get("CodeBlock.End"));
            }
        }
    }

    public boolean isReduceTokenStack() {
        return true;
    }

    public String getParents() {
        return "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    }
}

