/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import java.io.IOException;
import java.io.Reader;

final class StringArrayReader
extends Reader {
    private final String[] mUnderlyingArray;
    private final int[] mLenghtArray;
    private int mArrayIdx;
    private int mStringIdx;
    private boolean mUnreportedNewline;
    private boolean mClosed;

    StringArrayReader(String[] aUnderlyingArray) {
        int length = aUnderlyingArray.length;
        this.mUnderlyingArray = new String[length];
        System.arraycopy(aUnderlyingArray, 0, this.mUnderlyingArray, 0, length);
        this.mLenghtArray = new int[length];
        for (int i = 0; i < length; ++i) {
            this.mLenghtArray[i] = this.mUnderlyingArray[i].length();
        }
    }

    public void close() {
        this.mClosed = true;
    }

    private boolean dataAvailable() {
        return this.mUnderlyingArray.length > this.mArrayIdx;
    }

    public int read(char[] aCbuf, int aOff, int aLen) throws IOException {
        this.ensureOpen();
        int retVal = 0;
        if (!this.mUnreportedNewline && this.mUnderlyingArray.length <= this.mArrayIdx) {
            return -1;
        }
        while (retVal < aLen && (this.mUnreportedNewline || this.dataAvailable())) {
            if (this.mUnreportedNewline) {
                aCbuf[aOff + retVal] = 10;
                ++retVal;
                this.mUnreportedNewline = false;
            }
            if (retVal >= aLen || !this.dataAvailable()) continue;
            String currentStr = this.mUnderlyingArray[this.mArrayIdx];
            int currentLenth = this.mLenghtArray[this.mArrayIdx];
            int srcEnd = Math.min(currentLenth, this.mStringIdx + aLen - retVal);
            currentStr.getChars(this.mStringIdx, srcEnd, aCbuf, aOff + retVal);
            retVal += srcEnd - this.mStringIdx;
            this.mStringIdx = srcEnd;
            if (this.mStringIdx < currentLenth) continue;
            ++this.mArrayIdx;
            this.mStringIdx = 0;
            this.mUnreportedNewline = true;
        }
        return retVal;
    }

    public int read() throws IOException {
        if (this.mUnreportedNewline) {
            this.mUnreportedNewline = false;
            return 10;
        }
        if (this.mArrayIdx < this.mUnderlyingArray.length && this.mStringIdx < this.mLenghtArray[this.mArrayIdx]) {
            this.ensureOpen();
            return this.mUnderlyingArray[this.mArrayIdx].charAt(this.mStringIdx++);
        }
        return super.read();
    }

    private void ensureOpen() throws IOException {
        if (this.mClosed) {
            throw new IOException("already closed");
        }
    }
}

