/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.dom4j.Comment;
import org.dom4j.Node;

public class AntComment {
    private String summary = "";
    private String parsedDocText = "";
    private HashMap<String, String> tags = new HashMap();
    private String objectName = "";
    private boolean isMarkedComment;
    private int indent;

    public AntComment() throws IOException {
        this(null);
    }

    public AntComment(Comment comment) throws IOException {
        if (comment != null) {
            String text = comment.getText();
            if ((text = text.trim()).startsWith("*")) {
                text = text.substring(1).trim();
                this.isMarkedComment = true;
            }
            if (text.startsWith("@property")) {
                String[] splitStrings = text.split("\\s", 3);
                this.objectName = splitStrings[1];
                if (this.objectName == null) {
                    this.log("Comment block: object name is not defined.", 1);
                    this.objectName = "";
                }
                text = splitStrings.length > 2 ? splitStrings[2] : "";
            }
            this.findIndent(comment);
            this.parseCommentText(text);
        }
    }

    private void findIndent(Comment comment) {
        Node whitespace = comment.selectSingleNode("preceding-sibling::text()");
        if (whitespace != null) {
            String text = whitespace.getText();
            String[] lines = text.split("\n");
            this.indent = lines[lines.length - 1].length();
        }
    }

    private void parseCommentText(String text) throws IOException {
        if (text.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(text, "@");
            if (!text.startsWith("@")) {
                String freeText = tokenizer.nextToken();
                BreakIterator iterator = BreakIterator.getSentenceInstance();
                iterator.setText(freeText);
                if (iterator.next() > 0) {
                    this.summary = freeText.substring(0, iterator.current()).trim();
                }
                this.parsedDocText = freeText;
                this.cleanupIndents();
            }
            if (tokenizer.countTokens() > 0) {
                while (tokenizer.hasMoreElements()) {
                    String tagText = (String)tokenizer.nextElement();
                    String[] tagParts = tagText.split("\\s", 2);
                    this.tags.put(tagParts[0], tagParts[1].trim());
                }
            }
        }
    }

    private void cleanupIndents() {
        String[] docLines = this.parsedDocText.split("\n");
        this.parsedDocText = docLines[0];
        for (int i = 1; i < docLines.length; ++i) {
            String line = docLines[i].replaceFirst("^[ \t]{" + this.indent + "}", "");
            this.parsedDocText = this.parsedDocText + line + "\n";
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDocumentation() {
        return this.parsedDocText;
    }

    public String getTagValue(String tag) {
        return this.getTagValue(tag, "");
    }

    public String getTagValue(String tag, String defaultValue) {
        String value = this.tags.get(tag);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isMarkedComment() {
        return this.isMarkedComment;
    }

    private void log(String string, int msgWarn) {
        System.out.println(string);
    }
}

