/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerLock;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.RowLock;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.xact.NoLocking;
import org.apache.derby.impl.store.raw.xact.RowLockingRR;

public class RowLocking2
extends RowLockingRR {
    private static final LockingPolicy NO_LOCK = new NoLocking();

    protected RowLocking2(LockFactory lockFactory) {
        super(lockFactory);
    }

    public boolean lockContainer(Transaction transaction, ContainerHandle containerHandle, boolean bl, boolean bl2) throws StandardException {
        ContainerLock containerLock = bl2 ? ContainerLock.CIX : ContainerLock.CIS;
        Object object = bl2 ? transaction : containerHandle.getUniqueId();
        boolean bl3 = this.lf.lockObject(transaction.getCompatibilitySpace(), object, containerHandle.getId(), containerLock, bl ? -2 : 0);
        if (bl3) {
            if (this.lf.isLockHeld(transaction.getCompatibilitySpace(), transaction, containerHandle.getId(), ContainerLock.CX)) {
                this.lf.unlockGroup(transaction.getCompatibilitySpace(), containerHandle.getUniqueId());
                containerHandle.setLockingPolicy(NO_LOCK);
            } else if (!bl2 && this.lf.isLockHeld(transaction.getCompatibilitySpace(), transaction, containerHandle.getId(), ContainerLock.CS)) {
                this.lf.transfer(transaction.getCompatibilitySpace(), object, transaction);
                containerHandle.setLockingPolicy(NO_LOCK);
            }
        }
        return bl3;
    }

    public boolean lockRecordForRead(Transaction transaction, ContainerHandle containerHandle, RecordHandle recordHandle, boolean bl, boolean bl2) throws StandardException {
        RowLock rowLock = bl2 ? RowLock.RU2 : RowLock.RS2;
        return this.lf.lockObject(transaction.getCompatibilitySpace(), containerHandle.getUniqueId(), recordHandle, rowLock, bl ? -2 : 0);
    }

    public void unlockRecordAfterRead(Transaction transaction, ContainerHandle containerHandle, RecordHandle recordHandle, boolean bl, boolean bl2) throws StandardException {
        RowLock rowLock = bl ? RowLock.RU2 : RowLock.RS2;
        int n = this.lf.unlock(transaction.getCompatibilitySpace(), containerHandle.getUniqueId(), recordHandle, rowLock);
    }

    public void unlockContainer(Transaction transaction, ContainerHandle containerHandle) {
        this.lf.unlockGroup(transaction.getCompatibilitySpace(), containerHandle.getUniqueId());
    }
}

