<#--
============================================================================ 
Name        : build_imaker_roms_signing.mk.ftl 
Part of     : Helium 

Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
All rights reserved.
This component and the accompanying materials are made available
under the terms of the License "Eclipse Public License v1.0"
which accompanies this distribution, and is available
at the URL "http://www.eclipse.org/legal/epl-v10.html".

Initial Contributors:
Nokia Corporation - initial contribution.

Contributors:

Description:

============================================================================
-->
############################################################################
# Makefile generated by the emake engine 
############################################################################

# Are we using linux?
USE_UNIX  := $(if $(findstring cmd.exe,$(SHELL))$(findstring mingw,$(call lcase,$(MAKE))),0,1)
EXECUTOR_CLASS = com.nokia.helium.imaker.utils.ParallelExecutor

# Path conversion macro
true        = $(if $(filter-out 0,$(subst 0,0 ,$1)),1)
iif         = $(if $(call true,$1),$2,$3)
lcase       = $(call tr,$([A-Z]),$([a-z]),$1)
pathconv    = $(call iif,$(USE_UNIX),$(subst \,/,$1),$(subst /,\,$1))

# Some variables
ROMBUILD_TEMPDIR=$(call pathconv,epoc32/rombuild/temp)


$(ROMBUILD_TEMPDIR)/:
	-mkdir $(ROMBUILD_TEMPDIR)

<#assign cid=0>
<#assign iid=0>
<#assign deps="">
<#list cmdSets as cmds>
<#assign configdeps="">
<#assign configimagedeps="">
<#assign firstiid=iid>

#pragma runlocal
configuration_${cid}-dir: $(ROMBUILD_TEMPDIR)/config_${iid} <#if (cid>0)>configuration_${cid-1}</#if> <#if (cmds?size == 0)>;</#if>
	$(call iif,$(USE_UNIX),touch,@echo off >) $(ROMBUILD_TEMPDIR)/command-dir-list-${cid}.txt
    <#list cmds as cmd>
        <#assign cmdline="">
        <#list cmd.getArguments() as arg>
            <#assign cmdline="${cmdline} ${arg}">
        </#list>
        <#assign vars=cmd.getVariables()>
        <#list vars?keys as var>
            <#assign cmdline="${cmdline} ${var}=${vars[var]}">
        </#list>
	@echo $(call iif,$(USE_UNIX),,cmd /c) ${cmd.getCommand()} WORKDIR=$(ROMBUILD_TEMPDIR)/config_${iid} ${cmdline} ${cmd.getTarget()}-dir >> $(ROMBUILD_TEMPDIR)/command-dir-list-${cid}.txt 
<#assign iid=iid+1>
    </#list>
	-@${java_home}/bin/java -cp "${java_utils_classpath}" $(EXECUTOR_CLASS) $(ROMBUILD_TEMPDIR)/command-dir-list-${cid}.txt


<#assign iid=firstiid>
    <#list cmds as cmd>
        <#assign cmdline="">
        <#list cmd.getArguments() as arg>
            <#assign cmdline="${cmdline} ${arg}">
        </#list>
        <#assign vars=cmd.getVariables()>
        <#list vars?keys as var>
            <#assign cmdline="${cmdline} ${var}=${vars[var]}">
        </#list>
#
#  Building configuration ${iid}.
#
$(ROMBUILD_TEMPDIR)/config_${iid}/: $(ROMBUILD_TEMPDIR)
	-mkdir $(call pathconv,$(ROMBUILD_TEMPDIR)/config_${iid})


rom_${iid}-image: configuration_${cid}-dir
	@echo -- ${cmd.getCmdLine()}-image
	-@perl -e "print '++ Started at '.localtime().\"\n\""
	-@python -c "import time; print '+++ HiRes Start ',time.time();"
	-${cmd.getCommand()} WORKDIR=$(ROMBUILD_TEMPDIR)/config_${iid} ${cmdline} ${cmd.getTarget()}-image
	-@python -c "import time; print '+++ HiRes End ',time.time();"
	-@perl -e "print '++ Finished at '.localtime().\"\n\""

<#assign configimagedeps="${configimagedeps} rom_${iid}-image">
<#assign iid=iid+1>
    </#list>

configuration_${cid}-image: ${configimagedeps} ;

<#assign iid=firstiid>
#pragma runlocal
configuration_${cid}-e2flash: configuration_${cid}-image
	$(call iif,$(USE_UNIX),touch,@echo off >) $(ROMBUILD_TEMPDIR)/command-e2flash-list-${cid}.txt
    <#list cmds as cmd>
        <#assign cmdline="">
        <#list cmd.getArguments() as arg>
            <#assign cmdline="${cmdline} ${arg}">
        </#list>
        <#assign vars=cmd.getVariables()>
        <#list vars?keys as var>
            <#assign cmdline="${cmdline} ${var}=${vars[var]}">
        </#list>
	@echo $(call iif,$(USE_UNIX),,cmd /c) ${cmd.getCommand()} WORKDIR=$(ROMBUILD_TEMPDIR)/config_${iid} ${cmdline} ${cmd.getTarget()}-e2flash >> $(ROMBUILD_TEMPDIR)/command-e2flash-list-${cid}.txt 
<#assign iid=iid+1>
    </#list>
	 -@${java_home}/bin/java -cp "${java_utils_classpath}" $(EXECUTOR_CLASS) $(ROMBUILD_TEMPDIR)/command-e2flash-list-${cid}.txt


configuration_${cid}: <#if (cid>0)>configuration_${cid-1}</#if> configuration_${cid}-dir configuration_${cid}-image configuration_${cid}-e2flash ;


<#assign deps="configuration_${cid}">        
<#assign cid=cid+1>
</#list>

all: ${deps} ;

# End of config
