/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractScriptCheck;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.dom4j.Element;
import org.dom4j.Node;

public class CheckScriptDef
extends AbstractScriptCheck {
    @Override
    public void run(Element node) {
        if (node.getName().equals("scriptdef")) {
            String scriptdefname = node.attributeValue("name");
            String language = node.attributeValue("language");
            this.checkScriptDef(scriptdefname, (Node)node);
            if (language.equals("beanshell")) {
                this.writeBeanshellFile(scriptdefname, node.getText());
            }
        }
    }

    public void checkScriptDef(String name, Node node) {
        List statements = node.selectNodes("//scriptdef[@name='" + name + "']/attribute");
        Pattern p1 = Pattern.compile("attributes.get\\([\"']([^\"']*)[\"']\\)");
        Matcher m1 = p1.matcher(node.getText());
        ArrayList<String> props = new ArrayList<String>();
        while (m1.find()) {
            props.add(m1.group(1));
        }
        if (!statements.isEmpty() && !props.isEmpty()) {
            for (Node statement : statements) {
                if (props.contains(statement.valueOf("@name"))) continue;
                this.log("Scriptdef " + name + " does not use " + statement.valueOf("@name"));
            }
        }
    }

    private void writeBeanshellFile(String scriptdefname, String text) {
        scriptdefname = "Beanshell" + scriptdefname;
        try {
            String heliumpath = new File(this.getProject().getProperty("helium.build.dir")).getCanonicalPath();
            new File(heliumpath + File.separator + "beanshell").mkdirs();
            File file = new File(heliumpath + File.separator + "beanshell" + File.separator + scriptdefname + ".java");
            PrintWriter output = new PrintWriter(new FileOutputStream(file));
            for (String line : text.split("\n")) {
                if (!line.trim().startsWith("import")) continue;
                output.write(line + "\n");
            }
            output.write("/**\n * x\n */\npublic final class " + scriptdefname + " {\n");
            output.write("private " + scriptdefname + "() { }\n");
            output.write("public static void main(String[] args) {\n");
            for (String line : text.split("\n")) {
                if (line.trim().startsWith("import")) continue;
                output.write(line + "\n");
            }
            output.write("} }");
            output.close();
        }
        catch (Exception e) {
            throw new BuildException("Not able to write Beanshell File " + scriptdefname + ".java");
        }
    }
}

