/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.VfsResolver;
import org.apache.ivy.util.Message;

public class VfsResource
implements Resource {
    private String _vfsURI;
    private FileSystemManager _fsManager;
    private transient boolean _init = false;
    private transient boolean _exists;
    private transient long _lastModified;
    private transient long _contentLength;
    private transient FileContent _content = null;
    private transient FileObject _resourceImpl;

    public VfsResource(String vfsURI, FileSystemManager fsManager) {
        this._vfsURI = vfsURI;
        this._fsManager = fsManager;
        this._init = false;
    }

    private void init() {
        if (!this._init) {
            try {
                this._resourceImpl = this._fsManager.resolveFile(this._vfsURI);
                this._content = this._resourceImpl.getContent();
                this._exists = this._resourceImpl.exists();
                this._lastModified = this._content.getLastModifiedTime();
                this._contentLength = this._content.getSize();
            }
            catch (FileSystemException e) {
                Message.verbose(e.getLocalizedMessage());
                this._exists = false;
                this._lastModified = 0L;
                this._contentLength = 0L;
            }
            this._init = true;
        }
    }

    public List getChildren() {
        this.init();
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (this._resourceImpl != null && this._resourceImpl.exists() && this._resourceImpl.getType() == FileType.FOLDER) {
                FileObject[] children = this._resourceImpl.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    FileObject child = children[i];
                    list.add(VfsResource.normalize(child.getName().getURI()));
                }
            }
        }
        catch (IOException e) {
            Message.verbose(e.getLocalizedMessage());
        }
        return list;
    }

    public FileContent getContent() {
        this.init();
        return this._content;
    }

    public String getName() {
        return VfsResource.normalize(this._vfsURI);
    }

    public Resource clone(String cloneName) {
        return new VfsResource(cloneName, this._fsManager);
    }

    public static String normalize(String vfsURI) {
        if (vfsURI == null) {
            return "";
        }
        if (vfsURI.startsWith("file:////")) {
            vfsURI = vfsURI.replaceFirst("////", "///");
        }
        return vfsURI;
    }

    public long getLastModified() {
        this.init();
        return this._lastModified;
    }

    public long getContentLength() {
        this.init();
        return this._contentLength;
    }

    public boolean exists() {
        this.init();
        return this._exists;
    }

    public boolean physicallyExists() {
        this.init();
        try {
            return this._resourceImpl.exists();
        }
        catch (Exception e) {
            Message.verbose(e.getLocalizedMessage());
            return false;
        }
    }

    public String toString() {
        return VfsResolver.prepareForDisplay(this.getName());
    }

    public boolean isLocal() {
        return this.getName().startsWith("file:");
    }

    public InputStream openStream() throws IOException {
        return this.getContent().getInputStream();
    }
}

