/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.sqlite.Conn;

public class JDBC
implements Driver {
    private static final String PREFIX = "jdbc:sqlite:";

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public boolean acceptsURL(String string) {
        return string != null && string.toLowerCase().startsWith(PREFIX);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("shared_cache", "false");
        driverPropertyInfo.choices = new String[]{"true", "false"};
        driverPropertyInfo.description = "Enable SQLite Shared-Cache mode, native driver only.";
        driverPropertyInfo.required = false;
        return new DriverPropertyInfo[]{driverPropertyInfo};
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        if (!this.acceptsURL(string)) {
            return null;
        }
        String string3 = string2 = PREFIX.equalsIgnoreCase(string = string.trim()) ? ":memory:" : string.substring(PREFIX.length());
        if (properties.getProperty("shared_cache") == null) {
            return new Conn(string, string2);
        }
        return new Conn(string, string2, Boolean.parseBoolean(properties.getProperty("shared_cache")));
    }

    static {
        try {
            DriverManager.registerDriver(new JDBC());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

