/*
 * Decompiled with CFR 0.152.
 */
package se.jtech.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class ConfigurableNamespaceContext
implements NamespaceContext {
    final Map uri2Prefix;
    final Map prefix2Uri;

    public ConfigurableNamespaceContext(Map namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException("Namespaces Map may not be null.");
        }
        this.prefix2Uri = namespaces;
        this.uri2Prefix = new HashMap();
        Iterator keys = this.prefix2Uri.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.uri2Prefix.put(this.prefix2Uri.get(key), key);
        }
    }

    public ConfigurableNamespaceContext() {
        this(new HashMap());
    }

    public void addNamespace(String uri, String prefix) {
        this.uri2Prefix.put(uri, prefix);
        this.prefix2Uri.put(prefix, uri);
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix may not be null.");
        }
        String uri = (String)this.prefix2Uri.get(prefix);
        return uri;
    }

    public String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Namespace URI may not be null.");
        }
        String prefix = (String)this.uri2Prefix.get(uri);
        return prefix;
    }

    public Iterator getPrefixes(String uri) {
        return this.prefix2Uri.keySet().iterator();
    }
}

