/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.signal.ant;

import com.nokia.helium.signal.Notifier;
import com.nokia.helium.signal.SignalStatus;
import com.nokia.helium.signal.SignalStatusList;
import com.nokia.helium.signal.ant.types.NotifierInput;
import com.nokia.helium.signal.ant.types.SignalInput;
import com.nokia.helium.signal.ant.types.SignalListenerConfig;
import com.nokia.helium.signal.ant.types.SignalNotifierInput;
import com.nokia.helium.signal.ant.types.SignalNotifierList;
import com.nokia.helium.signal.ant.types.TargetCondition;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class SignalList {
    public static final String DEFAULT_NOTIFIER_LIST_REFID = "defaultSignalInput";
    private Hashtable<String, SignalListenerConfig> signalListenerConfigs = new Hashtable();
    private HashMap<String, List<SignalListenerConfig>> targetsMap = new HashMap();
    private Project project;
    private Logger log = Logger.getLogger(this.getClass());

    public SignalList(Project project) {
        this.project = project;
        Hashtable references = project.getReferences();
        Enumeration keyEnum = references.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            if (!(references.get(key) instanceof SignalListenerConfig)) continue;
            this.log.debug((Object)("SignalList: Found reference: " + key));
            SignalListenerConfig config = (SignalListenerConfig)((Object)references.get(key));
            config.setConfigId(key);
            this.signalListenerConfigs.put(key, config);
            String targetName = config.getTargetName();
            List<SignalListenerConfig> list = this.targetsMap.get(targetName) == null ? new ArrayList<SignalListenerConfig>() : this.targetsMap.get(targetName);
            list.add(config);
            this.targetsMap.put(targetName, list);
        }
    }

    public Project getProject() {
        return this.project;
    }

    public Vector<SignalListenerConfig> getSignalListenerConfigList() {
        return new Vector<SignalListenerConfig>(this.signalListenerConfigs.values());
    }

    public boolean isTargetInSignalList(String targetName) {
        return this.targetsMap.get(targetName) != null;
    }

    public List<SignalListenerConfig> getSignalListenerConfig(String targetName) {
        return this.targetsMap.get(targetName);
    }

    protected void sendNotifications(Vector<Notifier> notifierList, String signalName, String errorMessage) {
        this.sendNotifications(notifierList, signalName, false, null, errorMessage);
    }

    public void processForSignal(Project prj, SignalNotifierInput signalNotifierInput, String signalName, String targetName, String errorMessage, boolean failBuild) {
        Object obj;
        SignalInput signalInput = signalNotifierInput.getSignalInput();
        Vector<Notifier> notifierList = signalInput.getSignalNotifierList();
        if (notifierList == null && (obj = prj.getReference(DEFAULT_NOTIFIER_LIST_REFID)) instanceof SignalNotifierList) {
            notifierList = ((SignalNotifierList)((Object)obj)).getNotifierList();
        }
        NotifierInput notifierInput = signalNotifierInput.getNotifierInput();
        this.sendNotifications(notifierList, signalName, failBuild, notifierInput, errorMessage);
        if (failBuild) {
            String failStatus = "now";
            if (signalInput != null) {
                failStatus = signalInput.getFailBuild();
            } else {
                this.log.debug((Object)("Could not find config for signal: " + signalName));
            }
            if (failStatus == null || failStatus.equals("now")) {
                this.log.debug((Object)("Adding now signal. Signal name is " + signalName));
                SignalStatusList.getNowSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
                throw new BuildException(new SignalStatus(signalName, errorMessage, targetName, new Date()).toString());
            }
            if (failStatus.equals("defer")) {
                this.log.debug((Object)("Adding deffer signal. Signal " + signalName + " will be deferred."));
                SignalStatusList.getDeferredSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
            } else if (failStatus.equals("never")) {
                this.log.debug((Object)("Adding never signal. Signal name is " + signalName));
                SignalStatusList.getNeverSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
            } else {
                if (!failStatus.equals("never")) {
                    SignalStatusList.getNowSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
                    throw new BuildException(new SignalStatus(signalName, errorMessage, targetName, new Date()).toString());
                }
                this.log.info((Object)("Signal " + signalName + " set to be ignored by the configuration."));
            }
        }
    }

    protected void sendNotifications(Vector<Notifier> notifierList, String signalName, boolean failStatus, NotifierInput notifierInput, String errorMessage) {
        if (notifierList == null) {
            return;
        }
        for (Notifier notifier : notifierList) {
            if (notifier == null) continue;
            notifier.sendData(signalName, failStatus, notifierInput, errorMessage);
        }
    }

    public boolean checkAndNotifyFailure(Target target, Project prj) {
        String targetName = target.getName();
        String signalName = "unknown";
        boolean retValue = false;
        if (this.isTargetInSignalList(targetName)) {
            retValue = true;
            for (SignalListenerConfig config : this.getSignalListenerConfig(targetName)) {
                TargetCondition targetCondition = config.getTargetCondition();
                String errorMessage = null;
                this.log.debug((Object)("targetcondition:" + (Object)((Object)targetCondition)));
                Condition condition = null;
                if (targetCondition != null) {
                    condition = this.getFailureCondition(targetCondition);
                }
                errorMessage = config.getErrorMessage();
                String refid = config.getConfigId();
                this.log.debug((Object)("refid:" + refid));
                Object configCurrent = prj.getReference(refid);
                if (configCurrent != null && configCurrent instanceof SignalListenerConfig) {
                    signalName = refid;
                }
                this.processForSignal(prj, config.getSignalNotifierInput(), signalName, targetName, errorMessage, condition != null);
                this.log.debug((Object)("checkAndNotifyFailure: SignalName: " + signalName));
            }
        }
        return retValue;
    }

    private Condition getFailureCondition(TargetCondition targetCondition) {
        Condition retCondition = null;
        Vector<Condition> conditionList = targetCondition.getConditions();
        for (Condition condition : conditionList) {
            this.log.debug((Object)("getFailureCondition:" + condition.eval()));
            if (!condition.eval()) continue;
            retCondition = condition;
            break;
        }
        return retCondition;
    }

    public void sendSignal(String signalName, boolean failStatus) {
        this.log.debug((Object)("Sending signal for:" + signalName));
        if (this.project.getReference(DEFAULT_NOTIFIER_LIST_REFID) != null) {
            this.sendNotify(((SignalInput)((Object)this.project.getReference(DEFAULT_NOTIFIER_LIST_REFID))).getSignalNotifierList(), signalName, failStatus, null);
        }
    }

    protected void sendNotify(Vector<Notifier> notifierList, String signalName) {
        this.sendNotify(notifierList, signalName, false, null);
    }

    protected void sendNotify(Vector<Notifier> notifierList, String signalName, boolean failStatus, List<String> fileList) {
        if (notifierList == null) {
            return;
        }
        for (Notifier notifier : notifierList) {
            if (notifier == null) continue;
            notifier.sendData(signalName, failStatus, fileList);
        }
    }

    public void fail(String signalName, String targetName, String errorMessage) {
        String failStatus = "now";
        this.log.debug((Object)("Could not find config for signal: " + signalName));
        this.log.debug((Object)("failStatus: " + failStatus));
        this.log.debug((Object)("Adding now signal. Signal name is " + signalName));
        SignalStatusList.getNowSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
        throw new BuildException(new SignalStatus(signalName, errorMessage, targetName, new Date()).toString());
    }
}

