/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant;

import info.bliki.wiki.model.WikiModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Database {
    private Project project;
    private ResourceCollection rc;
    private Task task;
    private boolean debug;
    private boolean homeFilesOnly = true;
    private HashMap<String, List<String>> globalSignalList = new HashMap();
    private HashMap map = new HashMap();
    private Document signaldoc;

    public Database(Project project, ResourceCollection rc, Task task) {
        this.project = project;
        this.rc = rc;
        this.task = task;
        this.map.put("hlm", "http://www.nokia.com/helium");
    }

    public Project getProject() {
        return this.project;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setHomeFilesOnly(boolean homeFilesOnly) {
        this.homeFilesOnly = homeFilesOnly;
    }

    public void log(String msg, int level) {
        if (this.task != null) {
            this.task.log(msg, level);
        } else if (this.debug) {
            System.out.println(msg);
        }
    }

    public void setRefid(Reference r) {
        Object o = r.getReferencedObject();
        if (!(o instanceof ResourceCollection)) {
            throw new BuildException(r.getRefId() + " doesn't denote a ResourceCollection");
        }
        this.rc = (ResourceCollection)o;
    }

    public Document createDOM() throws Exception {
        Element root = DocumentHelper.createElement((String)"antDatabase");
        Document outDoc = DocumentHelper.createDocument((Element)root);
        ArrayList antFiles = this.getAntFiles(this.getProject(), this.homeFilesOnly);
        for (String antFile : antFiles) {
            this.readSignals(root, antFile);
        }
        for (String antFile : antFiles) {
            this.parseAntFile(root, antFile);
        }
        return outDoc;
    }

    public void createXMLFile(File outputFile) {
        try {
            Document outDoc = this.createDOM();
            OutputStream outStream = System.out;
            if (outputFile != null) {
                outStream = new FileOutputStream(outputFile);
            }
            XMLWriter out = new XMLWriter(outStream, OutputFormat.createPrettyPrint());
            out.write(outDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
    }

    private void readSignals(Element root, String antFile) throws DocumentException, IOException {
        String failbuild;
        List<String> existinglist;
        String signaltarget;
        String signalid;
        Element propertyNode;
        SAXReader xmlReader = new SAXReader();
        Document antDoc = xmlReader.read(new File(antFile));
        XPath xpath = DocumentHelper.createXPath((String)"//hlm:signalConfig");
        xpath.setNamespaceURIs((Map)this.map);
        List signalNodes = xpath.selectNodes((Object)antDoc);
        Iterator iterator = signalNodes.iterator();
        while (iterator.hasNext()) {
            this.signaldoc = antDoc;
            propertyNode = (Element)iterator.next();
            signalid = propertyNode.attributeValue("id");
            signaltarget = this.signalName(signalid, this.signaldoc);
            existinglist = this.globalSignalList.get(signaltarget);
            failbuild = this.signalType(signalid, this.signaldoc);
            if (existinglist == null) {
                existinglist = new ArrayList<String>();
            }
            existinglist.add(signalid + "," + failbuild);
            this.globalSignalList.put(signaltarget, existinglist);
        }
        xpath = DocumentHelper.createXPath((String)"//hlm:signalListenerConfig");
        xpath.setNamespaceURIs((Map)this.map);
        signalNodes = xpath.selectNodes((Object)antDoc);
        iterator = signalNodes.iterator();
        while (iterator.hasNext()) {
            this.signaldoc = antDoc;
            propertyNode = (Element)iterator.next();
            signalid = propertyNode.attributeValue("id");
            signaltarget = propertyNode.attributeValue("target");
            existinglist = this.globalSignalList.get(signaltarget);
            failbuild = this.signalType(signalid, this.signaldoc);
            if (existinglist == null) {
                existinglist = new ArrayList<String>();
            }
            existinglist.add(signalid + "," + failbuild);
            this.globalSignalList.put(signaltarget, existinglist);
        }
    }

    private String signalName(String signalid, Document antDoc) {
        XPath xpath = DocumentHelper.createXPath((String)("//hlm:signalConfig[@id='" + signalid + "']/hlm:targetCondition"));
        xpath.setNamespaceURIs((Map)this.map);
        List signalNodes2 = xpath.selectNodes((Object)antDoc);
        Iterator iterator2 = signalNodes2.iterator();
        if (iterator2.hasNext()) {
            Element propertyNode2 = (Element)iterator2.next();
            return propertyNode2.attributeValue("name");
        }
        return null;
    }

    private String signalType(String signalid, Document antDoc) {
        XPath xpath2 = DocumentHelper.createXPath((String)("//hlm:signalConfig[@id='" + signalid + "']/hlm:inputRef|//hlm:signalListenerConfig[@id='" + signalid + "']/signalNotifierInput/signalInput"));
        xpath2.setNamespaceURIs((Map)this.map);
        List signalNodes3 = xpath2.selectNodes((Object)antDoc);
        for (Element propertyNode3 : signalNodes3) {
            String signalinputid = propertyNode3.attributeValue("refid");
            XPath xpath3 = DocumentHelper.createXPath((String)("//hlm:signalInput[@id='" + signalinputid + "']"));
            xpath3.setNamespaceURIs((Map)this.map);
            List signalNodes4 = xpath3.selectNodes((Object)antDoc);
            Iterator iterator4 = signalNodes4.iterator();
            if (!iterator4.hasNext()) continue;
            Element propertyNode4 = (Element)iterator4.next();
            return propertyNode4.attributeValue("failbuild");
        }
        return null;
    }

    private void parseAntFile(Element root, String antFile) throws DocumentException, IOException {
        this.log("Processing Ant file: " + antFile, 4);
        SAXReader xmlReader = new SAXReader();
        Document antDoc = xmlReader.read(new File(antFile));
        Element projectElement = root.addElement("project");
        Element nameElement = projectElement.addElement("name");
        String projectName = antDoc.valueOf("/project/@name");
        nameElement.setText(projectName);
        String description = antDoc.valueOf("/project/description");
        this.insertDocumentation(projectElement, description);
        if (!antFile.contains("antlib.xml") && description.equals("")) {
            this.log("Project has no comment: " + projectName, 1);
        }
        Element defaultElement = projectElement.addElement("default");
        defaultElement.setText(antDoc.valueOf("/project/@default"));
        List importNodes = antDoc.selectNodes("//import");
        for (Element importCurrentNode : importNodes) {
            this.addTextElement(projectElement, "fileDependency", importCurrentNode.attributeValue("file"));
        }
        projectElement.addElement("pythonDependency");
        List execNodes = antDoc.selectNodes("//exec//arg");
        for (Element argNode : execNodes) {
            Pattern filePattern;
            Matcher fileMatcher;
            String argValue = argNode.attributeValue("value");
            if (argValue == null) {
                argValue = argNode.attributeValue("line");
            }
            if (argValue == null || !(fileMatcher = (filePattern = Pattern.compile(".pl|.py|.bat|.xml|.txt")).matcher(argValue)).find()) continue;
            this.addTextElement(projectElement, "fileDependency", argValue);
        }
        List targetNodes = antDoc.selectNodes("//target");
        for (Element targetNode : targetNodes) {
            this.processTarget(targetNode, projectElement);
        }
        List macroNodes = antDoc.selectNodes("//macrodef | //scriptdef");
        for (Element macroNode : macroNodes) {
            this.processMacro(macroNode, projectElement, antFile);
        }
        List propertyNodes = antDoc.selectNodes("//property");
        for (Element propertyNode : propertyNodes) {
            this.processProperty(propertyNode, projectElement);
        }
    }

    public ArrayList getAntFiles() {
        return this.getAntFiles(this.getProject(), true);
    }

    public ArrayList getAntFiles(Project project) {
        return this.getAntFiles(project, true);
    }

    public ArrayList getAntFiles(Project project, boolean homeOnly) {
        ArrayList<String> antFiles = new ArrayList<String>();
        Hashtable targets = project.getTargets();
        Iterator targetsIter = targets.values().iterator();
        String projectHome = null;
        try {
            projectHome = new File(project.getProperty("helium.dir")).getCanonicalPath();
            while (targetsIter.hasNext()) {
                Target target = (Target)targetsIter.next();
                String projectPath = new File(target.getLocation().getFileName()).getCanonicalPath();
                if (antFiles.contains(projectPath)) continue;
                if (homeOnly) {
                    if (projectPath.contains(projectHome)) continue;
                    antFiles.add(projectPath);
                    continue;
                }
                antFiles.add(projectPath);
            }
            if (this.rc != null) {
                for (FileResource f : this.rc) {
                    String extrafile = f.getFile().getCanonicalPath();
                    if (antFiles.contains(f.toString()) || f.getFile().getName().startsWith("test_")) continue;
                    if (homeOnly) {
                        if (extrafile.contains(projectHome)) continue;
                        antFiles.add(extrafile);
                        continue;
                    }
                    antFiles.add(extrafile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return antFiles;
    }

    private void processMacro(Element macroNode, Element outProjectNode, String antFile) throws IOException, DocumentException {
        String macroName = macroNode.attributeValue("name");
        this.log("Processing macro: " + macroName, 4);
        Element outmacroNode = outProjectNode.addElement("macro");
        this.addTextElement(outmacroNode, "name", macroNode.attributeValue("name"));
        this.addTextElement(outmacroNode, "description", macroNode.attributeValue("description"));
        this.addTextElement(outmacroNode, "location", antFile + ":1:");
        List statements = macroNode.selectNodes("//scriptdef[@name='" + macroName + "']/attribute | //macrodef[@name='" + macroName + "']/attribute");
        String usage = "";
        for (Node statement : statements) {
            String defaultval = statement.valueOf("@default");
            defaultval = defaultval.equals("") ? "value" : "<i>" + defaultval + "</i>";
            usage = usage + " " + statement.valueOf("@name") + "=\"" + defaultval + "\"";
        }
        String macroElements = "";
        statements = macroNode.selectNodes("//scriptdef[@name='" + macroName + "']/element | //macrodef[@name='" + macroName + "']/element");
        for (Node statement : statements) {
            macroElements = "&lt;" + statement.valueOf("@name") + "/&gt;\n" + macroElements;
        }
        if (macroElements.equals("")) {
            this.addTextElement(outmacroNode, "usage", "&lt;hlm:" + macroName + " " + usage + "/&gt;");
        } else {
            this.addTextElement(outmacroNode, "usage", "&lt;hlm:" + macroName + " " + usage + "&gt;\n" + macroElements + "&lt;/hlm:" + macroName + "&gt;");
        }
        this.callAntTargetVisitor(macroNode, outmacroNode, outProjectNode);
        List children = macroNode.selectNodes("preceding-sibling::node()");
        if (children.size() > 0) {
            int index = children.size() - 1;
            Node child = (Node)children.get(index);
            while (index > 0 && child.getNodeType() == 3) {
                child = (Node)children.get(--index);
            }
            String commentText = null;
            if (child.getNodeType() == 8) {
                Comment macroComment = (Comment)child;
                commentText = macroComment.getStringValue().trim();
                this.log(macroName + " comment: " + commentText, 4);
            } else {
                this.log("Macro has no comment: " + macroName, 1);
            }
            this.insertDocumentation(outmacroNode, commentText);
            Node previousNode = (Node)children.get(children.size() - 1);
        }
        ArrayList properties = new ArrayList();
        AntPropertyVisitor visitor = new AntPropertyVisitor(properties);
        macroNode.accept((Visitor)visitor);
        for (String property : properties) {
            this.addTextElement(outmacroNode, "propertyDependency", property);
        }
    }

    private void callAntTargetVisitor(Element targetNode, Element outTargetNode, Element outProjectNode) {
        ArrayList antcallTargets = new ArrayList();
        ArrayList logs = new ArrayList();
        ArrayList signals = new ArrayList();
        ArrayList executables = new ArrayList();
        AntTargetVisitor visitorTarget = new AntTargetVisitor(antcallTargets, logs, signals, executables);
        targetNode.accept((Visitor)visitorTarget);
        for (String antcallTarget : antcallTargets) {
            Element dependencyElement = this.addTextElement(outTargetNode, "dependency", antcallTarget);
            dependencyElement.addAttribute("type", "exec");
        }
        for (String log : logs) {
            this.addTextElement(outTargetNode, "log", log);
        }
        if (this.globalSignalList.get(targetNode.attributeValue("name")) != null) {
            signals.addAll(this.globalSignalList.get(targetNode.attributeValue("name")));
        }
        for (String signal : signals) {
            this.addTextElement(outTargetNode, "signal", signal);
        }
        for (String executable : executables) {
            this.addTextElement(outTargetNode, "executable", executable);
        }
    }

    private void processTarget(Element targetNode, Element outProjectNode) throws IOException, DocumentException {
        String targetName = targetNode.attributeValue("name");
        this.log("Processing target: " + targetName, 4);
        String commentText = "";
        List children = targetNode.selectNodes("preceding-sibling::node()");
        if (children.size() > 0) {
            int index = children.size() - 1;
            Node child = (Node)children.get(index);
            while (index > 0 && child.getNodeType() == 3) {
                child = (Node)children.get(--index);
            }
            if (child.getNodeType() == 8) {
                Comment targetComment = (Comment)child;
                commentText = targetComment.getStringValue().trim();
                this.log(targetName + " comment: " + commentText, 4);
            } else {
                this.log("Target has no comment: " + targetName, 1);
            }
            Node previousNode = (Node)children.get(children.size() - 1);
        }
        if (!commentText.contains("Private:")) {
            Element outTargetNode = outProjectNode.addElement("target");
            this.addTextElement(outTargetNode, "name", targetNode.attributeValue("name"));
            this.addTextElement(outTargetNode, "ifDependency", targetNode.attributeValue("if"));
            this.addTextElement(outTargetNode, "unlessDependency", targetNode.attributeValue("unless"));
            this.addTextElement(outTargetNode, "description", targetNode.attributeValue("description"));
            this.addTextElement(outTargetNode, "tasks", String.valueOf(targetNode.elements().size()));
            Project project = this.getProject();
            Target antTarget = (Target)project.getTargets().get(targetName);
            if (antTarget == null) {
                return;
            }
            this.addTextElement(outTargetNode, "location", antTarget.getLocation().toString());
            Enumeration dependencies = antTarget.getDependencies();
            while (dependencies.hasMoreElements()) {
                String dependency = (String)dependencies.nextElement();
                Element dependencyElement = this.addTextElement(outTargetNode, "dependency", dependency);
                dependencyElement.addAttribute("type", "direct");
            }
            this.callAntTargetVisitor(targetNode, outTargetNode, outProjectNode);
            this.insertDocumentation(outTargetNode, commentText);
            ArrayList properties = new ArrayList();
            AntPropertyVisitor visitor = new AntPropertyVisitor(properties);
            targetNode.accept((Visitor)visitor);
            for (String property : properties) {
                this.addTextElement(outTargetNode, "propertyDependency", property);
            }
            String targetXml = targetNode.asXML();
            targetXml = targetXml.replace("]]>", "] ]>");
            this.addTextElement(outTargetNode, "source", targetXml, true);
        }
    }

    private void processProperty(Element propertyNode, Element outProjectNode) throws IOException {
        String propertyName = propertyNode.attributeValue("name");
        this.log("Processing Property: " + propertyName, 4);
        Element outPropertyNode = outProjectNode.addElement("property");
        this.addTextElement(outPropertyNode, "name", propertyNode.attributeValue("name"));
        if (propertyNode.attributeValue("value") == null) {
            this.addTextElement(outPropertyNode, "defaultValue", propertyNode.attributeValue("location"));
        } else {
            this.addTextElement(outPropertyNode, "defaultValue", propertyNode.attributeValue("value"));
        }
    }

    private void insertDocumentation(Element outNode, String commentText) throws IOException, DocumentException {
        if (commentText != null) {
            String commentTextCheck;
            WikiModel wikiModel = new WikiModel("", "");
            if (!commentText.contains("</pre>") && (commentText.contains("**") || commentText.contains("==") || commentText.contains("- -"))) {
                commentText = commentText.replace("**", "").replace("==", "").replace("- -", "").trim();
                this.log("Warning: Comment code has invalid syntax: " + commentText, 1);
            }
            if (commentText.startsWith("-")) {
                commentText = commentText.replace("-", "");
            }
            if ((commentTextCheck = (commentText = commentText.trim()).replace("deprecated>", "").replace("tt>", "").replace("todo>", "")).contains(">") && !commentTextCheck.contains("</pre>")) {
                this.log("Warning: Comment code needs <pre> tags around it: " + commentText, 1);
            }
            commentText = this.filterTextNewlines(commentText);
            if ((commentText = wikiModel.render(commentText)).indexOf("&#60;deprecated&#62;") != -1) {
                int deprecatedMsgStart = commentText.indexOf("&#60;deprecated&#62;") + 20;
                int deprecatedMsgEnd = commentText.indexOf("&#60;/deprecated&#62;");
                String deprecatedMsg = commentText.substring(deprecatedMsgStart, deprecatedMsgEnd);
                this.addTextElement(outNode, "deprecated", deprecatedMsg);
                int commentTextLength = commentText.length();
                String documentationMsgStart = commentText.substring(1, deprecatedMsgStart - 20);
                String documentationMsgEnd = commentText.substring(deprecatedMsgEnd + 21, commentTextLength);
                String documentationMsg = documentationMsgStart.concat(documentationMsgEnd);
                commentText = documentationMsg.trim();
            }
        } else {
            commentText = "";
        }
        String documentationText = "<documentation>" + commentText + "</documentation>";
        Document docDoc = DocumentHelper.parseText((String)documentationText);
        outNode.add(docDoc.getRootElement());
        this.log("HTML comment: " + commentText, 4);
    }

    private Element addTextElement(Element parent, String name, String text) {
        Element element = this.addTextElement(parent, name, text, false);
        return element;
    }

    private Element addTextElement(Element parent, String name, String text, boolean escape) {
        Element element = parent.addElement(name);
        if (text != null) {
            if (escape) {
                element.addCDATA(text);
            } else {
                element.setText(text);
            }
        }
        return element;
    }

    private String filterTextNewlines(String text) throws IOException {
        BufferedReader in = new BufferedReader(new StringReader(text));
        StringBuilder out = new StringBuilder();
        String line = in.readLine();
        while (line != null) {
            out.append(line.trim());
            out.append("\n");
            line = in.readLine();
        }
        return out.toString();
    }

    private class AntTargetVisitor
    extends VisitorSupport {
        private List targetList;
        private List logList;
        private List signalList;
        private List executableList;

        public AntTargetVisitor(List targetList) {
            this.targetList = targetList;
        }

        public AntTargetVisitor(List targetList, List logList, List signalList, List executableList) {
            this.targetList = targetList;
            this.logList = logList;
            this.signalList = signalList;
            this.executableList = executableList;
        }

        public void visit(Element node) {
            String text;
            String name = node.getName();
            if (name.equals("antcall") || name.equals("runtarget")) {
                text = node.attributeValue("target");
                this.extractTarget(text);
            }
            if (!name.equals("include") && !name.equals("exclude")) {
                text = node.attributeValue("name");
                this.addLog(text);
                text = node.attributeValue("output");
                this.addLog(text);
                text = node.attributeValue("value");
                this.addLog(text);
                text = node.attributeValue("log");
                this.addLog(text);
                text = node.attributeValue("line");
                this.addLog(text);
                text = node.attributeValue("file");
                this.addLog(text);
            }
            if (name.equals("signal") || name.equals("execSignal")) {
                String signalid = Database.this.getProject().replaceProperties(node.attributeValue("name"));
                String failbuild = Database.this.signalType(signalid, Database.this.signaldoc);
                if (this.signalList != null) {
                    if (failbuild != null) {
                        this.signalList.add(signalid + "," + failbuild);
                    } else {
                        this.signalList.add(signalid);
                    }
                }
            }
            if (name.equals("exec") || name.equals("preset.exec")) {
                text = node.attributeValue("executable");
                this.executableList.add(text);
                Database.this.log("Executable: " + text, 4);
            }
        }

        private void addLog(String text) {
            if (text != null && this.logList != null) {
                for (String log : text.split(" ")) {
                    String fulllogname = Database.this.getProject().replaceProperties(log);
                    if (this.logList.contains(log) || !fulllogname.endsWith(".log") && !fulllogname.endsWith(".html")) continue;
                    log = log.replace("--log=", "");
                    this.logList.add(log);
                }
            }
        }

        private void extractTarget(String text) {
            String iText = Database.this.getProject().replaceProperties(text);
            this.targetList.add(iText);
        }
    }

    private class AntPropertyVisitor
    extends VisitorSupport {
        private List propertyList;

        public AntPropertyVisitor(List propertyList) {
            this.propertyList = propertyList;
        }

        public void visit(Attribute node) {
            String text = node.getStringValue();
            this.extractUsedProperties(text);
        }

        public void visit(CDATA node) {
            String text = node.getText();
            this.extractUsedProperties(text);
        }

        public void visit(Text node) {
            String text = node.getText();
            this.extractUsedProperties(text);
        }

        public void visit(Element node) {
            String propertyName;
            if (node.getName().equals("property") && !this.propertyList.contains(propertyName = node.attributeValue("name"))) {
                this.propertyList.add(propertyName);
                Database.this.log("property matches :" + propertyName, 4);
            }
        }

        private void extractUsedProperties(String text) {
            Pattern p1 = Pattern.compile("\\$\\{([^@$}]*)\\}");
            Matcher m1 = p1.matcher(text);
            Database.this.log(text, 4);
            while (m1.find()) {
                String group = m1.group(1);
                if (!this.propertyList.contains(group)) {
                    this.propertyList.add(group);
                }
                Database.this.log("property matches: " + group, 4);
            }
            Pattern p2 = Pattern.compile("\\$\\{([^\n]*\\})\\}");
            Matcher m2 = p2.matcher(text);
            Database.this.log(text, 4);
            while (m2.find()) {
                String group = m2.group(1);
                if (!this.propertyList.contains(group)) {
                    this.propertyList.add(group);
                }
                Database.this.log("property matches: " + group, 4);
            }
            Pattern p3 = Pattern.compile("\\$\\{(\\@\\{[^\n]*)\\}");
            Matcher m3 = p3.matcher(text);
            Database.this.log(text, 4);
            while (m3.find()) {
                String group = m3.group(1);
                if (!this.propertyList.contains(group)) {
                    this.propertyList.add(group);
                }
                Database.this.log("property matches: " + group, 4);
            }
        }
    }
}

