/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.AbstractTaskWindow;
import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.ActionComponent;
import com.sardak.antform.types.BaseType;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Sequential;

public class Wait
extends BaseType
implements SubBuildListener {
    private String label = "Please wait ...";
    private boolean showProgress = true;
    private boolean closeWhenDone = false;
    private Sequential sequential;
    private JProgressBar progressBar;
    private JLabel labelComponent;
    private Project project;
    private Thread createdThread;
    private ControlPanel controlPanel;
    private AbstractTaskWindow task;

    public Wait(Project project) {
        this.project = project;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public void setCloseWhenDone(boolean closeWhenDone) {
        this.closeWhenDone = closeWhenDone;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addConfiguredSequential(Sequential s) {
        this.sequential = s;
    }

    public void addToControlPanel(ControlPanel panel) {
        this.controlPanel = panel;
        this.controlPanel.addCentered(this.buildPanel());
        if (this.sequential != null) {
            this.createdThread = new Thread(){

                public void run() {
                    Wait.this.sequential.perform();
                }
            };
            this.createdThread.start();
            this.sequential.getProject().addBuildListener((BuildListener)this);
        }
    }

    private void executionDone() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(100);
        this.labelComponent.setText("Done");
    }

    private JPanel buildPanel() {
        JPanel widgetPanel = new JPanel(new GridLayout(0, 1));
        if (this.showProgress) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(false);
            this.progressBar.setIndeterminate(true);
            widgetPanel.add(this.progressBar);
        }
        this.labelComponent = new JLabel(this.label);
        widgetPanel.add(this.labelComponent);
        return widgetPanel;
    }

    public void buildStarted(BuildEvent evt) {
    }

    public void buildFinished(BuildEvent evt) {
        this.project.log("Received buildFinished event in Wait widget", 4);
        this.waitForThread(evt);
    }

    public void targetStarted(BuildEvent evt) {
    }

    public void targetFinished(BuildEvent evt) {
    }

    public void taskStarted(BuildEvent evt) {
    }

    public void taskFinished(BuildEvent evt) {
        this.project.log("Received taskFinished event in Wait", 4);
        if (evt.getTask().equals(this.sequential)) {
            this.executionDone();
            if (this.closeWhenDone) {
                HiddenButton button = new HiddenButton();
                this.task.getActionRegistry().register(button);
                ActionEvent event = new ActionEvent(button.getComponent(), 1001, null);
                this.task.getActionRegistry().actionPerformed(event);
            }
        }
    }

    public void messageLogged(BuildEvent evt) {
    }

    public void subBuildStarted(BuildEvent evt) {
    }

    public void subBuildFinished(BuildEvent evt) {
        this.project.log("Received subbuildFinished event in Wait widget", 4);
        this.waitForThread(evt);
    }

    private void waitForThread(BuildEvent evt) {
        if (this.createdThread != null && this.sequential.getProject().equals(evt.getProject()) && this.createdThread.isAlive()) {
            this.project.log("Waiting for background threads completion...", 3);
            try {
                this.createdThread.join();
            }
            catch (InterruptedException ie) {
                this.project.log("Thread " + this.createdThread.getName() + " got interrupted: " + ie.getMessage(), 4);
            }
        }
    }

    public boolean validate(Task task) {
        boolean attributesAreValid = true;
        if (this.sequential == null) {
            task.log("Wait : Nothing to wait for.");
            attributesAreValid = false;
        }
        this.task = (AbstractTaskWindow)task;
        return attributesAreValid;
    }

    private class HiddenButton
    implements ActionComponent {
        JButton button = new JButton();

        private HiddenButton() {
        }

        public int getActionType() {
            return 1;
        }

        public String getTarget() {
            return null;
        }

        public boolean isBackground() {
            return false;
        }

        public AbstractButton getComponent() {
            return this.button;
        }

        public boolean isLoopExit() {
            return true;
        }

        public boolean isNewProject() {
            return true;
        }
    }
}

