/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReportParser {
    private SaxXmlReportParser parser = null;

    public void parse(File report) throws ParseException {
        if (!report.exists()) {
            throw new IllegalStateException("Report file '" + report.getAbsolutePath() + "' does not exist.");
        }
        this.parser = new SaxXmlReportParser(report);
        try {
            this.parser.parse();
        }
        catch (Exception e) {
            ParseException pe = new ParseException("failed to parse report: " + report + ": " + e.getMessage(), 0);
            pe.initCause(e);
            throw pe;
        }
    }

    public Artifact[] getArtifacts() {
        return this.parser.getArtifacts().toArray(new Artifact[this.parser.getArtifacts().size()]);
    }

    public ArtifactDownloadReport[] getArtifactReports() {
        return this.parser.getArtifactReports().toArray(new ArtifactDownloadReport[this.parser.getArtifactReports().size()]);
    }

    public ModuleRevisionId[] getDependencyRevisionIds() {
        return this.parser.getModuleRevisionIds().toArray(new ModuleRevisionId[this.parser.getModuleRevisionIds().size()]);
    }

    public ModuleRevisionId[] getRealDependencyRevisionIds() {
        return this.parser.getRealModuleRevisionIds().toArray(new ModuleRevisionId[this.parser.getRealModuleRevisionIds().size()]);
    }

    public MetadataArtifactDownloadReport getMetadataArtifactReport(ModuleRevisionId id) {
        return this.parser.getMetadataArtifactReport(id);
    }

    public ModuleRevisionId getResolvedModule() {
        return this.parser.getResolvedModule();
    }

    private static class SaxXmlReportParser {
        private List mrids;
        private List defaultMrids;
        private List realMrids;
        private List artifacts = new ArrayList();
        private List artifactReports = new ArrayList();
        private Map metadataReports;
        private ModuleRevisionId mRevisionId;
        private File report;

        SaxXmlReportParser(File report) {
            this.mrids = new ArrayList();
            this.defaultMrids = new ArrayList();
            this.realMrids = new ArrayList();
            this.metadataReports = new HashMap();
            this.report = report;
        }

        public void parse() throws Exception {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(this.report, new DefaultHandler(){
                private String organisation;
                private String module;
                private String branch;
                private String revision;
                private int position;
                private Date pubdate;
                private boolean skip;
                private ModuleRevisionId mrid;
                private boolean isDefault;
                private SortedMap revisionsMap = new TreeMap();
                private List revisionArtifacts = null;

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("module".equals(qName)) {
                        this.organisation = attributes.getValue("organisation");
                        this.module = attributes.getValue("name");
                    } else if ("revision".equals(qName)) {
                        this.revisionArtifacts = new ArrayList();
                        this.branch = attributes.getValue("branch");
                        this.revision = attributes.getValue("name");
                        this.isDefault = Boolean.valueOf(attributes.getValue("default"));
                        String pos = attributes.getValue("position");
                        int n = this.position = pos == null ? this.getMaxPos() + 1 : Integer.valueOf(pos);
                        if (attributes.getValue("error") != null || attributes.getValue("evicted") != null) {
                            this.skip = true;
                        } else {
                            this.revisionsMap.put(new Integer(this.position), this.revisionArtifacts);
                            this.mrid = ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision, ExtendableItemHelper.getExtraAttributes(attributes, "extra-"));
                            SaxXmlReportParser.this.mrids.add(this.mrid);
                            if (this.isDefault) {
                                SaxXmlReportParser.this.defaultMrids.add(this.mrid);
                            } else {
                                Artifact metadataArtifact = DefaultArtifact.newIvyArtifact(this.mrid, this.pubdate);
                                MetadataArtifactDownloadReport madr = new MetadataArtifactDownloadReport(metadataArtifact);
                                SaxXmlReportParser.this.metadataReports.put(this.mrid, madr);
                                SaxXmlReportParser.this.realMrids.add(this.mrid);
                            }
                            try {
                                this.pubdate = Ivy.DATE_FORMAT.parse(attributes.getValue("pubdate"));
                                this.skip = false;
                            }
                            catch (ParseException e) {
                                throw new IllegalArgumentException("invalid publication date for " + this.organisation + " " + this.module + " " + this.revision + ": " + attributes.getValue("pubdate"));
                            }
                        }
                    } else if ("metadata-artifact".equals(qName)) {
                        if (this.skip) {
                            return;
                        }
                        MetadataArtifactDownloadReport madr = (MetadataArtifactDownloadReport)SaxXmlReportParser.this.metadataReports.get(this.mrid);
                        if (madr != null) {
                            madr.setDownloadStatus(DownloadStatus.fromString(attributes.getValue("status")));
                            madr.setDownloadDetails(attributes.getValue("details"));
                            madr.setSize(Long.parseLong(attributes.getValue("size")));
                            madr.setDownloadTimeMillis(Long.parseLong(attributes.getValue("time")));
                            madr.setSearched(SaxXmlReportParser.parseBoolean(attributes.getValue("searched")));
                            if (attributes.getValue("location") != null) {
                                madr.setLocalFile(new File(attributes.getValue("location")));
                            }
                            if (attributes.getValue("original-local-location") != null) {
                                madr.setOriginalLocalFile(new File(attributes.getValue("original-local-location")));
                            }
                            if (attributes.getValue("origin-location") != null) {
                                if (ArtifactOrigin.UNKNOWN.getLocation().equals(attributes.getValue("origin-location"))) {
                                    madr.setArtifactOrigin(ArtifactOrigin.UNKNOWN);
                                } else {
                                    madr.setArtifactOrigin(new ArtifactOrigin(SaxXmlReportParser.parseBoolean(attributes.getValue("origin-is-local")), attributes.getValue("origin-location")));
                                }
                            }
                        }
                    } else if ("artifact".equals(qName)) {
                        if (this.skip) {
                            return;
                        }
                        String status = attributes.getValue("status");
                        String artifactName = attributes.getValue("name");
                        String type = attributes.getValue("type");
                        String ext = attributes.getValue("ext");
                        DefaultArtifact artifact = new DefaultArtifact(this.mrid, this.pubdate, artifactName, type, ext, ExtendableItemHelper.getExtraAttributes(attributes, "extra-"));
                        ArtifactDownloadReport aReport = new ArtifactDownloadReport(artifact);
                        aReport.setDownloadStatus(DownloadStatus.fromString(status));
                        aReport.setDownloadDetails(attributes.getValue("details"));
                        aReport.setSize(Long.parseLong(attributes.getValue("size")));
                        aReport.setDownloadTimeMillis(Long.parseLong(attributes.getValue("time")));
                        if (attributes.getValue("location") != null) {
                            aReport.setLocalFile(new File(attributes.getValue("location")));
                        }
                        this.revisionArtifacts.add(aReport);
                    } else if ("origin-location".equals(qName)) {
                        if (this.skip) {
                            return;
                        }
                        ArtifactDownloadReport aReport = (ArtifactDownloadReport)this.revisionArtifacts.get(this.revisionArtifacts.size() - 1);
                        if (ArtifactOrigin.UNKNOWN.getLocation().equals(attributes.getValue("location"))) {
                            aReport.setArtifactOrigin(ArtifactOrigin.UNKNOWN);
                        } else {
                            aReport.setArtifactOrigin(new ArtifactOrigin(SaxXmlReportParser.parseBoolean(attributes.getValue("is-local")), attributes.getValue("location")));
                        }
                    } else if ("info".equals(qName)) {
                        String organisation = attributes.getValue("organisation");
                        String name = attributes.getValue("module");
                        String branch = attributes.getValue("branch");
                        String revision = attributes.getValue("revision");
                        HashMap<String, String> extraAttributes = new HashMap<String, String>();
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            String attName = attributes.getQName(i);
                            if (!attName.startsWith("extra-")) continue;
                            String extraAttrName = attName.substring("extra-".length());
                            String extraAttrValue = attributes.getValue(i);
                            extraAttributes.put(extraAttrName, extraAttrValue);
                        }
                        SaxXmlReportParser.this.mRevisionId = ModuleRevisionId.newInstance(organisation, name, branch, revision, extraAttributes);
                    }
                }

                public void endElement(String uri, String localName, String qname) throws SAXException {
                    if ("dependencies".equals(qname)) {
                        Iterator it = this.revisionsMap.values().iterator();
                        while (it.hasNext()) {
                            List artifactReports = (List)it.next();
                            SaxXmlReportParser.this.artifactReports.addAll(artifactReports);
                            Iterator iter = artifactReports.iterator();
                            while (iter.hasNext()) {
                                ArtifactDownloadReport artifactReport = (ArtifactDownloadReport)iter.next();
                                if (artifactReport.getDownloadStatus() == DownloadStatus.FAILED) continue;
                                SaxXmlReportParser.this.artifacts.add(artifactReport.getArtifact());
                            }
                        }
                    }
                }

                private int getMaxPos() {
                    return this.revisionsMap.isEmpty() ? -1 : (Integer)this.revisionsMap.keySet().toArray()[this.revisionsMap.size() - 1];
                }
            });
        }

        private static boolean parseBoolean(String str) {
            return str != null && str.equalsIgnoreCase("true");
        }

        public List getArtifacts() {
            return this.artifacts;
        }

        public List getArtifactReports() {
            return this.artifactReports;
        }

        public List getModuleRevisionIds() {
            return this.mrids;
        }

        public List getRealModuleRevisionIds() {
            return this.realMrids;
        }

        public ModuleRevisionId getResolvedModule() {
            return this.mRevisionId;
        }

        public MetadataArtifactDownloadReport getMetadataArtifactReport(ModuleRevisionId id) {
            return (MetadataArtifactDownloadReport)this.metadataReports.get(id);
        }
    }
}

