/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.maven.scm.provider.hg.command.tag;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.Command;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.provider.hg.command.inventory.HgListConsumer;
import org.apache.maven.scm.provider.hg.command.tag.HgTagConsumer;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class HgTagCommand
extends AbstractTagCommand
implements Command {
    protected ScmResult executeTagCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String tag, String level) throws ScmException {
        if (tag == null || StringUtils.isEmpty((String)tag.trim())) {
            throw new ScmException("tag must be specified");
        }
        if (fileSet.getFileList().size() != 0) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        File workingDir = fileSet.getBasedir();
        String[] tagCmd = level.equals(new String("local")) ? new String[]{"tag", "--local", "--message", "[maven-scm] copy for tag " + tag, tag} : new String[]{"tag", "--message", "[maven-scm] copy for tag " + tag, tag};
        StringBuffer cmd = this.joinCmd(tagCmd);
        HgTagConsumer consumer = new HgTagConsumer(this.getLogger());
        ScmResult result = HgUtils.execute((HgConsumer)consumer, (ScmLogger)this.getLogger(), (File)workingDir, (String[])tagCmd);
        HgScmProviderRepository repository = (HgScmProviderRepository)scmProviderRepository;
        if (result.isSuccess()) {
            if (!repository.getURI().equals(fileSet.getBasedir().getAbsolutePath())) {
                String[] pushCmd = new String[]{"push", repository.getURI()};
                result = HgUtils.execute((HgConsumer)new HgConsumer(this.getLogger()), (ScmLogger)this.getLogger(), (File)fileSet.getBasedir(), (String[])pushCmd);
            }
        } else {
            throw new ScmException("Error while executing command " + cmd.toString());
        }
        String[] listCmd = new String[]{"locate"};
        HgListConsumer listconsumer = new HgListConsumer(this.getLogger());
        result = HgUtils.execute((HgConsumer)listconsumer, (ScmLogger)this.getLogger(), (File)fileSet.getBasedir(), (String[])listCmd);
        if (result.isSuccess()) {
            List files = listconsumer.getFiles();
            ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
            for (ScmFile scmFile : files) {
                if (scmFile.getPath().endsWith(".hgtags")) continue;
                fileList.add(new ScmFile(scmFile.getPath(), ScmFileStatus.TAGGED));
            }
            return new TagScmResult(fileList, result);
        }
        throw new ScmException("Error while executing command " + cmd.toString());
    }

    private StringBuffer joinCmd(String[] cmds) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        String[] arr$ = cmds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String cmd;
            String s = cmd = arr$[i$];
            result.append(s);
            if (i < cmds.length - 1) {
                result.append(" ");
            }
            ++i;
        }
        return result;
    }
}

