/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data;

import com.nokia.helium.ant.data.AntComment;
import com.nokia.helium.ant.data.AntFile;
import com.nokia.helium.ant.data.Database;
import com.nokia.helium.ant.data.RootAntObjectMeta;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.Node;

public class AntObjectMeta {
    public static final Map<String, Integer> SCOPES = new HashMap<String, Integer>(){
        {
            this.put(AntObjectMeta.DEFAULT_SCOPE, new Integer(1));
            this.put("protected", new Integer(2));
            this.put("private", new Integer(3));
        }
    };
    public static final String DEFAULT_SCOPE = "public";
    private static AntComment emptyComment;
    private Project rootProject;
    private AntObjectMeta parent;
    private Node node;
    private AntComment comment = emptyComment;

    public AntObjectMeta(AntObjectMeta parent, Node node) throws IOException {
        this.parent = parent;
        this.node = node;
        this.processComment();
    }

    public Project getRuntimeProject() {
        return this.rootProject;
    }

    public void setRuntimeProject(Project project) {
        this.rootProject = project;
    }

    protected String getAttr(String name) {
        String value;
        if (this.node.getNodeType() == 1 && (value = ((Element)this.node).attributeValue(name)) != null) {
            return value;
        }
        return "";
    }

    protected Node getNode() {
        return this.node;
    }

    protected AntComment getEmptyComment() {
        return emptyComment;
    }

    public RootAntObjectMeta getRootMeta() {
        if (this.parent instanceof RootAntObjectMeta) {
            return (RootAntObjectMeta)this.parent;
        }
        return this.parent.getRootMeta();
    }

    public AntFile getAntFile() {
        return this.getRootMeta().getAntFile();
    }

    public Database getDatabase() {
        return this.getAntFile().getDatabase();
    }

    public String getName() {
        String name = this.getAttr("name");
        if (name.length() == 0 && (name = this.getComment().getObjectName()).length() == 0) {
            try {
                System.out.println("name is 0 length: " + this.getLocation());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return name;
    }

    public String getLocation() throws IOException {
        RootAntObjectMeta rootMeta = this.getRootMeta();
        return rootMeta.getFile().getCanonicalPath();
    }

    public String getSummary() {
        return this.getComment().getSummary();
    }

    public String getDocumentation() {
        return this.getComment().getDocumentation();
    }

    public String getScope() {
        String scope = this.getComment().getTagValue("scope");
        if (scope.equals("")) {
            scope = DEFAULT_SCOPE;
        }
        return scope;
    }

    public boolean matchesScope(String scopeFilter) {
        if (!SCOPES.containsKey(scopeFilter)) {
            throw new IllegalArgumentException("Invalid scope filter: " + scopeFilter);
        }
        String scope = this.getScope();
        if (!SCOPES.containsKey(scope)) {
            this.log("Invalid scope: " + scope + ", " + this.toString(), 1);
            return false;
        }
        return SCOPES.get(scope).compareTo(SCOPES.get(scopeFilter)) <= 0;
    }

    public String getDeprecated() {
        return this.comment.getTagValue("deprecated");
    }

    public String getSource() {
        String sourceXml = this.node.asXML();
        sourceXml = sourceXml.replace("]]>", "] ]>");
        return sourceXml;
    }

    protected AntComment getComment() {
        return this.comment;
    }

    protected void setComment(AntComment comment) {
        this.comment = comment;
    }

    private void processComment() throws IOException {
        Comment commentNode = this.getCommentNode();
        if (commentNode != null) {
            this.comment = new AntComment(commentNode);
        }
    }

    private Comment getCommentNode() {
        Node commentNode = null;
        if (this.node.getNodeType() == 8) {
            commentNode = this.node;
        } else {
            List children = this.node.selectNodes("preceding-sibling::node()");
            if (children.size() > 0) {
                int index = children.size() - 1;
                Node child = (Node)children.get(index);
                while (index > 0 && child.getNodeType() == 3) {
                    child = (Node)children.get(--index);
                }
                if (child.getNodeType() == 8) {
                    commentNode = child;
                    this.log("Node has comment: " + this.node.getStringValue(), 4);
                } else {
                    this.log("Node has no comment: " + this.node.toString(), 1);
                }
            }
        }
        return (Comment)commentNode;
    }

    public void log(String text, int level) {
        Project project = this.getRuntimeProject();
        if (project != null) {
            project.log(text, level);
        }
    }

    static {
        try {
            emptyComment = new AntComment();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

