/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.maven.scm.provider.hg.command.log;

import com.nokia.maven.scm.provider.hg.VersionChangeSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

public class HgChangeLogConsumer
extends HgConsumer {
    private static final String TIME_PATTERN = "EEE MMM dd HH:mm:ss yyyy Z";
    private static final String REVNO_TAG = "changeset: ";
    private static final String TAG_BRANCH = "branch: ";
    private static final String TAG_TAG = "tag: ";
    private static final String AUTHOR_TAG = "user: ";
    private static final String TIME_STAMP_TOKEN = "date: ";
    private static final String MESSAGE_TOKEN = "description:";
    private static final String MERGED_TOKEN = "merged: ";
    private static final String FILES_TOKEN = "files: ";
    private String prevLine = "";
    private String prevPrevLine = "";
    private ArrayList<VersionChangeSet> logEntries = new ArrayList();
    private VersionChangeSet currentChange;
    private VersionChangeSet lastChange;
    private boolean isMergeEntry;
    private String currentRevision;
    private String currentTag;
    private String currentBranch;
    private String userDatePattern;
    private boolean spoolingComments;
    private List<String> currentComment;

    public HgChangeLogConsumer(ScmLogger logger, String userDatePattern) {
        super(logger);
        this.userDatePattern = userDatePattern;
    }

    public List<VersionChangeSet> getModifications() {
        return this.logEntries;
    }

    public void consumeLine(String line) {
        this.doConsume(null, line);
    }

    public void doConsume(ScmFileStatus status, String line) {
        String tmpLine = line;
        if (line.equals("") && this.prevLine.equals("") && this.prevPrevLine.equals("") || this.currentComment == null) {
            CharSequence comment;
            if (this.currentComment != null) {
                comment = new StringBuffer();
                int i = 0;
                for (String eachComment : this.currentComment) {
                    ((StringBuffer)comment).append(eachComment);
                    if (i + 1 < this.currentComment.size() - 1) {
                        ((StringBuffer)comment).append('\n');
                    }
                    ++i;
                }
                this.currentChange.setComment(((StringBuffer)comment).toString());
            }
            this.spoolingComments = false;
            if (this.isMergeEntry && this.lastChange != null) {
                comment = this.lastChange.getComment();
                comment = (String)comment + "\n[MAVEN]: Merged from " + this.currentChange.getAuthor();
                comment = (String)comment + "\n[MAVEN]:    " + this.currentChange.getDateFormatted();
                comment = (String)comment + "\n[MAVEN]:    " + this.currentChange.getComment();
                this.lastChange.setComment((String)comment);
            }
            this.currentChange = new VersionChangeSet();
            this.currentChange.setFiles(new ArrayList());
            this.logEntries.add(this.currentChange);
            this.currentComment = new ArrayList<String>();
            this.currentRevision = "";
            this.isMergeEntry = false;
        }
        if (this.spoolingComments) {
            this.currentComment.add(line);
        } else if (line.startsWith(MESSAGE_TOKEN)) {
            this.spoolingComments = true;
        } else if (line.startsWith(MERGED_TOKEN)) {
            this.isMergeEntry = true;
            this.logEntries.remove((Object)this.currentChange);
            if (this.logEntries.size() > 0) {
                this.lastChange = this.logEntries.get(this.logEntries.size() - 1);
            } else {
                this.getLogger().warn("First entry was unexpectedly a merged entry");
                this.lastChange = null;
            }
        } else if (line.startsWith(REVNO_TAG)) {
            this.currentRevision = tmpLine = line.substring(REVNO_TAG.length()).trim();
            try {
                this.currentChange.setScmVersion((ScmVersion)new ScmRevision(tmpLine));
            }
            catch (ScmException se) {
                this.getLogger().warn(se.getMessage());
            }
        } else if (line.startsWith(TAG_TAG)) {
            this.currentTag = tmpLine = line.substring(TAG_TAG.length()).trim();
            try {
                this.currentChange.setScmVersion((ScmVersion)new ScmTag(tmpLine));
            }
            catch (ScmException se) {
                this.getLogger().warn(se.getMessage());
            }
        } else if (line.startsWith(TAG_BRANCH)) {
            this.currentBranch = tmpLine = line.substring(TAG_BRANCH.length()).trim();
            try {
                this.currentChange.setScmVersion((ScmVersion)new ScmBranch(tmpLine));
            }
            catch (ScmException se) {
                this.getLogger().warn(se.getMessage());
            }
        } else if (line.startsWith(AUTHOR_TAG)) {
            tmpLine = line.substring(AUTHOR_TAG.length());
            tmpLine = tmpLine.trim();
            this.currentChange.setAuthor(tmpLine);
        } else if (line.startsWith(TIME_STAMP_TOKEN)) {
            tmpLine = line.substring(TIME_STAMP_TOKEN.length()).trim();
            Date date = null;
            try {
                SimpleDateFormat format = new SimpleDateFormat(TIME_PATTERN);
                date = format.parse(tmpLine);
                this.currentChange.setDate(date);
            }
            catch (Exception e) {
                this.getLogger().warn("Consumer Change Log Date Format not supported:" + e.getMessage());
            }
        } else if (line.startsWith(FILES_TOKEN)) {
            String[] files;
            tmpLine = line.substring(FILES_TOKEN.length()).trim();
            for (String eachFile : files = tmpLine.split(" ")) {
                ChangeFile changeFile = new ChangeFile(eachFile, this.currentRevision);
                this.currentChange.addFile(changeFile);
            }
        } else if (!line.equals("")) {
            this.getLogger().warn("Could not figure out: " + line);
        }
        this.prevPrevLine = this.prevLine = line;
    }
}

