/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.deliver.DeliverOptions;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.publish.PublishOptions;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.DefaultMessageLogger;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerDispatcher;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class Main {
    private static final int DEPENDENCY_ARG_COUNT = 3;

    private static Options getOptions() {
        OptionBuilder.withArgName((String)"settingsfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file for settings");
        Option settings = OptionBuilder.create((String)"settings");
        OptionBuilder.withArgName((String)"settingsfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"DEPRECATED - use given file for settings");
        Option conf = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"cachedir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given directory for cache");
        Option cache = OptionBuilder.create((String)"cache");
        OptionBuilder.withArgName((String)"ivyfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as ivy file");
        Option ivyfile = OptionBuilder.create((String)"ivy");
        OptionBuilder.withArgName((String)"organisation module revision");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"use this instead of ivy file to do the rest of the work with this as a dependency.");
        Option dependency = OptionBuilder.create((String)"dependency");
        OptionBuilder.withArgName((String)"configurations");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"resolve given configurations");
        Option confs = OptionBuilder.create((String)"confs");
        OptionBuilder.withArgName((String)"retrievepattern");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given pattern as retrieve pattern");
        Option retrieve = OptionBuilder.create((String)"retrieve");
        OptionBuilder.withArgName((String)"cachepathfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"outputs a classpath consisting of all dependencies in cache (including transitive ones) of the given ivy file to the given cachepathfile");
        Option cachepath = OptionBuilder.create((String)"cachepath");
        OptionBuilder.withArgName((String)"revision");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given revision to publish the module");
        Option revision = OptionBuilder.create((String)"revision");
        OptionBuilder.withArgName((String)"status");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given status to publish the module");
        Option status = OptionBuilder.create((String)"status");
        OptionBuilder.withArgName((String)"ivypattern");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given pattern as resolved ivy file pattern");
        Option deliver = OptionBuilder.create((String)"deliverto");
        OptionBuilder.withArgName((String)"resolvername");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given resolver to publish to");
        Option publishResolver = OptionBuilder.create((String)"publish");
        OptionBuilder.withArgName((String)"artpattern");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given pattern to find artifacts to publish");
        Option publishPattern = OptionBuilder.create((String)"publishpattern");
        OptionBuilder.withArgName((String)"realm");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given realm for HTTP AUTH");
        Option realm = OptionBuilder.create((String)"realm");
        OptionBuilder.withArgName((String)"host");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given host for HTTP AUTH");
        Option host = OptionBuilder.create((String)"host");
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given username for HTTP AUTH");
        Option username = OptionBuilder.create((String)"username");
        OptionBuilder.withArgName((String)"passwd");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given password for HTTP AUTH");
        Option passwd = OptionBuilder.create((String)"passwd");
        OptionBuilder.withArgName((String)"main");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the main class to runtime process");
        Option main = OptionBuilder.create((String)"main");
        OptionBuilder.withArgName((String)"args");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"the arguments to runtime process");
        Option args = OptionBuilder.create((String)"args");
        OptionBuilder.withArgName((String)"cp");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"extra classpath, used only in combination with option main");
        Option cp = OptionBuilder.create((String)"cp");
        Options options = new Options();
        options.addOption("debug", false, "set message level to debug");
        options.addOption("verbose", false, "set message level to verbose");
        options.addOption("warn", false, "set message level to warn");
        options.addOption("error", false, "set message level to error");
        options.addOption("novalidate", false, "do not validate ivy files against xsd");
        options.addOption("useOrigin", false, "DEPRECATED: use original artifact location with local resolvers instead of copying to the cache");
        options.addOption("sync", false, "in conjonction with -retrieve, does a synced retrieve");
        options.addOption("m2compatible", false, "use maven2 compatibility");
        options.addOption("?", false, "display this help");
        options.addOption(conf);
        options.addOption(settings);
        options.addOption(confs);
        options.addOption(cache);
        options.addOption(ivyfile);
        options.addOption(dependency);
        options.addOption(retrieve);
        options.addOption(cachepath);
        options.addOption(revision);
        options.addOption(status);
        options.addOption(deliver);
        options.addOption(publishResolver);
        options.addOption(publishPattern);
        options.addOption(realm);
        options.addOption(host);
        options.addOption(username);
        options.addOption(passwd);
        options.addOption(main);
        options.addOption(args);
        options.addOption(cp);
        return options;
    }

    public static void main(String[] args) throws Exception {
        Options options = Main.getOptions();
        GnuParser parser = new GnuParser();
        try {
            File ivyfile;
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("?")) {
                Main.usage(options);
                return;
            }
            boolean validate = !line.hasOption("novalidate");
            Ivy ivy = Ivy.newInstance();
            Main.initMessage(line, ivy);
            IvySettings settings = Main.initSettings(line, options, ivy);
            File cache = new File(settings.substitute(line.getOptionValue("cache", settings.getDefaultCache().getAbsolutePath())));
            if (!cache.exists()) {
                cache.mkdirs();
            } else if (!cache.isDirectory()) {
                Main.error(options, cache + " is not a directory");
            }
            String[] confs = line.hasOption("confs") ? line.getOptionValues("confs") : new String[]{"*"};
            if (line.hasOption("dependency")) {
                String[] dep = line.getOptionValues("dependency");
                if (dep.length != 3) {
                    Main.error(options, "dependency should be expressed with exactly 3 arguments: organisation module revision");
                }
                ivyfile = File.createTempFile("ivy", ".xml");
                ivyfile.deleteOnExit();
                DefaultModuleDescriptor md = DefaultModuleDescriptor.newDefaultInstance(ModuleRevisionId.newInstance(dep[0], dep[1] + "-caller", "working"));
                DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, ModuleRevisionId.newInstance(dep[0], dep[1], dep[2]), false, false, true);
                for (int i = 0; i < confs.length; ++i) {
                    dd.addDependencyConfiguration("default", confs[i]);
                }
                md.addDependency(dd);
                XmlModuleDescriptorWriter.write(md, ivyfile);
                confs = new String[]{"default"};
            } else {
                ivyfile = new File(settings.substitute(line.getOptionValue("ivy", "ivy.xml")));
                if (!ivyfile.exists()) {
                    Main.error(options, "ivy file not found: " + ivyfile);
                } else if (ivyfile.isDirectory()) {
                    Main.error(options, "ivy file is not a file: " + ivyfile);
                }
            }
            if (line.hasOption("useOrigin")) {
                ivy.getSettings().useDeprecatedUseOrigin();
            }
            ResolveOptions resolveOptions = new ResolveOptions().setConfs(confs).setValidate(validate);
            ResolveReport report = ivy.resolve(ivyfile.toURI().toURL(), resolveOptions);
            if (report.hasError()) {
                System.exit(1);
            }
            ModuleDescriptor md = report.getModuleDescriptor();
            if (confs.length == 1 && "*".equals(confs[0])) {
                confs = md.getConfigurationsNames();
            }
            if (line.hasOption("retrieve")) {
                String retrievePattern = settings.substitute(line.getOptionValue("retrieve"));
                if (retrievePattern.indexOf("[") == -1) {
                    retrievePattern = retrievePattern + "/lib/[conf]/[artifact].[ext]";
                }
                ivy.retrieve(md.getModuleRevisionId(), retrievePattern, new RetrieveOptions().setConfs(confs).setSync(line.hasOption("sync")).setUseOrigin(line.hasOption("useOrigin")));
            }
            if (line.hasOption("cachepath")) {
                Main.outputCachePath(ivy, cache, md, confs, line.getOptionValue("cachepath", "ivycachepath.txt"));
            }
            if (line.hasOption("revision")) {
                ivy.deliver(md.getResolvedModuleRevisionId(), settings.substitute(line.getOptionValue("revision")), settings.substitute(line.getOptionValue("deliverto", "ivy-[revision].xml")), DeliverOptions.newInstance(settings).setStatus(settings.substitute(line.getOptionValue("status", "release"))).setValidate(validate));
                if (line.hasOption("publish")) {
                    ivy.publish(md.getResolvedModuleRevisionId(), Collections.singleton(settings.substitute(line.getOptionValue("publishpattern", "distrib/[type]s/[artifact]-[revision].[ext]"))), line.getOptionValue("publish"), new PublishOptions().setPubrevision(settings.substitute(line.getOptionValue("revision"))).setValidate(validate).setSrcIvyPattern(settings.substitute(line.getOptionValue("deliverto", "ivy-[revision].xml"))));
                }
            }
            if (line.hasOption("main")) {
                String[] extra;
                List fileList = Main.getExtraClasspathFileList(line);
                String[] fargs = line.getOptionValues("args");
                if (fargs == null) {
                    fargs = new String[]{};
                }
                if ((extra = line.getArgs()) == null) {
                    extra = new String[]{};
                }
                String[] params = new String[fargs.length + extra.length];
                System.arraycopy(fargs, 0, params, 0, fargs.length);
                System.arraycopy(extra, 0, params, fargs.length, extra.length);
                Main.invoke(ivy, cache, md, confs, fileList, line.getOptionValue("main"), params);
            }
            ivy.getLoggerEngine().popLogger();
        }
        catch (org.apache.commons.cli.ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            Main.usage(options);
        }
    }

    private static List getExtraClasspathFileList(CommandLine line) {
        ArrayList<File> fileList = null;
        if (line.hasOption("cp")) {
            fileList = new ArrayList<File>();
            String[] cpArray = line.getOptionValues("cp");
            for (int index = 0; index < cpArray.length; ++index) {
                StringTokenizer tokenizer = new StringTokenizer(cpArray[index], System.getProperty("path.separator"));
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    File file = new File(token);
                    if (file.exists()) {
                        fileList.add(file);
                        continue;
                    }
                    Message.warn("Skipping extra classpath '" + file + "' as it does not exist.");
                }
            }
        }
        return fileList;
    }

    private static IvySettings initSettings(CommandLine line, Options options, Ivy ivy) throws ParseException, IOException {
        IvySettings settings = ivy.getSettings();
        settings.addAllVariables(System.getProperties());
        if (line.hasOption("m2compatible")) {
            settings.setVariable("ivy.default.configuration.m2compatible", "true");
        }
        Main.configureURLHandler(line.getOptionValue("realm", null), line.getOptionValue("host", null), line.getOptionValue("username", null), line.getOptionValue("passwd", null));
        String settingsPath = line.getOptionValue("settings", "");
        if ("".equals(settingsPath) && !"".equals(settingsPath = line.getOptionValue("conf", ""))) {
            Message.deprecated("-conf is deprecated, use -settings instead");
        }
        if ("".equals(settingsPath)) {
            ivy.configureDefault();
        } else {
            File conffile = new File(settingsPath);
            if (!conffile.exists()) {
                Main.error(options, "ivy configuration file not found: " + conffile);
            } else if (conffile.isDirectory()) {
                Main.error(options, "ivy configuration file is not a file: " + conffile);
            }
            ivy.configure(conffile);
        }
        return settings;
    }

    private static void initMessage(CommandLine line, Ivy ivy) {
        if (line.hasOption("debug")) {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(4));
        } else if (line.hasOption("verbose")) {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(3));
        } else if (line.hasOption("warn")) {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(1));
        } else if (line.hasOption("error")) {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(0));
        } else {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(2));
        }
    }

    private static void outputCachePath(Ivy ivy, File cache, ModuleDescriptor md, String[] confs, String outFile) {
        try {
            String pathSeparator = System.getProperty("path.separator");
            StringBuffer buf = new StringBuffer();
            LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
            ResolutionCacheManager cacheMgr = ivy.getResolutionCacheManager();
            XmlReportParser parser = new XmlReportParser();
            for (int i = 0; i < confs.length; ++i) {
                String resolveId = ResolveOptions.getDefaultResolveId(md);
                File report = cacheMgr.getConfigurationResolveReportInCache(resolveId, confs[i]);
                parser.parse(report);
                all.addAll(Arrays.asList(parser.getArtifactReports()));
            }
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                ArtifactDownloadReport artifact = (ArtifactDownloadReport)iter.next();
                if (artifact.getLocalFile() == null) continue;
                buf.append(artifact.getLocalFile().getCanonicalPath());
                buf.append(pathSeparator);
            }
            PrintWriter writer = new PrintWriter(new FileOutputStream(outFile));
            if (buf.length() > 0) {
                writer.println(buf.substring(0, buf.length() - pathSeparator.length()));
            }
            writer.close();
            System.out.println("cachepath output to " + outFile);
        }
        catch (Exception ex) {
            throw new RuntimeException("impossible to build ivy cache path: " + ex.getMessage(), ex);
        }
    }

    private static void invoke(Ivy ivy, File cache, ModuleDescriptor md, String[] confs, List fileList, String mainclass, String[] args) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (fileList != null && fileList.size() > 0) {
            Iterator iter = fileList.iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {}
            }
        }
        try {
            LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
            ResolutionCacheManager cacheMgr = ivy.getResolutionCacheManager();
            XmlReportParser parser = new XmlReportParser();
            for (int i = 0; i < confs.length; ++i) {
                String resolveId = ResolveOptions.getDefaultResolveId(md);
                File report = cacheMgr.getConfigurationResolveReportInCache(resolveId, confs[i]);
                parser.parse(report);
                all.addAll(Arrays.asList(parser.getArtifactReports()));
            }
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                ArtifactDownloadReport artifact = (ArtifactDownloadReport)iter.next();
                if (artifact.getLocalFile() == null) continue;
                urls.add(artifact.getLocalFile().toURI().toURL());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("impossible to build ivy cache path: " + ex.getMessage(), ex);
        }
        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), Main.class.getClassLoader());
        try {
            Class<?> c = classLoader.loadClass(mainclass);
            Method mainMethod = c.getMethod("main", String;.class);
            Thread.currentThread().setContextClassLoader(classLoader);
            mainMethod.invoke(null, new Object[]{args == null ? new String[]{} : args});
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class: " + mainclass, cnfe);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Could not find main method: " + mainclass, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find main method: " + mainclass, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No permissions to invoke main method: " + mainclass, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unexpected exception invoking main method: " + mainclass, e);
        }
    }

    private static void configureURLHandler(String realm, String host, String username, String passwd) {
        CredentialsStore.INSTANCE.addCredentials(realm, host, username, passwd);
        URLHandlerDispatcher dispatcher = new URLHandlerDispatcher();
        URLHandler httpHandler = URLHandlerRegistry.getHttp();
        dispatcher.setDownloader("http", httpHandler);
        dispatcher.setDownloader("https", httpHandler);
        URLHandlerRegistry.setDefault(dispatcher);
    }

    private static void error(Options options, String msg) {
        System.err.println(msg);
        Main.usage(options);
        System.exit(1);
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("ivy", options);
    }

    private Main() {
    }
}

