/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.scm.ant.taskdefs;

import com.nokia.helium.scm.ant.taskdefs.BaseDirectoryScmAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.tools.ant.BuildException;

public class ChangelogAction
extends BaseDirectoryScmAction {
    private String startDate;
    private String endDate;
    private String datePattern;
    private String logOutput;
    private int numDays;
    private String startVersion;
    private String endVersion;
    private String xmlproperty;

    public void setStartVersion(String startVersion) {
        this.startVersion = startVersion;
    }

    public void setEndVersion(String endVersion) {
        this.endVersion = endVersion;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setNumDays(int numDays) {
        this.numDays = numDays;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public void setLogOutput(String logOutput) {
        this.logOutput = logOutput;
    }

    public void setXMLProperty(String xmlproperty) {
        this.xmlproperty = xmlproperty;
    }

    @Override
    public void execute(ScmRepository repository) throws ScmException {
        ChangeLogScmResult result;
        ScmManager scmManager = this.getTask().getScmManager();
        ScmRevision startRevision = new ScmRevision(this.startVersion);
        ScmRevision endRevision = new ScmRevision(this.endVersion);
        Date start = null;
        Date end = null;
        if (this.numDays == 0 && (this.startDate != null || this.endDate != null)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(this.datePattern);
                start = format.parse(this.startDate);
                end = format.parse(this.endDate);
            }
            catch (Exception e) {
                throw new BuildException("Date Format not supported jash:" + e.getMessage());
            }
        } else {
            start = null;
            end = null;
        }
        try {
            result = this.startVersion == null ? scmManager.changeLog(repository, this.getScmFileSet(), start, end, this.numDays, null, this.datePattern) : scmManager.changeLog(repository, this.getScmFileSet(), (ScmVersion)startRevision, (ScmVersion)endRevision, this.datePattern);
        }
        catch (ScmException e) {
            throw new BuildException("Execution of SCM changelog action failed.");
        }
        if (!result.isSuccess()) {
            throw new BuildException("SCM changelog command unsuccessful.");
        }
        ChangeLogSet changelogSet = result.getChangeLog();
        if (this.logOutput != null && this.logOutput.equals("xml")) {
            this.getTask().log(changelogSet.toXML());
        } else if (this.xmlproperty != null) {
            String output = "";
            for (Object o : changelogSet.getChangeSets()) {
                String revision = "";
                ChangeSet c = (ChangeSet)o;
                for (String x : c.toString().split("\n")) {
                    if (!x.contains("revision:")) continue;
                    revision = x.replace("revision:", "");
                }
                output = output + "<task><id>" + revision + "</id><synopsis>" + c.getComment() + "</synopsis><completed>" + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(c.getDate()) + "</completed></task>";
            }
            this.getProject().setProperty(this.xmlproperty, output);
        } else {
            Iterator iterator = changelogSet.getChangeSets().iterator();
            while (iterator.hasNext()) {
                this.getTask().log(iterator.next().toString());
            }
        }
    }
}

