/*
 * Decompiled with CFR 0.152.
 */
package com.jeldoclet;

import com.jeldoclet.XMLNode;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import java.util.Date;

public class JELDoclet {
    private static String programversion = "1.0.0";
    private static String xsdversion = "1.0.0";
    private static boolean multipleFiles = false;
    private static String outputDirectory = "./";
    private static boolean includeNamespace = false;
    private static String outputEncoding = "UTF-8";
    private static String filenameBase = "";

    public static boolean start(RootDoc rootDoc) {
        JELDoclet.getOptions(rootDoc);
        XMLNode[] xMLNodeArray = JELDoclet.buildXmlFromDoc(rootDoc);
        JELDoclet.save(xMLNodeArray);
        return true;
    }

    public static int optionLength(String string) {
        if (string.compareToIgnoreCase("-multiple") == 0) {
            return 1;
        }
        if (string.compareToIgnoreCase("-includeNamespace") == 0) {
            return 1;
        }
        if (string.compareToIgnoreCase("-d") == 0) {
            return 2;
        }
        if (string.compareToIgnoreCase("-outputEncoding") == 0) {
            return 2;
        }
        if (string.compareToIgnoreCase("-filename") == 0) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] stringArray, DocErrorReporter docErrorReporter) {
        return true;
    }

    private static void getOptions(RootDoc rootDoc) {
        String[][] stringArray = rootDoc.options();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i][0].compareToIgnoreCase("-d") == 0) {
                outputDirectory = stringArray[i][1];
                String string = System.getProperty("file.separator");
                if (outputDirectory.endsWith(string)) continue;
                outputDirectory = outputDirectory + string;
                continue;
            }
            if (stringArray[i][0].compareToIgnoreCase("-multiple") == 0) {
                multipleFiles = true;
                continue;
            }
            if (stringArray[i][0].compareToIgnoreCase("-includeNamespace") == 0) {
                includeNamespace = true;
                continue;
            }
            if (stringArray[i][0].compareToIgnoreCase("-outputEncoding") == 0) {
                outputEncoding = stringArray[i][1];
                continue;
            }
            if (stringArray[i][0].compareToIgnoreCase("-filename") != 0) continue;
            filenameBase = stringArray[i][1];
        }
        System.out.println("jeldoclet V" + programversion);
        System.out.println("Using output directory '" + outputDirectory + "'.");
        System.out.println("output encoding '" + outputEncoding + "'.");
        System.out.println("Saving as " + (multipleFiles ? "multiple files." : "a single file."));
        if (!filenameBase.equals("")) {
            System.out.println("filename " + (multipleFiles ? " base " : "") + ": '" + filenameBase + "'");
        }
    }

    private static void save(XMLNode[] xMLNodeArray) {
        XMLNode xMLNode = new XMLNode("jel");
        XMLNode xMLNode2 = new XMLNode("admin");
        xMLNode2.addAttribute("version", programversion);
        xMLNode2.addAttribute("xsdversion", xsdversion);
        xMLNode2.addAttribute("creation", new Date().toString());
        xMLNode.addNode(xMLNode2);
        if (multipleFiles) {
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                String string = xMLNodeArray[i].getAttribute("fulltype") + ".xml";
                xMLNode.addNode(xMLNodeArray[i]);
                if (!filenameBase.equals("")) {
                    string = filenameBase + string;
                }
                xMLNode.save(outputDirectory, string, includeNamespace, outputEncoding);
            }
        } else {
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                xMLNode.addNode(xMLNodeArray[i]);
            }
            String string = "jel.xml";
            if (!filenameBase.equals("")) {
                string = filenameBase;
            }
            xMLNode.save(outputDirectory, string, includeNamespace, outputEncoding);
        }
    }

    private static XMLNode[] buildXmlFromDoc(RootDoc rootDoc) {
        ClassDoc[] classDocArray = rootDoc.classes();
        XMLNode[] xMLNodeArray = new XMLNode[classDocArray.length];
        for (int i = 0; i < classDocArray.length; ++i) {
            xMLNodeArray[i] = JELDoclet.transformClass(classDocArray[i], null);
        }
        return xMLNodeArray;
    }

    private static void transformComment(Doc doc, XMLNode xMLNode) {
        XMLNode xMLNode2 = new XMLNode("comment");
        boolean bl = false;
        if (doc.commentText() != null && doc.commentText().length() > 0) {
            xMLNode2.addText(doc.commentText());
            bl = true;
        }
        Tag[] tagArray = doc.tags();
        for (int i = 0; i < tagArray.length; ++i) {
            XMLNode xMLNode3 = new XMLNode("attribute");
            xMLNode3.addAttribute("name", tagArray[i].name());
            xMLNode3.addText(tagArray[i].text());
            xMLNode2.addNode(xMLNode3);
            bl = true;
        }
        if (bl) {
            xMLNode.addNode(xMLNode2);
        }
    }

    private static void transformFields(FieldDoc[] fieldDocArray, XMLNode xMLNode) {
        if (fieldDocArray.length < 1) {
            return;
        }
        XMLNode xMLNode2 = new XMLNode("fields");
        for (int i = 0; i < fieldDocArray.length; ++i) {
            XMLNode xMLNode3 = new XMLNode("field");
            xMLNode3.addAttribute("name", fieldDocArray[i].name());
            xMLNode3.addAttribute("type", fieldDocArray[i].type().typeName());
            xMLNode3.addAttribute("fulltype", fieldDocArray[i].type().toString());
            if (fieldDocArray[i].constantValue() != null && fieldDocArray[i].constantValue().toString().length() > 0) {
                xMLNode3.addAttribute("const", fieldDocArray[i].constantValue().toString());
            }
            if (fieldDocArray[i].constantValueExpression() != null && fieldDocArray[i].constantValueExpression().length() > 0) {
                xMLNode3.addAttribute("constexpr", fieldDocArray[i].constantValueExpression());
            }
            JELDoclet.setVisibility((ProgramElementDoc)fieldDocArray[i], xMLNode3);
            if (fieldDocArray[i].isStatic()) {
                xMLNode3.addAttribute("static", "true");
            }
            if (fieldDocArray[i].isFinal()) {
                xMLNode3.addAttribute("final", "true");
            }
            if (fieldDocArray[i].isTransient()) {
                xMLNode3.addAttribute("transient", "true");
            }
            if (fieldDocArray[i].isVolatile()) {
                xMLNode3.addAttribute("volatile", "true");
            }
            JELDoclet.transformComment((Doc)fieldDocArray[i], xMLNode3);
            xMLNode2.addNode(xMLNode3);
        }
        xMLNode.addNode(xMLNode2);
    }

    private static void setVisibility(ProgramElementDoc programElementDoc, XMLNode xMLNode) {
        if (programElementDoc.isPrivate()) {
            xMLNode.addAttribute("visibility", "private");
        } else if (programElementDoc.isProtected()) {
            xMLNode.addAttribute("visibility", "protected");
        } else if (programElementDoc.isPublic()) {
            xMLNode.addAttribute("visibility", "public");
        } else if (programElementDoc.isPackagePrivate()) {
            xMLNode.addAttribute("visibility", "package-private");
        }
    }

    private static void populateMethodNode(ExecutableMemberDoc executableMemberDoc, XMLNode xMLNode) {
        Object object;
        ParamTag[] paramTagArray;
        Parameter[] parameterArray;
        JELDoclet.transformComment((Doc)executableMemberDoc, xMLNode);
        xMLNode.addAttribute("name", executableMemberDoc.name());
        JELDoclet.setVisibility((ProgramElementDoc)executableMemberDoc, xMLNode);
        if (executableMemberDoc.isStatic()) {
            xMLNode.addAttribute("static", "true");
        }
        if (executableMemberDoc.isInterface()) {
            xMLNode.addAttribute("interface", "true");
        }
        if (executableMemberDoc.isFinal()) {
            xMLNode.addAttribute("final", "true");
        }
        if (executableMemberDoc instanceof MethodDoc && ((MethodDoc)executableMemberDoc).isAbstract()) {
            xMLNode.addAttribute("abstract", "true");
        }
        if (executableMemberDoc.isSynchronized()) {
            xMLNode.addAttribute("synchronized", "true");
        }
        if (executableMemberDoc.isSynthetic()) {
            xMLNode.addAttribute("synthetic", "true");
        }
        if ((parameterArray = executableMemberDoc.parameters()).length > 0) {
            paramTagArray = executableMemberDoc.paramTags();
            object = new XMLNode("params");
            for (int i = 0; i < parameterArray.length; ++i) {
                XMLNode xMLNode2 = new XMLNode("param");
                xMLNode2.addAttribute("name", parameterArray[i].name());
                xMLNode2.addAttribute("type", parameterArray[i].type().typeName());
                xMLNode2.addAttribute("fulltype", parameterArray[i].type().toString());
                for (int j = 0; j < paramTagArray.length; ++j) {
                    if (paramTagArray[j].parameterName().compareToIgnoreCase(parameterArray[i].name()) != 0) continue;
                    xMLNode2.addAttribute("comment", paramTagArray[j].parameterComment());
                }
                ((XMLNode)object).addNode(xMLNode2);
            }
            xMLNode.addNode((XMLNode)object);
        }
        paramTagArray = executableMemberDoc.thrownExceptions();
        object = executableMemberDoc.throwsTags();
        if (paramTagArray != null && paramTagArray.length > 0) {
            XMLNode xMLNode3 = new XMLNode("exceptions");
            for (int i = 0; i < paramTagArray.length; ++i) {
                XMLNode xMLNode4 = new XMLNode("exception");
                xMLNode4.addAttribute("type", paramTagArray[i].typeName());
                xMLNode4.addAttribute("fulltype", paramTagArray[i].qualifiedTypeName());
                for (int j = 0; j < ((ThrowsTag[])object).length; ++j) {
                    if (object[j].exceptionName().compareToIgnoreCase(paramTagArray[i].typeName()) != 0) continue;
                    xMLNode4.addAttribute("comment", object[j].exceptionComment());
                }
                xMLNode3.addNode(xMLNode4);
            }
            xMLNode.addNode(xMLNode3);
        }
    }

    private static void transformMethods(MethodDoc[] methodDocArray, ConstructorDoc[] constructorDocArray, XMLNode xMLNode) {
        XMLNode xMLNode2;
        int n;
        if (methodDocArray.length < 1 && constructorDocArray.length < 1) {
            return;
        }
        XMLNode xMLNode3 = new XMLNode("methods");
        for (n = 0; n < constructorDocArray.length; ++n) {
            xMLNode2 = new XMLNode("constructor");
            JELDoclet.populateMethodNode((ExecutableMemberDoc)constructorDocArray[n], xMLNode2);
            xMLNode3.addNode(xMLNode2);
        }
        for (n = 0; n < methodDocArray.length; ++n) {
            xMLNode2 = new XMLNode("method");
            JELDoclet.populateMethodNode((ExecutableMemberDoc)methodDocArray[n], xMLNode2);
            xMLNode2.addAttribute("type", methodDocArray[n].returnType().typeName());
            xMLNode2.addAttribute("fulltype", methodDocArray[n].returnType().toString());
            Tag[] tagArray = methodDocArray[n].tags("@return");
            if (tagArray.length > 0) {
                xMLNode2.addAttribute("returncomment", tagArray[0].text());
            }
            xMLNode3.addNode(xMLNode2);
        }
        xMLNode.addNode(xMLNode3);
    }

    private static XMLNode transformClass(ClassDoc classDoc, XMLNode xMLNode) {
        int n;
        ClassDoc[] classDocArray;
        XMLNode xMLNode2 = new XMLNode("jelclass");
        JELDoclet.setVisibility((ProgramElementDoc)classDoc, xMLNode2);
        xMLNode2.addAttribute("type", classDoc.name());
        xMLNode2.addAttribute("fulltype", classDoc.qualifiedName());
        xMLNode2.addAttribute("package", classDoc.containingPackage().name());
        ClassDoc[] classDocArray2 = classDoc.interfaces();
        if (classDocArray2.length > 0) {
            classDocArray = new XMLNode("implements");
            for (n = 0; n < classDocArray2.length; ++n) {
                XMLNode xMLNode3 = new XMLNode("interface");
                xMLNode3.addAttribute("type", classDocArray2[n].name());
                xMLNode3.addAttribute("fulltype", classDocArray2[n].qualifiedName());
                classDocArray.addNode(xMLNode3);
            }
            xMLNode2.addNode((XMLNode)classDocArray);
        }
        if (classDoc.superclass() != null) {
            xMLNode2.addAttribute("superclass", classDoc.superclass().name());
            xMLNode2.addAttribute("superclassfulltype", classDoc.superclass().qualifiedName());
        }
        if (classDoc.isInterface()) {
            xMLNode2.addAttribute("interface", "true");
        }
        if (classDoc.isFinal()) {
            xMLNode2.addAttribute("final", "true");
        }
        if (classDoc.isAbstract()) {
            xMLNode2.addAttribute("abstract", "true");
        }
        if (classDoc.isSerializable()) {
            xMLNode2.addAttribute("serializable", "true");
        }
        JELDoclet.transformComment((Doc)classDoc, xMLNode2);
        JELDoclet.transformFields(classDoc.fields(), xMLNode2);
        JELDoclet.transformMethods(classDoc.methods(), classDoc.constructors(), xMLNode2);
        classDocArray = classDoc.innerClasses();
        for (n = 0; n < classDocArray.length; ++n) {
            xMLNode2.addNode(JELDoclet.transformClass(classDocArray[n], xMLNode2));
        }
        return xMLNode2;
    }
}

