/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.html.wikipedia;

import info.bliki.html.wikipedia.AbstractHTMLTag;
import info.bliki.html.wikipedia.AbstractHTMLToWiki;
import java.util.List;
import org.htmlcleaner.TagNode;

public class OpenCloseTag
extends AbstractHTMLTag {
    protected final String openStr;
    protected final String closeStr;

    public OpenCloseTag(String opener, String closer, boolean convertPlainText) {
        super(convertPlainText);
        this.openStr = opener;
        this.closeStr = closer;
    }

    public OpenCloseTag(String opener, String closer) {
        super(false);
        this.openStr = opener;
        this.closeStr = closer;
    }

    public void open(TagNode node, StringBuilder resultBuffer) {
        resultBuffer.append(this.openStr);
    }

    public void content(AbstractHTMLToWiki w, TagNode node, StringBuilder resultBuffer, boolean showWithoutTag) {
        List children = node.getChildren();
        if (children.size() != 0) {
            StringBuilder buf = new StringBuilder();
            if (this.fconvertPlainText) {
                w.nodesToPlainText(children, buf);
                int i = 0;
                while (i < buf.length()) {
                    char ch = buf.charAt(i);
                    if (ch == '\n' || ch == '\r' || ch == '\t') {
                        buf.setCharAt(i, ' ');
                    }
                    ++i;
                }
            } else {
                w.nodesToText(children, buf);
            }
            String str = buf.toString();
            String trimmedStr = str.trim();
            boolean showWithout = showWithoutTag;
            if (trimmedStr.length() == 0) {
                showWithout = true;
            }
            if (!showWithout) {
                this.open(node, resultBuffer);
            }
            if (this.fconvertPlainText) {
                resultBuffer.append(trimmedStr);
            } else {
                resultBuffer.append(str);
            }
            if (!showWithout) {
                this.close(node, resultBuffer);
            }
        }
    }

    public void close(TagNode node, StringBuilder resultBuffer) {
        resultBuffer.append(this.closeStr);
    }
}

