/*
 * Decompiled with CFR 0.152.
 */
package com.kirkk.analyzer.framework.bcel;

import com.kirkk.analyzer.framework.JarClass;
import com.kirkk.analyzer.framework.bcel.BCELClassFactory;
import com.kirkk.analyzer.framework.bcel.PackageVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

public class BCELPublicClass
implements JarClass {
    private static List ignorePackages;
    private List importedPackages;
    private List publicMethods;
    private String packageName;
    private String longName;
    private boolean isAbstract;
    private boolean isPublic;
    private boolean isInterface;

    public BCELPublicClass(String string, String string2) throws Exception {
        this(string, string2, new ArrayList());
    }

    public BCELPublicClass(String string, String string2, List list) throws Exception {
        this(BCELClassFactory.getClass(string, string2), list);
    }

    private BCELPublicClass(JavaClass javaClass, List list) {
        this.importedPackages = this.getImportedPackages(javaClass, list);
        this.packageName = javaClass.getPackageName();
        this.isAbstract = javaClass.isAbstract();
        this.isPublic = javaClass.isPublic();
        this.longName = javaClass.getClassName();
        this.isInterface = javaClass.isInterface();
    }

    private List getImportedPackages(JavaClass javaClass, List list) {
        PackageVisitor packageVisitor = new PackageVisitor(javaClass);
        DescendingVisitor descendingVisitor = new DescendingVisitor(javaClass, (Visitor)packageVisitor);
        javaClass.accept((Visitor)descendingVisitor);
        return packageVisitor.getImports(list);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List getImportedPackageNames() {
        return this.importedPackages;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getLongName() {
        return this.longName;
    }

    public boolean isInterface() {
        return this.isInterface;
    }
}

