/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.JAXBSchemaOutputResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGenerator;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBBinder;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.JAXBValidator;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContext
extends javax.xml.bind.JAXBContext {
    private static final Map<String, Boolean> PARSER_FEATURES = new HashMap<String, Boolean>(2);
    private XMLContext xmlContext;
    private Generator generator;
    private HashMap<QName, Class> qNameToGeneratedClasses;
    private HashMap<String, Class> classToGeneratedClasses;
    private HashMap<QName, Class> qNamesToDeclaredClasses;
    private HashMap<Type, QName> typeToSchemaType;
    private Type[] boundTypes;

    public JAXBContext(XMLContext context) {
        this.xmlContext = context;
    }

    public JAXBContext(XMLContext context, Generator generator, Type[] boundTypes) {
        this(context);
        this.generator = generator;
        this.qNameToGeneratedClasses = generator.getMappingsGenerator().getQNamesToGeneratedClasses();
        this.classToGeneratedClasses = generator.getMappingsGenerator().getClassToGeneratedClasses();
        this.qNamesToDeclaredClasses = generator.getMappingsGenerator().getQNamesToDeclaredClasses();
        this.boundTypes = boundTypes;
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void generateSchema(SchemaOutputResolver outputResolver) {
        this.generateSchema(outputResolver, null);
    }

    public void generateSchema(SchemaOutputResolver outputResolver, Map<QName, Type> additonalGlobalElements) {
        if (this.generator == null) {
            ArrayList<XMLDescriptor> descriptorsToProcess = new ArrayList<XMLDescriptor>();
            List sessions = this.xmlContext.getSessions();
            for (Session session : sessions) {
                Vector descriptors = session.getProject().getOrderedDescriptors();
                for (XMLDescriptor xDesc : descriptors) {
                    descriptorsToProcess.add(xDesc);
                }
            }
            SchemaModelGenerator smGen = new SchemaModelGenerator();
            smGen.generateSchemas(descriptorsToProcess, null, new JAXBSchemaOutputResolver(outputResolver), additonalGlobalElements);
        } else {
            this.generator.generateSchemaFiles(outputResolver, additonalGlobalElements);
        }
    }

    public JAXBMarshaller createMarshaller() {
        JAXBMarshaller marshaller = new JAXBMarshaller(this.xmlContext.createMarshaller(), new JAXBIntrospector(this.xmlContext));
        if (this.generator != null && this.generator.hasMarshalCallbacks()) {
            Iterator callIt = this.generator.getMarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                MarshalCallback cb = (MarshalCallback)this.generator.getMarshalCallbacks().get(callIt.next());
                cb.initialize(this.generator.getClass().getClassLoader());
            }
            marshaller.setMarshalCallbacks(this.generator.getMarshalCallbacks());
        }
        marshaller.setQNameToGeneratedClasses(this.qNameToGeneratedClasses);
        marshaller.setJaxbContext(this);
        return marshaller;
    }

    public JAXBUnmarshaller createUnmarshaller() {
        JAXBUnmarshaller unmarshaller = new JAXBUnmarshaller(this.xmlContext.createUnmarshaller(PARSER_FEATURES));
        if (this.generator != null && this.generator.hasUnmarshalCallbacks()) {
            Iterator callIt = this.generator.getUnmarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                UnmarshalCallback cb = (UnmarshalCallback)this.generator.getUnmarshalCallbacks().get(callIt.next());
                cb.initialize(this.generator.getClass().getClassLoader());
            }
            unmarshaller.setUnmarshalCallbacks(this.generator.getUnmarshalCallbacks());
        }
        unmarshaller.setJaxbContext(this);
        return unmarshaller;
    }

    public JAXBValidator createValidator() {
        return new JAXBValidator(this.xmlContext.createValidator());
    }

    public JAXBBinder createBinder() {
        return new JAXBBinder(this.xmlContext);
    }

    public <T> JAXBBinder createBinder(Class<T> nodeClass) {
        if (nodeClass.getName().equals("org.w3c.dom.Node")) {
            return new JAXBBinder(this.xmlContext);
        }
        throw new UnsupportedOperationException(JAXBException.unsupportedNodeClass(nodeClass.getName()));
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return new JAXBIntrospector(this.xmlContext);
    }

    public void setQNameToGeneratedClasses(HashMap<QName, Class> qNameToClass) {
        this.qNameToGeneratedClasses = qNameToClass;
    }

    public HashMap<String, Class> getClassToGeneratedClasses() {
        return this.classToGeneratedClasses;
    }

    public void setClassToGeneratedClasses(HashMap<String, Class> classToClass) {
        this.classToGeneratedClasses = classToClass;
    }

    public void applyORMMetadata(AbstractSession ormSession) {
        this.xmlContext.applyORMMetadata(ormSession);
    }

    public HashMap<QName, Class> getQNamesToDeclaredClasses() {
        return this.qNamesToDeclaredClasses;
    }

    public void setQNamesToDeclaredClasses(HashMap<QName, Class> nameToDeclaredClasses) {
        this.qNamesToDeclaredClasses = nameToDeclaredClasses;
    }

    public Map<String, Class> getArrayClassesToGeneratedClasses() {
        return this.generator.getAnnotationsProcessor().getArrayClassesToGeneratedClasses();
    }

    public Map<Type, Class> getCollectionClassesToGeneratedClasses() {
        return this.generator.getAnnotationsProcessor().getCollectionClassesToGeneratedClasses();
    }

    public void initTypeToSchemaType() {
        this.typeToSchemaType = new HashMap();
        Iterator descriptors = this.xmlContext.getSession(0).getProject().getOrderedDescriptors().iterator();
        HashMap defaults = XMLConversionManager.getDefaultJavaTypes();
        while (descriptors.hasNext()) {
            Type type;
            XMLDescriptor next = (XMLDescriptor)descriptors.next();
            Class javaClass = next.getJavaClass();
            if (next.getSchemaReference() == null) continue;
            QName schemaType = next.getSchemaReference().getSchemaContextAsQName(next.getNamespaceResolver());
            if (this.generator != null) {
                JavaClass arrayClass;
                type = this.generator.getAnnotationsProcessor().getGeneratedClassesToCollectionClasses().get(javaClass);
                if (type == null && (arrayClass = this.generator.getAnnotationsProcessor().getGeneratedClassesToArrayClasses().get(javaClass)) != null) {
                    String arrayClassName = arrayClass.getName();
                    try {
                        type = PrivilegedAccessHelper.getClassForName(arrayClassName);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (type == null) {
                    type = javaClass;
                }
            } else {
                type = javaClass;
            }
            this.typeToSchemaType.put(type, schemaType);
        }
        if (this.boundTypes != null) {
            for (Type next : this.boundTypes) {
                if (this.typeToSchemaType.get(next) != null) continue;
                QName name = null;
                if (next instanceof Class) {
                    name = this.generator.getAnnotationsProcessor().getUserDefinedSchemaTypes().get(((Class)next).getName());
                }
                if (name == null) {
                    name = next == ClassConstants.ABYTE || next == ClassConstants.APBYTE ? XMLConstants.BASE_64_BINARY_QNAME : (QName)defaults.get(next);
                }
                if (name == null) continue;
                this.typeToSchemaType.put(next, name);
            }
        }
    }

    public HashMap<Type, QName> getTypeToSchemaType() {
        if (this.typeToSchemaType == null) {
            this.initTypeToSchemaType();
        }
        return this.typeToSchemaType;
    }

    public Map<TypeMappingInfo, QName> getTypeMappingInfoToSchemaType() {
        return new HashMap<TypeMappingInfo, QName>();
    }

    static {
        PARSER_FEATURES.put("http://apache.org/xml/features/validation/schema/normalized-value", false);
        PARSER_FEATURES.put("http://apache.org/xml/features/validation/schema/element-default", false);
    }
}

