/*
 * Decompiled with CFR 0.152.
 */
package fmpp;

import fmpp.LocalDataBuilder;
import fmpp.util.FileUtil;
import fmpp.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlRenderingConfiguration {
    private String template;
    private boolean copy;
    private List pathPatterns = new ArrayList();
    private List documentElementLocalNames = new ArrayList();
    private List documentElementNamespaces = new ArrayList();
    private List localDataBuilders = new ArrayList();
    private Map xmlDataLoaderOptions = new HashMap();

    public void setTemplate(String template) {
        if (template != null) {
            if ((template = FileUtil.pathToUnixStyle(template)).startsWith("/")) {
                template = template.substring(1);
            }
            this.template = template;
        }
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public void addDocumentElement(String xmlns, String localName) {
        this.documentElementNamespaces.add(xmlns);
        this.documentElementLocalNames.add(localName);
    }

    public void clearDocumentElements() {
        this.documentElementNamespaces.clear();
        this.documentElementLocalNames.clear();
    }

    public void addLocalDataBuilder(LocalDataBuilder localDataBuilder) {
        this.localDataBuilders.add(localDataBuilder);
    }

    public void clearLocalDataBuilders() {
        this.localDataBuilders.clear();
    }

    public void addSourcePathPattern(String pathPattern) {
        this.pathPatterns.add(pathPattern);
    }

    public void clearSourcePathPatterns() {
        this.pathPatterns.clear();
    }

    public void addXmlDataLoaderOption(String name, Object value) {
        if (name.equals("namespaceAware") && Boolean.FALSE.equals(value)) {
            throw new IllegalArgumentException("It's not allowed to set the \"namespaceAware\" option to false.");
        }
        this.xmlDataLoaderOptions.put(name, value);
    }

    public void clearXmlDataLoaderOptions() {
        this.xmlDataLoaderOptions.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("xmlRendering{");
        sb.append("template=");
        sb.append(this.template);
        sb.append(", ifSourceIs=");
        sb.append(this.pathPatterns);
        sb.append(", ifDocumentElementIs=[");
        for (int i = 0; i < this.documentElementLocalNames.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            if (this.documentElementNamespaces.get(i) != null) {
                sb.append(StringUtil.jQuote((String)this.documentElementNamespaces.get(i)));
                sb.append(":");
            }
            sb.append(this.documentElementLocalNames.get(i));
        }
        sb.append("], localDataBuilder=");
        sb.append(this.localDataBuilders);
        sb.append(", xmlDataLoaderOptions=");
        sb.append(this.xmlDataLoaderOptions);
        sb.append("}");
        return sb.toString();
    }

    String getTemplatePath() {
        return this.template;
    }

    boolean getCopy() {
        return this.copy;
    }

    List getPathPatterns() {
        return this.pathPatterns;
    }

    List getDocumentElementLocalNames() {
        return this.documentElementLocalNames;
    }

    List getDocumentElementNamespaces() {
        return this.documentElementNamespaces;
    }

    Map getXmlDataLoaderOptions() {
        return this.xmlDataLoaderOptions;
    }

    List getLocalDataBuilders() {
        return this.localDataBuilders;
    }
}

