/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class JavaSECMPInitializer
extends JPAInitializer {
    public static Instrumentation globalInstrumentation;
    protected static boolean usesAgent;
    protected static boolean isInitialized;
    public static boolean keepInitialPuInfos;

    public static synchronized JavaSECMPInitializer getJavaSECMPInitializer() {
        if (!isInitialized) {
            JavaSECMPInitializer.initializeTopLinkLoggingFile();
            JavaSECMPInitializer initializer = new JavaSECMPInitializer();
            initializer.initialize(new HashMap());
            return initializer;
        }
        return new JavaSECMPInitializer();
    }

    public static synchronized JavaSECMPInitializer getJavaSECMPInitializer(ClassLoader loader) {
        if (!isInitialized) {
            JavaSECMPInitializer.initializeTopLinkLoggingFile();
            JavaSECMPInitializer initializer = new JavaSECMPInitializer(loader);
            initializer.initialize(new HashMap());
            return initializer;
        }
        return new JavaSECMPInitializer(loader);
    }

    protected JavaSECMPInitializer() {
    }

    protected JavaSECMPInitializer(ClassLoader loader) {
        this.initializationClassloader = loader;
    }

    public void checkWeaving(Map properties) {
        String weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", properties, null);
        if (!usesAgent) {
            if (weaving == null) {
                properties.put("eclipselink.weaving", "false");
                weaving = "false";
            } else if (weaving.equalsIgnoreCase("true")) {
                throw new PersistenceException((Throwable)EntityManagerSetupException.wrongWeavingPropertyValue());
            }
        }
        if (weaving != null && (weaving.equalsIgnoreCase("false") || weaving.equalsIgnoreCase("static"))) {
            this.shouldCreateInternalLoader = false;
        }
    }

    protected ClassLoader createTempLoader(Collection col) {
        return this.createTempLoader(col, true);
    }

    protected ClassLoader createTempLoader(Collection col, boolean shouldOverrideLoadClassForCollectionMembers) {
        if (!this.shouldCreateInternalLoader) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentLoader instanceof URLClassLoader)) {
            return currentLoader;
        }
        URL[] urlPath = ((URLClassLoader)currentLoader).getURLs();
        TempEntityLoader tempLoader = new TempEntityLoader(urlPath, currentLoader, col, shouldOverrideLoadClassForCollectionMembers);
        AbstractSessionLog.getLog().log(2, "cmp_init_tempLoader_created", tempLoader);
        AbstractSessionLog.getLog().log(2, "cmp_init_shouldOverrideLoadClassForCollectionMembers", shouldOverrideLoadClassForCollectionMembers);
        return tempLoader;
    }

    protected static void initializeFromAgent(Instrumentation instrumentation) throws Exception {
        JavaSECMPInitializer.initializeTopLinkLoggingFile();
        AbstractSessionLog.getLog().log(2, "cmp_init_initialize_from_agent", null);
        globalInstrumentation = instrumentation;
        new JavaSECMPInitializer().initialize(new HashMap());
    }

    public static void initializeFromMain(Map m) {
        JavaSECMPInitializer.initializeTopLinkLoggingFile();
        new JavaSECMPInitializer().initialize(m);
    }

    public static void initializeFromMain() {
        JavaSECMPInitializer.initializeFromMain(new HashMap());
    }

    public void initialize(Map m) {
        if (!isInitialized) {
            if (globalInstrumentation != null) {
                usesAgent = true;
                if (this.initializationClassloader == null) {
                    this.initializationClassloader = Thread.currentThread().getContextClassLoader();
                }
                EntityManagerFactoryProvider.initialEmSetupImpls = new HashMap();
                if (keepInitialPuInfos) {
                    EntityManagerFactoryProvider.initialPuInfos = new HashMap();
                }
                Set<Archive> pars = PersistenceUnitProcessor.findPersistenceArchives(this.initializationClassloader);
                PersistenceInitializationHelper initializationHelper = new PersistenceInitializationHelper();
                for (Archive archive : pars) {
                    AbstractSessionLog.getLog().log(2, "cmp_init_initialize", archive);
                    this.initPersistenceUnits(archive, m, initializationHelper);
                }
                globalInstrumentation = null;
            }
            isInitialized = true;
        }
    }

    protected void initPersistenceUnits(Archive archive, Map m, PersistenceInitializationHelper persistenceActivator) {
        for (SEPersistenceUnitInfo persistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(archive, this.initializationClassloader)) {
            String puName = persistenceUnitInfo.getPersistenceUnitName();
            EntityManagerSetupImpl anotherEmSetupImpl = EntityManagerFactoryProvider.initialEmSetupImpls.get(puName);
            if (anotherEmSetupImpl != null) {
                String anotherPuUrl;
                String puUrl;
                try {
                    puUrl = URLDecoder.decode(persistenceUnitInfo.getPersistenceUnitRootUrl().toString(), "UTF8");
                    anotherPuUrl = URLDecoder.decode(anotherEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitRootUrl().toString(), "UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    puUrl = persistenceUnitInfo.getPersistenceUnitRootUrl().toString();
                    anotherPuUrl = anotherEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitRootUrl().toString();
                }
                throw PersistenceUnitLoadingException.persistenceUnitNameAlreadyInUse(puName, puUrl, anotherPuUrl);
            }
            String sessionName = EntityManagerSetupImpl.getOrBuildSessionName(Collections.emptyMap(), persistenceUnitInfo, puName);
            EntityManagerSetupImpl emSetupImpl = this.callPredeploy(persistenceUnitInfo, m, persistenceActivator, puName, sessionName);
            EntityManagerFactoryProvider.initialEmSetupImpls.put(puName, emSetupImpl);
            if (!keepInitialPuInfos) continue;
            EntityManagerFactoryProvider.initialPuInfos.put(puName, persistenceUnitInfo);
        }
    }

    public void registerTransformer(final ClassTransformer transformer, PersistenceUnitInfo persistenceUnitInfo) {
        if (transformer != null && globalInstrumentation != null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_register_transformer", persistenceUnitInfo.getPersistenceUnitName());
            globalInstrumentation.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                    return transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                }
            });
        } else if (transformer == null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_transformer_is_null");
        } else if (globalInstrumentation == null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_globalInstrumentation_is_null");
        }
    }

    public boolean isPersistenceUnitUniquelyDefinedByName() {
        return usesAgent;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static boolean usesAgent() {
        return usesAgent;
    }

    static {
        keepInitialPuInfos = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TempEntityLoader
    extends URLClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.getParent().getResources(name);
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames, boolean shouldOverrideLoadClassForCollectionMembers) {
            super(urls, parent);
            this.classNames = classNames;
            this.shouldOverrideLoadClassForCollectionMembers = shouldOverrideLoadClassForCollectionMembers;
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames) {
            this(urls, parent, classNames, true);
        }

        protected boolean shouldOverrideLoadClass(String name) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(name);
            }
            return !name.startsWith("java.") && !name.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(name));
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

