/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.JDBCBoot;
import org.apache.derby.jdbc.AutoloadedDriver;

public class EmbeddedDriver
implements Driver {
    private AutoloadedDriver _autoloadedDriver;

    public EmbeddedDriver() {
        EmbeddedDriver.boot();
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.getDriverModule().acceptsURL(string);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        return this.getDriverModule().connect(string, properties);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return this.getDriverModule().getPropertyInfo(string, properties);
    }

    public int getMajorVersion() {
        try {
            return this.getDriverModule().getMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return this.getDriverModule().getMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        try {
            return this.getDriverModule().jdbcCompliant();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private Driver getDriverModule() throws SQLException {
        return AutoloadedDriver.getDriverModule();
    }

    static void boot() {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.err;
        }
        new JDBCBoot().boot("jdbc:derby:", printStream);
    }

    static {
        EmbeddedDriver.boot();
    }
}

