/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.AntLintHandler;
import com.nokia.helium.antlint.checks.AbstractCheck;
import java.io.File;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.xml.sax.helpers.DefaultHandler;

public class CheckTabCharacter
extends AbstractCheck {
    @Override
    public void run(Element node) {
        this.checkTabsInScript(node);
    }

    private void checkTabsInScript(Element node) {
        if (node.getName().equals("target")) {
            String target = node.attributeValue("name");
            List statements = node.selectNodes("//target[@name='" + target + "']/script | //target[@name='" + target + "']/*[name()=\"hlm:python\"]");
            for (Node statement : statements) {
                if (!statement.getText().contains("\t")) continue;
                this.log("Target " + target + " has a script with tabs");
            }
        }
    }

    @Override
    public void run(String antFileName) {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setValidating(true);
            SAXParser parser = saxFactory.newSAXParser();
            AntLintHandler handler = new AntLintHandler(this);
            handler.setTabCharacterCheck(true);
            parser.parse(new File(antFileName), (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

