/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.maven.scm.provider.hg.command.log;

import com.nokia.maven.scm.provider.hg.VersionChangeSet;
import com.nokia.maven.scm.provider.hg.command.log.HgChangeLogConsumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.Command;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

public class HgChangeLogCommand
extends AbstractChangeLogCommand
implements Command {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        String[] cmd = new String[]{"log", "--verbose"};
        HgChangeLogConsumer consumer = new HgChangeLogConsumer(this.getLogger(), datePattern);
        ScmResult result = HgUtils.execute((HgConsumer)consumer, (ScmLogger)this.getLogger(), (File)fileSet.getBasedir(), (String[])cmd);
        List<VersionChangeSet> logEntries = consumer.getModifications();
        ArrayList<VersionChangeSet> inRangeAndValid = new ArrayList<VersionChangeSet>();
        startDate = startDate == null ? new Date(0L) : startDate;
        endDate = endDate == null ? new Date() : endDate;
        for (VersionChangeSet logEntry : logEntries) {
            if (logEntry.getFiles().size() <= 0 || logEntry.getDate().before(startDate) || logEntry.getDate().after(endDate)) continue;
            inRangeAndValid.add(logEntry);
        }
        ChangeLogSet changeLogSet = new ChangeLogSet(inRangeAndValid, startDate, endDate);
        return new ChangeLogScmResult(changeLogSet, result);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion, String datePattern) throws ScmException {
        String param = "" + startVersion.getName() + ":" + (endVersion.getName() != null ? endVersion.getName() : "");
        String[] cmd = new String[]{"log", "--verbose", "-r", param};
        HgChangeLogConsumer consumer = new HgChangeLogConsumer(this.getLogger(), datePattern);
        ScmResult result = HgUtils.execute((HgConsumer)consumer, (ScmLogger)this.getLogger(), (File)fileSet.getBasedir(), (String[])cmd);
        List<VersionChangeSet> logEntries = consumer.getModifications();
        Date startDate = new Date(0L);
        Date endDate = new Date();
        ChangeLogSet changeLogSet = new ChangeLogSet(logEntries, startDate, endDate);
        return new ChangeLogScmResult(changeLogSet, result);
    }
}

