/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LDAP
extends Task {
    private String url;
    private String rootdn;
    private String filter;
    private String key;
    private String property;

    public void execute() {
        if (this.url == null) {
            throw new BuildException("'url' attribute is not defined");
        }
        if (this.rootdn == null) {
            throw new BuildException("'rootdn' attribute is not defined");
        }
        if (this.filter == null) {
            throw new BuildException("'filter' attribute is not defined");
        }
        if (this.property == null) {
            throw new BuildException("'property' attribute is not defined");
        }
        if (this.key == null) {
            throw new BuildException("'key' attribute is not defined");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url + "/" + this.rootdn);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            NamingEnumeration<SearchResult> en = ctx.search("", this.filter, controls);
            if (en.hasMore()) {
                SearchResult sr = en.next();
                this.getProject().setProperty(this.property, (String)sr.getAttributes().get(this.key).get());
                return;
            }
        }
        catch (NamingException exc) {
            throw new BuildException(exc.getMessage());
        }
        catch (NullPointerException e) {
            this.log("Not able to retrive LDAP information for " + this.filter);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRootdn() {
        return this.rootdn;
    }

    public void setRootdn(String rootdn) {
        this.rootdn = rootdn;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getOutputProperty() {
        return this.property;
    }

    public void setOutputProperty(String property) {
        this.property = property;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

