/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.CategorizationHandler;
import com.nokia.helium.metadata.ant.types.CategoryEntry;
import com.nokia.helium.metadata.ant.types.LogMetaDataInput;
import com.nokia.helium.metadata.ant.types.SpecialRegex;
import com.nokia.helium.metadata.ant.types.TimeEntry;
import com.nokia.helium.metadata.ant.types.XMLLogMetaDataInput;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class SBSLogMetaDataInput
extends XMLLogMetaDataInput {
    private static final String DRIVE_LETTER_REGEX = "(([a-z]|[A-Z]):(\\\\|/))(.*)(/bld\\.inf)";
    private Logger log = Logger.getLogger(SBSLogMetaDataInput.class);
    private String currentComponent;
    private float currentElapsedTime;
    private String logTextInfo = "";
    private String recipeStatus = "ok";
    private HashMap<String, List<CategoryEntry>> generalTextEntries = new HashMap();
    private CategorizationHandler categorizationHandler;
    private List<SpecialRegex> specialRegexPatternList = new ArrayList<SpecialRegex>();
    private int lineNumber;
    private boolean inMainDataSection;
    private boolean recordText;
    private File cleanLogFile;
    private boolean additionalEntry;
    private Pattern specialCasePattern;
    private HashMap<String, TimeEntry> componentTimeMap = new HashMap();

    public SBSLogMetaDataInput() {
        this.specialRegexPatternList.add(new SpecialRegex("(make.exe|make): \\*\\*\\* No rule to make target.*needed by `(.*)'.*", 2));
        this.specialRegexPatternList.add(new SpecialRegex("(make.exe|make): \\*\\*\\* \\[(.*)\\].*", 2));
    }

    static String removeDriveAndBldInf(String text) {
        Matcher matcher = Pattern.compile(DRIVE_LETTER_REGEX).matcher(text);
        if (matcher.matches()) {
            return matcher.group(4);
        }
        return text;
    }

    static String getComponent(XMLStreamReader streamReader) {
        String currentComponent = SBSLogMetaDataInput.getAttribute("bldinf", streamReader);
        if (currentComponent != null && currentComponent.equals("")) {
            return null;
        }
        if (currentComponent != null) {
            currentComponent = SBSLogMetaDataInput.removeDriveAndBldInf(currentComponent);
        }
        return currentComponent;
    }

    static String getAttribute(String attribute, XMLStreamReader streamReader) {
        int count = streamReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!streamReader.getAttributeLocalName(i).equals(attribute)) continue;
            return streamReader.getAttributeValue(i);
        }
        return null;
    }

    public void setCleanLogFile(File logFile) {
        this.cleanLogFile = logFile;
    }

    @Override
    public boolean characters(XMLStreamReader streamReader) throws Exception {
        HashMap<String, Integer> toProcess = new HashMap<String, Integer>();
        if (this.recordText) {
            this.logTextInfo = this.logTextInfo + streamReader.getText();
        } else if (this.inMainDataSection) {
            String cdataText = streamReader.getText().trim();
            String[] textList = cdataText.split("\n");
            int i = 0;
            for (String text : textList) {
                boolean added = false;
                if (text.trim().equals("")) continue;
                for (SpecialRegex specialRegex : this.specialRegexPatternList) {
                    Matcher matcher = specialRegex.getRegexPattern().matcher(text);
                    int groupPosition = specialRegex.getGroupPosition();
                    List<CategoryEntry> entryList = null;
                    if (!matcher.matches()) continue;
                    String componentName = matcher.group(groupPosition).toLowerCase();
                    CategoryEntry newEntry = new CategoryEntry(text, componentName, "error", streamReader.getLocation().getLineNumber(), this.getCurrentFile().toString());
                    entryList = this.generalTextEntries.get(componentName);
                    if (entryList == null) {
                        entryList = new ArrayList<CategoryEntry>();
                        this.generalTextEntries.put(componentName, entryList);
                    }
                    entryList.add(newEntry);
                    added = true;
                    break;
                }
                if (!added) {
                    toProcess.put(text.trim(), streamReader.getLocation().getLineNumber() + i);
                }
                ++i;
            }
            boolean entryCreated = false;
            for (String textString : toProcess.keySet()) {
                boolean created = this.findAndAddEntries(textString, "general", this.getCurrentFile().toString(), (Integer)toProcess.get(textString));
                if (!created || entryCreated) continue;
                entryCreated = true;
            }
        }
        return false;
    }

    @Override
    public boolean startElement(XMLStreamReader streamReader) throws Exception {
        try {
            String tagName = streamReader.getLocalName();
            if (tagName.equalsIgnoreCase("buildlog")) {
                this.log.debug((Object)"starting with buildlog");
                this.inMainDataSection = true;
            }
            if (tagName.equalsIgnoreCase("recipe")) {
                this.lineNumber = streamReader.getLocation().getLineNumber();
                this.currentComponent = SBSLogMetaDataInput.getComponent(streamReader);
                this.recordText = true;
                this.inMainDataSection = false;
                this.recipeStatus = "ok";
            }
            if (tagName.equalsIgnoreCase("status")) {
                String exit = streamReader.getAttributeValue(null, "exit");
                this.recipeStatus = exit != null ? exit : "ok";
            } else if (tagName.equalsIgnoreCase("error") || tagName.equalsIgnoreCase("warning")) {
                this.lineNumber = streamReader.getLocation().getLineNumber();
                this.currentComponent = SBSLogMetaDataInput.getComponent(streamReader);
                this.recordText = true;
                this.inMainDataSection = false;
            } else if (tagName.equalsIgnoreCase("whatlog")) {
                this.currentComponent = SBSLogMetaDataInput.getComponent(streamReader);
                this.inMainDataSection = false;
            } else if (tagName.equalsIgnoreCase("time")) {
                this.inMainDataSection = false;
                this.currentElapsedTime = Float.valueOf(SBSLogMetaDataInput.getAttribute("elapsed", streamReader)).floatValue();
                if (this.currentComponent != null) {
                    TimeEntry timeObject = this.componentTimeMap.get(this.currentComponent);
                    if (timeObject == null) {
                        timeObject = new TimeEntry(this.currentElapsedTime, this.getCurrentFile().toString());
                        this.componentTimeMap.put(this.currentComponent, timeObject);
                    } else {
                        timeObject.addElapsedTime(this.currentElapsedTime);
                    }
                }
            } else if (tagName.equalsIgnoreCase("clean")) {
                this.inMainDataSection = false;
            } else if (tagName.equalsIgnoreCase("info")) {
                this.inMainDataSection = false;
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception in startelement", (Throwable)ex);
            throw ex;
        }
        return false;
    }

    @Override
    public boolean isAdditionalEntry() {
        block7: {
            try {
                Set<String> componentSet;
                Iterator<String> i$;
                if (!this.componentTimeMap.isEmpty() && (i$ = (componentSet = this.componentTimeMap.keySet()).iterator()).hasNext()) {
                    String component = i$.next();
                    TimeEntry entry = this.componentTimeMap.get(component);
                    this.addEntry("default", component, entry.getFilePath(), -1, null, entry.getElapsedTime());
                    this.componentTimeMap.remove(component);
                    return true;
                }
                if (this.cleanLogFile != null && this.categorizationHandler == null) {
                    this.log.info((Object)"initializing categorization handler");
                    this.categorizationHandler = new CategorizationHandler(this.cleanLogFile, this.generalTextEntries);
                }
                if (this.categorizationHandler == null || !this.categorizationHandler.hasNext()) break block7;
                try {
                    CategoryEntry entry = this.categorizationHandler.getNext();
                    if (entry != null) {
                        this.addEntry(entry.getSeverity(), entry.getCategory(), entry.getLogFile(), entry.getLineNumber(), entry.getText());
                        return true;
                    }
                }
                catch (Exception ex) {
                    this.log.debug((Object)"Exception during categorization handler", (Throwable)ex);
                    return false;
                }
            }
            catch (Exception ex) {
                this.log.debug((Object)"Exception in finding additional entry", (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public boolean endElement(XMLStreamReader streamReader) throws Exception {
        try {
            String tagName = streamReader.getLocalName();
            if (tagName.equalsIgnoreCase("recipe")) {
                this.inMainDataSection = true;
                this.recordText = false;
                if (this.logTextInfo != null) {
                    if (this.currentComponent == null) {
                        this.currentComponent = "general";
                    }
                    LogMetaDataInput.Statistics stat = new LogMetaDataInput.Statistics();
                    boolean entryCreated = this.findAndAddEntries(this.logTextInfo, this.currentComponent, this.getCurrentFile().toString(), this.lineNumber, stat);
                    if (stat.getSeveriry("error") == 0 && this.recipeStatus.equals("failed")) {
                        this.addEntry("error", this.currentComponent, this.getCurrentFile().toString(), this.lineNumber, "ERROR: recipe exit status is failed.");
                        entryCreated = true;
                    }
                    this.logTextInfo = "";
                    this.recipeStatus = "ok";
                    return entryCreated;
                }
            } else {
                if (tagName.equalsIgnoreCase("error") || tagName.equalsIgnoreCase("warning")) {
                    this.inMainDataSection = true;
                    this.recordText = false;
                    if (this.currentComponent == null) {
                        this.currentComponent = "general";
                    }
                    this.addEntry(tagName, this.currentComponent, this.getCurrentFile().toString(), this.lineNumber, this.logTextInfo);
                    this.logTextInfo = "";
                    return true;
                }
                if (tagName.equalsIgnoreCase("whatlog")) {
                    this.inMainDataSection = true;
                    this.addEntry("default", this.currentComponent, this.getCurrentFile().toString(), -1, "");
                    return true;
                }
                if (tagName.equalsIgnoreCase("clean")) {
                    this.inMainDataSection = true;
                } else if (tagName.equalsIgnoreCase("info")) {
                    this.inMainDataSection = true;
                }
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"Exception while processing for sbs metadata input", (Throwable)ex);
            throw ex;
        }
        return false;
    }
}

