/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class WhitespaceAroundCheck
extends Check {
    private boolean mAllowEmptyCtors;
    private boolean mAllowEmptyMethods;

    public int[] getDefaultTokens() {
        return new int[]{80, 114, 106, 112, 108, 124, 104, 113, 107, 82, 127, 101, 116, 120, 118, 111, 72, 119, 96, 85, 92, 97, 91, 83, 88, 67, 95, 84, 110, 117, 126, 99, 128, 102, 115, 125, 98, 109, 73, 122, 7, 105, 123, 103, 60, 100, 151, 174};
    }

    public void setAllowEmptyMethods(boolean aAllow) {
        this.mAllowEmptyMethods = aAllow;
    }

    public void setAllowEmptyConstructors(boolean aAllow) {
        this.mAllowEmptyCtors = aAllow;
    }

    public void visitToken(DetailAST aAST) {
        int type = aAST.getType();
        int parentType = aAST.getParent().getType();
        if ((type == 73 || type == 72) && parentType == 29) {
            return;
        }
        if (type == 60 && parentType == 59) {
            return;
        }
        if (type == 7 && parentType == 33) {
            return;
        }
        if (type == 82 && (parentType == 94 || parentType == 93)) {
            return;
        }
        if (this.emptyMethodBlockCheck(aAST, parentType) || this.emptyCtorBlockCheck(aAST, parentType)) {
            return;
        }
        String[] lines = this.getLines();
        String line = lines[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        int after = aAST.getColumnNo() + aAST.getText().length();
        if (before >= 0 && !Character.isWhitespace(line.charAt(before))) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "ws.notPreceded", aAST.getText());
        }
        if (after >= line.length()) {
            return;
        }
        char nextChar = line.charAt(after);
        if (!(Character.isWhitespace(nextChar) || type == 88 && aAST.getFirstChild().getType() == 45 || type == 73 && (nextChar == ')' || nextChar == ';' || nextChar == ','))) {
            this.log(aAST.getLineNo(), aAST.getColumnNo() + aAST.getText().length(), "ws.notFollowed", aAST.getText());
        }
    }

    private boolean emptyMethodBlockCheck(DetailAST aAST, int aParentType) {
        return this.mAllowEmptyMethods && this.emptyBlockCheck(aAST, aParentType, 9);
    }

    private boolean emptyCtorBlockCheck(DetailAST aAST, int aParentType) {
        return this.mAllowEmptyCtors && this.emptyBlockCheck(aAST, aParentType, 8);
    }

    private boolean emptyBlockCheck(DetailAST aAST, int aParentType, int aMatch) {
        int type = aAST.getType();
        if (type == 73) {
            DetailAST grandParent = aAST.getParent().getParent();
            return aParentType == 7 && grandParent.getType() == aMatch;
        }
        return type == 7 && aParentType == aMatch && aAST.getFirstChild().getType() == 73;
    }
}

