/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.services;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;

public class RuntimeServices {
    protected Session session;

    public RuntimeServices() {
    }

    public RuntimeServices(Session session) {
        this.session = session;
    }

    protected AbstractSession getSession() {
        return (AbstractSession)this.session;
    }

    public boolean getShouldLogMessages() {
        return this.getSession().shouldLogMessages();
    }

    public void setShouldProfilePerformance(boolean shouldProfile) {
        if (shouldProfile && this.getSession().getProfiler() == null) {
            this.getSession().setProfiler(new PerformanceProfiler());
        } else if (!shouldProfile) {
            this.getSession().setProfiler(null);
        }
    }

    public boolean getShouldProfilePerformance() {
        return this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass());
    }

    public void setShouldLogPerformanceProfiler(boolean shouldLogPerformanceProfiler) {
        if (this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass())) {
            ((PerformanceProfiler)this.getSession().getProfiler()).setShouldLogProfile(shouldLogPerformanceProfiler);
        }
    }

    public boolean getShouldLogPerformanceProfiler() {
        if (this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass())) {
            return ((PerformanceProfiler)this.getSession().getProfiler()).shouldLogProfile();
        }
        return false;
    }

    public void setShouldCacheAllStatements(boolean shouldCacheAllStatements) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setShouldCacheAllStatements(shouldCacheAllStatements);
    }

    public boolean getShouldCacheAllStatements() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return false;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldCacheAllStatements();
    }

    public void setStatementCacheSize(int size) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setStatementCacheSize(size);
    }

    public int getStatementCacheSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getStatementCacheSize();
    }

    public void setSequencePreallocationSize(int size) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatasourcePlatform)this.getSession().getDatasourcePlatform()).setSequencePreallocationSize(size);
    }

    public int getSequencePreallocationSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatasourcePlatform)this.getSession().getDatasourcePlatform()).getSequencePreallocationSize();
    }

    public void updatePoolSize(String poolName, int maxSize, int minSize) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            connectionPool.setMaxNumberOfConnections(maxSize);
            connectionPool.setMinNumberOfConnections(minSize);
        }
    }

    public List getAvailableConnectionPools() {
        Vector list = null;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            Map pools = ((ServerSession)this.getSession()).getConnectionPools();
            list = new Vector(pools.size());
            Iterator poolNames = pools.keySet().iterator();
            while (poolNames.hasNext()) {
                list.add(poolNames.next());
            }
        } else {
            list = new Vector();
        }
        return list;
    }

    public List getSizeForPool(String poolName) {
        ConnectionPool connectionPool;
        Vector<Integer> results = new Vector<Integer>(2);
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            results.add(new Integer(connectionPool.getMaxNumberOfConnections()));
            results.add(new Integer(connectionPool.getMinNumberOfConnections()));
        }
        return results;
    }

    public void addNewConnectionPool(String poolName, int maxSize, int minSize, String platform, String driverClassName, String url, String userName, String password) throws ClassNotFoundException {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            DatabaseLogin login = new DatabaseLogin();
            login.setPlatformClassName(platform);
            login.setDriverClassName(driverClassName);
            login.setConnectionString(url);
            login.setUserName(userName);
            login.setEncryptedPassword(password);
            ((ServerSession)this.getSession()).addConnectionPool(poolName, login, minSize, maxSize);
        }
    }

    public void resetAllConnections() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            for (ConnectionPool pool : ((ServerSession)this.getSession()).getConnectionPools().values()) {
                pool.shutDown();
                pool.startUp();
            }
        } else if (ClassConstants.PublicInterfaceDatabaseSession_Class.isAssignableFrom(this.getSession().getClass())) {
            this.getSession().getAccessor().reestablishConnection(this.getSession());
        }
    }

    public List getClassesInSession() {
        return this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
    }

    public List getObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange);
        Vector<Object> results = new Vector<Object>(map.getSize());
        Enumeration objects = map.keys();
        while (objects.hasMoreElements()) {
            results.add(((CacheKey)objects.nextElement()).getObject());
        }
        return results;
    }

    public Integer getNumberOfObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        return new Integer(this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange).getSize());
    }

    public List getObjectsInIdentityMapSubCacheAsMap(String className) throws ClassNotFoundException {
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange);
        List subCache = new ArrayList(0);
        if (ClassConstants.HardCacheWeakIdentityMap_Class.isAssignableFrom(map.getClass())) {
            subCache = ((HardCacheWeakIdentityMap)map).getReferenceCache();
        }
        return subCache;
    }

    public Integer getNumberOfObjectsInIdentityMapSubCache(String className) throws ClassNotFoundException {
        Integer result = new Integer(0);
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange);
        if (map.getClass().isAssignableFrom(ClassConstants.HardCacheWeakIdentityMap_Class)) {
            ExposedNodeLinkedList subCache = ((HardCacheWeakIdentityMap)map).getReferenceCache();
            result = new Integer(subCache.size());
        }
        return result;
    }

    public int getLogLevel(String category) {
        return this.getSession().getLogLevel(category);
    }

    public void setLogLevel(int level) {
        this.getSession().setLogLevel(level);
    }

    public boolean shouldLog(int Level2, String category) {
        return this.getSession().shouldLog(Level2, category);
    }

    public int getProfileWeight() {
        if (this.getSession().isInProfile()) {
            return this.getSession().getProfiler().getProfileWeight();
        }
        return 0;
    }

    public void setProfileWeight(int weight) {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().setProfileWeight(weight);
        }
    }
}

