/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.Focusable;
import com.sardak.antform.interfaces.PropertyComponent;
import com.sardak.antform.interfaces.Requirable;
import com.sardak.antform.types.BaseType;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.tools.ant.Task;

public abstract class DefaultProperty
extends BaseType
implements PropertyComponent,
Focusable {
    private String label;
    private String property;
    private String tooltip;
    private boolean focus = false;
    private boolean editable = true;

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public abstract void addToControlPanel(ControlPanel var1);

    public abstract JComponent getFocusableComponent();

    private void applyTooltip(JComponent component, JLabel label, String tooltipText) {
        if (null != tooltipText && !tooltipText.equals("")) {
            component.setToolTipText(tooltipText);
            if (label != null) {
                label.setToolTipText(tooltipText);
            }
            for (int i = 0; i < component.getComponentCount(); ++i) {
                if (!(component.getComponent(i) instanceof JComponent)) continue;
                this.applyTooltip((JComponent)component.getComponent(i), null, tooltipText);
            }
        }
    }

    protected void initComponent(JComponent component, ControlPanel panel) {
        if (this instanceof Requirable && ((Requirable)((Object)this)).isRequired()) {
            this.setLabel("*" + this.getLabel());
        }
        JLabel labelComponent = panel.makeLabel(this.label);
        labelComponent.setLabelFor(component);
        this.applyTooltip(component, labelComponent, this.tooltip);
        panel.addRight(component);
    }

    public boolean validate(Task task) {
        return this.validate(task, this.getClass().getName());
    }

    public boolean validate(Task task, String widget) {
        boolean attributesAreValid = true;
        if (this.getLabel() == null) {
            task.log(widget + " : attribute \"label\" missing.");
            attributesAreValid = false;
        }
        if (this.getProperty() == null) {
            task.log(widget + " : attribute \"property\" missing.");
            attributesAreValid = false;
        }
        return attributesAreValid;
    }

    public String getCurrentProjectPropertyValue() {
        if (this.getProject() == null) {
            return null;
        }
        return this.getProject().getProperty(this.getProperty());
    }

    public void cancel() {
    }
}

