/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableMetadata
extends TableMetadata {
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();
    private List<JoinColumnMetadata> m_inverseJoinColumns = new ArrayList<JoinColumnMetadata>();

    public JoinTableMetadata() {
        super("<join-table>");
    }

    public JoinTableMetadata(MetadataAnnotation joinTable, MetadataAccessibleObject accessibleObject) {
        super(joinTable, accessibleObject);
        if (joinTable != null) {
            for (Object joinColumn : (Object[])joinTable.getAttributeArray("joinColumns")) {
                this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn, accessibleObject));
            }
            for (Object inverseJoinColumn : (Object[])joinTable.getAttributeArray("inverseJoinColumns")) {
                this.m_inverseJoinColumns.add(new JoinColumnMetadata((MetadataAnnotation)inverseJoinColumn, accessibleObject));
            }
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof JoinTableMetadata) {
            JoinTableMetadata joinTable = (JoinTableMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_joinColumns, joinTable.getJoinColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_inverseJoinColumns, joinTable.getInverseJoinColumns());
        }
        return false;
    }

    @Override
    public String getCatalogContext() {
        return "metadata_default_join_table_catalog";
    }

    public List<JoinColumnMetadata> getInverseJoinColumns() {
        return this.m_inverseJoinColumns;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    @Override
    public String getNameContext() {
        return "metadata_default_join_table_name";
    }

    @Override
    public String getSchemaContext() {
        return "metadata_default_join_table_schema";
    }

    public void setInverseJoinColumns(List<JoinColumnMetadata> inverseJoinColumns) {
        this.m_inverseJoinColumns = inverseJoinColumns;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }
}

