/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaModelInputImpl
implements JavaModelInput {
    private JavaClass[] jClasses;
    private JavaModel jModel;
    private Map<JavaClass, Type> javaClassToType;

    public JavaModelInputImpl(Type[] types, JavaModel javaModel) {
        this.jClasses = new JavaClass[types.length];
        this.javaClassToType = new HashMap<JavaClass, Type>();
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            if (type instanceof Class) {
                this.jClasses[i] = new JavaClassImpl((Class)type);
            } else {
                ParameterizedType pType = (ParameterizedType)type;
                this.jClasses[i] = new JavaClassImpl(pType, (Class)pType.getRawType());
            }
            this.javaClassToType.put(this.jClasses[i], type);
        }
        this.jModel = javaModel;
    }

    public JavaModelInputImpl(Class[] classes, JavaModel javaModel) {
        this.jClasses = new JavaClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.jClasses[i] = new JavaClassImpl(classes[i]);
        }
        this.jModel = javaModel;
    }

    @Override
    public JavaClass[] getJavaClasses() {
        return this.jClasses;
    }

    @Override
    public JavaModel getJavaModel() {
        return this.jModel;
    }

    public Map<JavaClass, Type> getJavaClassToType() {
        return this.javaClassToType;
    }
}

