/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.diamonds;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLMerger {
    private Logger log = Logger.getLogger(this.getClass());
    private File merge;
    private Document doc;
    private Element root;

    public XMLMerger(File merge) throws XMLMergerException {
        this.log.debug((Object)("Merging into: " + merge.getAbsolutePath()));
        try {
            this.merge = merge;
            SAXReader reader = new SAXReader();
            this.doc = reader.read(merge);
            this.root = this.doc.getRootElement();
        }
        catch (DocumentException e) {
            throw new XMLMergerException(e.getMessage());
        }
    }

    public void merge(File data) throws XMLMergerException {
        this.log.debug((Object)("Merging " + data.getAbsolutePath()));
        try {
            SAXReader reader = new SAXReader();
            Document dataDoc = reader.read(data);
            Element dataRoot = dataDoc.getRootElement();
            if (!this.root.getName().equals(dataRoot.getName())) {
                throw new XMLMergerException("Trying to merge incompatible xml format ('" + this.root.getName() + "'!='" + dataRoot.getName() + "')");
            }
            this.mergeNode(this.root, dataRoot);
            this.write();
        }
        catch (DocumentException e) {
            throw new XMLMergerException(e.getMessage());
        }
    }

    protected void mergeNode(Element dest, Element src) {
        for (Element e : src.elements()) {
            List ses = dest.elements(e.getName());
            boolean add = true;
            for (Element se : ses) {
                if (!this.areSame(se, e)) continue;
                this.log.debug((Object)("Element " + e.getName() + " already found in dest."));
                add = false;
            }
            if (add) {
                this.log.debug((Object)("Adding node " + e.getName() + " to " + dest.getName()));
                dest.add(e.detach());
                continue;
            }
            if (ses.size() <= 0) continue;
            this.log.debug((Object)("Merging " + ((Element)ses.get(0)).getName() + " to " + e.getName()));
            this.mergeNode((Element)ses.get(0), e);
        }
    }

    protected boolean areSame(Element a, Element b) {
        this.log.debug((Object)("areSame:" + a + " <=> " + b));
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        this.log.debug((Object)"same attribute list size?");
        if (a.attributes().size() != b.attributes().size()) {
            return false;
        }
        this.log.debug((Object)"same attribute list?");
        for (Attribute attra : a.attributes()) {
            Attribute attrb = b.attribute(attra.getName());
            if (attrb != null && attra.getValue().equals(attrb.getValue())) continue;
            return false;
        }
        return a.getTextTrim().equals(b.getTextTrim());
    }

    protected void write() throws XMLMergerException {
        this.log.debug((Object)("Writing " + this.merge.getAbsolutePath()));
        try {
            FileOutputStream fos = new FileOutputStream(this.merge);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)fos, format);
            writer.write(this.doc);
            writer.flush();
        }
        catch (Exception e) {
            throw new XMLMergerException(e.getMessage());
        }
    }

    public class XMLMergerException
    extends Exception {
        private static final long serialVersionUID = 7624650310086957316L;

        public XMLMergerException(String msg) {
            super(msg);
        }
    }
}

