/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.logger.ant.taskdefs;

import com.nokia.helium.logger.ant.listener.AntLoggingHandler;
import com.nokia.helium.logger.ant.listener.Handler;
import com.nokia.helium.logger.ant.listener.RecorderEntry;
import com.nokia.helium.logger.ant.listener.StatusAndLogListener;
import com.nokia.helium.logger.ant.types.RecordFilter;
import com.nokia.helium.logger.ant.types.RecordFilterSet;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.LogLevel;

public class LogRecorder
extends Task
implements Handler {
    private static Hashtable<File, RecorderEntry> recorderEntries = new Hashtable();
    private File fileName;
    private boolean append;
    private Boolean start;
    private boolean backup;
    private String backupProperty;
    private int loglevel = -1;
    private boolean emacsMode;
    private Vector<RecordFilter> recordFilters = new Vector();
    private Vector<RecordFilterSet> recordFilterSet = new Vector();
    private Vector<String> regExpList = new Vector();

    public void execute() {
        Object object;
        if (StatusAndLogListener.getStatusAndLogListener() == null) {
            this.log("The StatusAndLogListener is not available.", 1);
            return;
        }
        AntLoggingHandler antLoggingHandler = (AntLoggingHandler)StatusAndLogListener.getStatusAndLogListener().getHandler(AntLoggingHandler.class);
        this.validateAttributes();
        this.addAllRecordFilters();
        this.initAndReplaceProperties();
        if (this.start.booleanValue() && this.start.booleanValue() && this.backup && this.fileName.exists()) {
            try {
                object = File.createTempFile(this.fileName.getName(), null, this.fileName.getParentFile());
                ((File)object).delete();
                this.log("Backing up " + this.fileName + " as " + object);
                if (!this.fileName.renameTo((File)object)) {
                    this.log("Error renaming the backup file.", 0);
                }
                if (((File)object).exists() && this.backupProperty != null) {
                    this.getProject().setNewProperty(this.backupProperty, ((File)object).getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                this.log("Error creating the backup file: " + iOException, 0);
            }
        }
        if (!this.fileName.getParentFile().exists()) {
            this.fileName.getParentFile().mkdirs();
        }
        object = this.getRecorder(this.fileName, this.getProject());
        ((RecorderEntry)object).setMessageOutputLevel(this.loglevel);
        ((RecorderEntry)object).setEmacsMode(this.emacsMode);
        if (this.start != null) {
            if (this.start.booleanValue()) {
                if (antLoggingHandler != null) {
                    if (antLoggingHandler.getCurrentStageName() != null) {
                        antLoggingHandler.doLoggingAction(antLoggingHandler.getCurrentStageName(), false, "Stopping", this, this.getOwningTarget());
                    } else {
                        antLoggingHandler.doLoggingAction("default", false, "Stopping", this, this.getOwningTarget());
                    }
                }
                ((RecorderEntry)object).reopenFile();
                ((RecorderEntry)object).setRecordState(this.start);
            } else {
                ((RecorderEntry)object).setRecordState(this.start);
                ((RecorderEntry)object).closeFile();
                if (antLoggingHandler != null) {
                    if (antLoggingHandler.getCurrentStageName() != null) {
                        antLoggingHandler.doLoggingAction(antLoggingHandler.getCurrentStageName(), true, "Starting", this, this.getOwningTarget());
                    } else {
                        antLoggingHandler.doLoggingAction("default", true, "Starting", this, this.getOwningTarget());
                    }
                }
            }
        }
    }

    private void validateAttributes() {
        if (this.fileName == null) {
            throw new BuildException("filename attribute should be specified for helium recorder task.");
        }
    }

    public void setName(File file) {
        this.fileName = file;
    }

    public File getName() {
        return this.fileName;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setBackup(boolean bl) {
        this.backup = bl;
    }

    public void setBackupProperty(String string) {
        this.backupProperty = string;
    }

    public void setLoglevel(VerbosityLevelChoices verbosityLevelChoices) {
        this.loglevel = verbosityLevelChoices.getLevel();
    }

    public void setEmacsMode(boolean bl) {
        this.emacsMode = bl;
    }

    public boolean getEmacsMode() {
        return this.emacsMode;
    }

    public void addRecordFilter(RecordFilter recordFilter) {
        if (!this.recordFilters.contains((Object)recordFilter)) {
            this.recordFilters.add(recordFilter);
        }
    }

    public void addRecordFilterSet(RecordFilterSet recordFilterSet) {
        if (!this.recordFilterSet.contains((Object)recordFilterSet)) {
            this.recordFilterSet.add(recordFilterSet);
        }
    }

    public void setAction(ActionChoices actionChoices) {
        this.start = actionChoices.getValue().equalsIgnoreCase("start") ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean getAction() {
        return this.start;
    }

    protected RecorderEntry getRecorder(File file, Project project) {
        RecorderEntry recorderEntry = recorderEntries.get(file);
        if (recorderEntry == null) {
            recorderEntry = new RecorderEntry(file);
            for (String string : this.regExpList) {
                if (string.equals("")) continue;
                String string2 = Pattern.quote(string);
                recorderEntry.addRegexp(string2);
            }
            recorderEntry.openFile(this.append);
            recorderEntries.put(this.fileName, recorderEntry);
        }
        return recorderEntry;
    }

    public void addAllRecordFilters() {
        for (RecordFilterSet recordFilterSet : this.recordFilterSet) {
            this.recordFilters.addAll(recordFilterSet.getAllFilters());
        }
    }

    @Override
    public void handleBuildFinished(BuildEvent buildEvent) {
    }

    @Override
    public void handleBuildStarted(BuildEvent buildEvent) {
    }

    @Override
    public void handleTargetFinished(BuildEvent buildEvent) {
    }

    @Override
    public void handleTargetStarted(BuildEvent buildEvent) {
    }

    public void initAndReplaceProperties() {
        Pattern pattern = null;
        Matcher matcher = null;
        for (RecordFilter recordFilter : this.recordFilters) {
            if (recordFilter.getRegExp() == null) {
                throw new BuildException("\"regexp\" attribute should not have null value for recordfilter");
            }
            if (recordFilter.getRegExp() == null) continue;
            pattern = Pattern.compile("\\$\\{(.*)}");
            matcher = pattern.matcher(recordFilter.getRegExp());
            if (matcher.find()) {
                this.regExpList.add(this.getProject().replaceProperties(recordFilter.getRegExp()));
                continue;
            }
            this.regExpList.add(recordFilter.getRegExp());
        }
    }

    public static class VerbosityLevelChoices
    extends LogLevel {
    }

    public static class ActionChoices
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"start", "stop"};

        public String[] getValues() {
            return VALUES;
        }
    }
}

