/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.imaker;

import com.nokia.helium.core.plexus.CommandBase;
import com.nokia.helium.core.plexus.StreamRecorder;
import com.nokia.helium.imaker.HelpConfigStreamConsumer;
import com.nokia.helium.imaker.HelpTargetListStreamConsumer;
import com.nokia.helium.imaker.IMakerException;
import com.nokia.helium.imaker.PrintVarSteamConsumer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class IMaker
extends CommandBase<IMakerException> {
    private static final String TEMP_ROMBUILD_DIR = "epoc32/rombuild/temp";
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private File epocroot;

    public IMaker(File epocroot) {
        this.epocroot = epocroot;
    }

    public File createWorkDir() throws IMakerException {
        try {
            File tempRootDir = new File(this.getEpocroot(), TEMP_ROMBUILD_DIR);
            tempRootDir.mkdirs();
            File tempDir = File.createTempFile("helium-imaker", "", tempRootDir);
            tempDir.delete();
            tempDir.mkdirs();
            return tempDir;
        }
        catch (IOException e) {
            throw new IMakerException(e.getMessage(), e);
        }
    }

    public File getEpocroot() {
        return this.epocroot;
    }

    public String getVersion() throws IMakerException {
        this.log.debug((Object)"getVersion");
        String[] args = new String[]{"version"};
        StreamRecorder rec = new StreamRecorder();
        this.execute(args, (StreamConsumer)rec);
        return rec.getBuffer().toString().trim();
    }

    public String getVariable(String name) throws IMakerException {
        this.log.debug((Object)("getVariable: " + name));
        String[] args = new String[]{"print-" + name};
        PrintVarSteamConsumer consumer = new PrintVarSteamConsumer(name);
        this.execute(args, consumer);
        return consumer.getValue();
    }

    public String getVariable(String name, File configuration) throws IMakerException {
        this.log.debug((Object)("getVariable: " + name + " - " + configuration));
        String[] args = new String[]{"-f", configuration.getAbsolutePath(), "print-" + name};
        PrintVarSteamConsumer consumer = new PrintVarSteamConsumer(name);
        this.execute(args, consumer);
        return consumer.getValue();
    }

    public List<String> getConfigurations() throws IMakerException {
        this.log.debug((Object)"getConfigurations");
        String[] args = new String[]{"help-config"};
        HelpConfigStreamConsumer consumer = new HelpConfigStreamConsumer();
        this.execute(args, consumer);
        return consumer.getConfigurations();
    }

    public List<String> getTargets(String configuration) throws IMakerException {
        this.log.debug((Object)"getConfigurations");
        String[] args = new String[]{"-f", configuration, "help-target-*-list"};
        HelpTargetListStreamConsumer consumer = new HelpTargetListStreamConsumer();
        this.execute(args, consumer);
        return consumer.getTargets();
    }

    public List<String> getTargets(File configuration) throws IMakerException {
        return this.getTargets(configuration.getAbsolutePath());
    }

    protected String getExecutable() {
        return "imaker";
    }

    public File getWorkingDir() {
        return this.getEpocroot();
    }

    protected void throwException(String message, Throwable t) throws IMakerException {
        throw new IMakerException(message, t);
    }
}

