/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata;

import com.nokia.helium.jpa.ORMReader;
import fmpp.Engine;
import fmpp.tdd.DataLoader;
import freemarker.ext.beans.ArrayModel;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ORMFMPPLoader
implements DataLoader {
    private static final int READ_LIMIT = 20000;
    private static Logger log = Logger.getLogger(ORMFMPPLoader.class);
    private ORMReader reader;

    public Object load(Engine engine, List args) throws Exception {
        ListIterator iter = args.listIterator();
        int argsSize = args.size();
        if (argsSize < 1) {
            throw new Exception("Input DB path should be provided to load into FMPP.");
        }
        return new ORMQueryModeModel((String)args.get(0));
    }

    private class ORMObjectModel
    extends BeanModel {
        public ORMObjectModel(Object obj) {
            super(obj, new BeansWrapper());
        }
    }

    private class ORMTemplateModelIterator
    implements TemplateModelIterator {
        private String query;
        private List<Map<String, Object>> rowList;
        private int currentOffsetIndex;
        private String returnType;
        private boolean nativeQuery;
        private ORMReader ormReader;

        public ORMTemplateModelIterator(ORMReader reader, String queryString, String type, String retType) {
            this.ormReader = reader;
            this.query = queryString;
            this.returnType = retType;
            if (type.startsWith("native")) {
                this.nativeQuery = true;
            }
        }

        public TemplateModel next() {
            if (this.rowList != null) {
                Map<String, Object> toRet = this.rowList.remove(0);
                if (toRet != null && toRet.getClass().isArray()) {
                    return new ArrayModel(toRet, new BeansWrapper());
                }
                return new ORMObjectModel(toRet);
            }
            return new ORMObjectModel(null);
        }

        public boolean hasNext() {
            if (this.rowList == null) {
                this.rowList = this.nativeQuery ? this.ormReader.executeNativeQuery(this.query, this.returnType) : this.ormReader.executeQuery(this.query);
            }
            if (this.rowList == null) {
                return false;
            }
            return this.rowList.size() != 0;
        }
    }

    private class ORMQueryModel
    implements TemplateCollectionModel {
        private ORMReader ormReader;
        private String queryType;
        private String query;
        private String returnType;

        public ORMQueryModel(ORMReader reader, String queryString, String type, String retType) {
            this.ormReader = reader;
            this.queryType = type;
            this.query = queryString;
            this.returnType = retType;
        }

        public TemplateModelIterator iterator() {
            return new ORMTemplateModelIterator(this.ormReader, this.query, this.queryType, this.returnType);
        }
    }

    private class ORMSequenceModel
    implements TemplateSequenceModel {
        private List ormList = new ArrayList();

        public ORMSequenceModel(Object obj) {
            this.ormList.add(obj);
        }

        public int size() {
            return this.ormList.size();
        }

        public TemplateModel get(int index) {
            if (index < this.ormList.size()) {
                Object obj = this.ormList.get(index);
                if (obj instanceof String) {
                    return new SimpleScalar((String)obj);
                }
                if (obj instanceof Number) {
                    return new SimpleNumber((Number)obj);
                }
                if (obj == null) {
                    return null;
                }
                return new ORMObjectModel(obj);
            }
            return null;
        }
    }

    private class QueryTemplateModel
    implements TemplateHashModel {
        private String dbPath;
        private String queryMode;
        private String returnType;
        private TemplateModel resultObject;

        public QueryTemplateModel(String path, String mode, String retType) {
            this.dbPath = path;
            this.queryMode = mode;
            this.returnType = retType;
        }

        public TemplateModel get(String query) {
            this.resultObject = this.queryMode.equals("jpasingle") ? this.getModel(new ORMReader(this.dbPath).executeSingleResult(query, this.returnType)) : new ORMQueryModel(new ORMReader(this.dbPath), query, this.queryMode, this.returnType);
            return this.resultObject;
        }

        private TemplateModel getModel(Object result) {
            return new ORMSequenceModel(result);
        }

        public boolean isEmpty() {
            return false;
        }
    }

    private class ORMQueryModeModel
    implements TemplateHashModel {
        private String dbPath;

        public ORMQueryModeModel(String path) {
            File actualPath = new File(path);
            String fileName = actualPath.getName();
            this.dbPath = new File(actualPath.getParent(), fileName.toLowerCase()).getPath();
        }

        public QueryTemplateModel get(String mode) {
            String[] splitString;
            String retType = null;
            String actualMode = mode;
            if (mode.startsWith("native") && (splitString = mode.split(":")).length == 2) {
                actualMode = splitString[0];
                retType = splitString[1];
            }
            return new QueryTemplateModel(this.dbPath, actualMode, retType);
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

