/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.CategoryEntry;
import com.nokia.helium.metadata.ant.types.SBSLogMetaDataInput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

class CategorizationHandler {
    private String currentComponent;
    private boolean isInFileTag;
    private HashMap<String, List<CategoryEntry>> categoryList;
    private List<CategoryEntry> currentList;
    private XMLInputFactory xmlInputFactory;
    private XMLStreamReader xmlStreamReader;
    private Logger log = Logger.getLogger(CategorizationHandler.class);

    public CategorizationHandler(File cleanLogFile, HashMap<String, List<CategoryEntry>> ctgMap) {
        this.categoryList = ctgMap;
        if (cleanLogFile != null) {
            try {
                this.xmlInputFactory = XMLInputFactory.newInstance();
                this.xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(cleanLogFile.toString(), new BufferedInputStream(new FileInputStream(cleanLogFile)));
            }
            catch (Exception ex) {
                this.log.debug((Object)"exception while initializing stax processor", (Throwable)ex);
            }
        }
    }

    public boolean hasNext() {
        boolean generalEntriesStatus = this.categoryList != null && !this.categoryList.isEmpty();
        boolean currentListStatus = this.currentList != null && !this.currentList.isEmpty();
        return generalEntriesStatus || currentListStatus;
    }

    public boolean startElement(XMLStreamReader streamReader) throws Exception {
        String tagName = streamReader.getLocalName();
        if (tagName.equals("clean")) {
            this.currentComponent = this.getCategory(streamReader);
            if (this.currentComponent != null) {
                this.currentComponent = SBSLogMetaDataInput.removeDriveAndBldInf(this.currentComponent);
            }
        }
        if (tagName.equals("file")) {
            this.isInFileTag = true;
        }
        return false;
    }

    public boolean endElement(XMLStreamReader streamReader) throws Exception {
        String tagName = streamReader.getLocalName();
        if (tagName.equals("file")) {
            this.isInFileTag = false;
        }
        return false;
    }

    private String getCategory(XMLStreamReader streamReader) {
        int count = streamReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!streamReader.getAttributeLocalName(i).equals("bldinf")) continue;
            return streamReader.getAttributeValue(i);
        }
        return null;
    }

    private String characters(XMLStreamReader xmlStreamReader) {
        if (this.isInFileTag) {
            return xmlStreamReader.getText().toLowerCase();
        }
        return null;
    }

    private List<CategoryEntry> getEntry(String path) {
        Set<String> categorySet = this.categoryList.keySet();
        for (String key : categorySet) {
            if (!path.toLowerCase().equals(key)) continue;
            List<CategoryEntry> entry = this.categoryList.get(key);
            this.categoryList.remove(key);
            return entry;
        }
        return null;
    }

    private void updateCategoryEntries(List<CategoryEntry> categoryList, String category) {
        for (CategoryEntry entry : categoryList) {
            entry.setCategory(category);
        }
    }

    public CategoryEntry getNext() throws Exception {
        try {
            if (this.currentList != null && !this.currentList.isEmpty()) {
                CategoryEntry entry = this.currentList.get(0);
                this.currentList.remove(0);
                return entry;
            }
            if (this.xmlStreamReader != null) {
                while (this.xmlStreamReader.hasNext()) {
                    int eventType = this.xmlStreamReader.next();
                    switch (eventType) {
                        case 1: {
                            this.startElement(this.xmlStreamReader);
                            break;
                        }
                        case 2: {
                            this.endElement(this.xmlStreamReader);
                            break;
                        }
                        case 4: {
                            String path = this.characters(this.xmlStreamReader);
                            if (path == null) break;
                            this.currentList = this.getEntry(path);
                            if (this.currentList == null || this.currentList.isEmpty() || this.currentComponent == null) break;
                            this.updateCategoryEntries(this.currentList, this.currentComponent);
                            CategoryEntry entry = this.currentList.remove(0);
                            return entry;
                        }
                    }
                }
                if (this.xmlStreamReader != null) {
                    this.close();
                }
            }
            Set<String> categorySet = this.categoryList.keySet();
            for (String key : categorySet) {
                this.currentList = this.categoryList.remove(key);
                if (this.currentList == null || this.currentList.isEmpty()) continue;
                this.updateCategoryEntries(this.currentList, "general");
                CategoryEntry entry = this.currentList.remove(0);
                return entry;
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception in categorization", (Throwable)ex);
            throw ex;
        }
        return null;
    }

    private void close() {
        try {
            if (this.xmlStreamReader != null) {
                this.xmlStreamReader.close();
                this.xmlStreamReader = null;
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception while closing xml stream", (Throwable)ex);
        }
    }
}

