/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BackupValueHolder;
import org.eclipse.persistence.internal.indirection.BatchValueHolder;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class TransparentIndirectionPolicy
extends IndirectionPolicy {
    protected static Integer defaultContainerSize;
    protected ContainerPolicy containerPolicy;

    public Object backupCloneAttribute(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        if (!(attributeValue instanceof IndirectContainer) || this.objectIsInstantiated(attributeValue)) {
            return super.backupCloneAttribute(attributeValue, clone, backup, unitOfWork);
        }
        return this.buildBackupClone((IndirectContainer)attributeValue);
    }

    protected Object buildBackupClone(IndirectContainer container) {
        UnitOfWorkValueHolder containerValueHolder = (UnitOfWorkValueHolder)container.getValueHolder();
        BackupValueHolder backupValueHolder = new BackupValueHolder(containerValueHolder);
        containerValueHolder.setBackupValueHolder(backupValueHolder);
        return this.buildIndirectContainer(backupValueHolder);
    }

    protected IndirectContainer buildIndirectContainer() {
        if (defaultContainerSize != null) {
            return (IndirectContainer)this.getContainerPolicy().containerInstance(TransparentIndirectionPolicy.getDefaultContainerSize());
        }
        return (IndirectContainer)this.getContainerPolicy().containerInstance();
    }

    protected Object buildIndirectContainer(ValueHolderInterface valueHolder) {
        IndirectContainer result = this.buildIndirectContainer();
        result.setValueHolder(valueHolder);
        return result;
    }

    public Object buildIndirectObject(ValueHolderInterface valueHolder) {
        return this.buildIndirectContainer(valueHolder);
    }

    public Object cloneAttribute(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        ValueHolderInterface valueHolder = null;
        Object container = null;
        IndirectList indirectList = null;
        IndirectContainer indirectContainer = null;
        if (attributeValue instanceof IndirectContainer) {
            indirectContainer = (IndirectContainer)attributeValue;
            valueHolder = indirectContainer.getValueHolder();
            if (indirectContainer instanceof IndirectList) {
                indirectList = (IndirectList)indirectContainer;
            }
        }
        if (!buildDirectlyFromRow && unitOfWork.isOriginalNewObject(original)) {
            if (valueHolder instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolder).isInstantiated() && ((DatabaseValueHolder)valueHolder).getSession() == null && !((DatabaseValueHolder)valueHolder).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(original, this.mapping);
            }
            if (this.mapping.getRelationshipPartner() == null) {
                container = this.mapping.buildCloneForPartObject(attributeValue, original, clone, unitOfWork, false);
            } else {
                if (indirectContainer == null) {
                    valueHolder = new ValueHolder(attributeValue);
                }
                AbstractRecord row = null;
                if (valueHolder instanceof DatabaseValueHolder) {
                    row = ((DatabaseValueHolder)valueHolder).getRow();
                }
                UnitOfWorkValueHolder newValueHolder = this.mapping.createUnitOfWorkValueHolder(valueHolder, original, clone, row, unitOfWork, buildDirectlyFromRow);
                container = this.buildIndirectContainer(newValueHolder);
                Object cloneCollection = this.mapping.buildCloneForPartObject(attributeValue, original, clone, unitOfWork, false);
                newValueHolder.privilegedSetValue(cloneCollection);
                newValueHolder.setInstantiated();
            }
        } else {
            if (indirectContainer == null) {
                valueHolder = new ValueHolder(attributeValue);
            }
            AbstractRecord row = null;
            if (valueHolder instanceof DatabaseValueHolder) {
                row = ((DatabaseValueHolder)valueHolder).getRow();
            }
            UnitOfWorkValueHolder uowValueHolder = this.mapping.createUnitOfWorkValueHolder(valueHolder, original, clone, row, unitOfWork, buildDirectlyFromRow);
            if (indirectContainer == null || !buildDirectlyFromRow) {
                container = this.buildIndirectContainer(uowValueHolder);
            } else {
                indirectContainer.setValueHolder(uowValueHolder);
                container = indirectContainer;
            }
        }
        if (this.mapping.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && ((ChangeTracker)clone)._persistence_getPropertyChangeListener() != null && container instanceof CollectionChangeTracker) {
            ((CollectionChangeTracker)container).setTrackedAttributeName(this.mapping.getAttributeName());
            ((CollectionChangeTracker)container)._persistence_setPropertyChangeListener(((ChangeTracker)clone)._persistence_getPropertyChangeListener());
        }
        if (indirectList != null) {
            ((IndirectList)container).setIsListOrderBrokenInDb(indirectList.isListOrderBrokenInDb());
        }
        return container;
    }

    protected boolean containerPolicyIsValid() {
        return Helper.classImplementsInterface(this.getContainerClass(), ClassConstants.IndirectContainer_Class);
    }

    public Vector extractPrimaryKeyForReferenceObject(Object referenceObject, AbstractSession session) {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public AbstractRecord extractReferenceRow(Object referenceObject) {
        if (this.objectIsInstantiated(referenceObject)) {
            return null;
        }
        return ((DatabaseValueHolder)((IndirectContainer)referenceObject).getValueHolder()).getRow();
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        Object container = this.getMapping().getAttributeValueFromObject(object);
        if (container instanceof IndirectContainer || !(((IndirectContainer)container).getValueHolder() instanceof RemoteValueHolder)) {
            RemoteValueHolder valueHolder = (RemoteValueHolder)((IndirectContainer)container).getValueHolder();
            valueHolder.setSession(session);
            valueHolder.setMapping(this.getMapping());
            if (!query.shouldMaintainCache() && (!query.shouldCascadeParts() || query.shouldCascadePrivateParts() && !this.getMapping().isPrivateOwned())) {
                valueHolder.setQuery(null);
            } else {
                valueHolder.setQuery(query);
            }
            valueHolder.setUninstantiated();
        } else {
            this.getMapping().fixRealObjectReferences(object, objectDescriptors, processedObjects, query, session);
        }
    }

    protected Class getContainerClass() {
        return this.getContainerPolicy().getContainerClass();
    }

    protected ContainerPolicy getContainerPolicy() {
        if (this.containerPolicy == null) {
            this.containerPolicy = this.getCollectionMapping().getContainerPolicy();
        }
        return this.containerPolicy;
    }

    protected static int getDefaultContainerSize() {
        return defaultContainerSize;
    }

    public Object getOriginalIndirectionObject(Object unitOfWorkIndirectionObject, AbstractSession session) {
        IndirectContainer container = (IndirectContainer)unitOfWorkIndirectionObject;
        if (container.getValueHolder() instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolder = ((UnitOfWorkValueHolder)container.getValueHolder()).getWrappedValueHolder();
            if (valueHolder == null && session.isRemoteUnitOfWork()) {
                RemoteSessionController controller = ((RemoteUnitOfWork)session).getParentSessionController();
                valueHolder = (ValueHolderInterface)controller.getRemoteValueHolders().get(((UnitOfWorkValueHolder)container.getValueHolder()).getWrappedValueHolderRemoteID());
            }
            return this.buildIndirectContainer(valueHolder);
        }
        return container;
    }

    public Object getOriginalIndirectionObjectForMerge(Object unitOfWorkIndirectionObject, AbstractSession session) {
        IndirectContainer container = (IndirectContainer)this.getOriginalIndirectionObject(unitOfWorkIndirectionObject, session);
        DatabaseValueHolder holder = (DatabaseValueHolder)container.getValueHolder();
        if (holder != null && holder.getSession() != null) {
            holder.setSession(session);
        }
        return container;
    }

    public Object getOriginalValueHolder(Object unitOfWorkIndirectionObject, AbstractSession session) {
        if (!(unitOfWorkIndirectionObject instanceof IndirectContainer)) {
            return new ValueHolder();
        }
        IndirectContainer container = (IndirectContainer)unitOfWorkIndirectionObject;
        if (container.getValueHolder() instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolder = ((UnitOfWorkValueHolder)container.getValueHolder()).getWrappedValueHolder();
            if (valueHolder == null && session.isRemoteUnitOfWork()) {
                RemoteSessionController controller = ((RemoteUnitOfWork)session).getParentSessionController();
                valueHolder = (ValueHolderInterface)controller.getRemoteValueHolders().get(((UnitOfWorkValueHolder)container.getValueHolder()).getWrappedValueHolderRemoteID());
            }
            return valueHolder;
        }
        return container.getValueHolder();
    }

    public Object getRealAttributeValueFromObject(Object object, Object attribute) {
        return attribute;
    }

    public void instantiateObject(Object object, Object attribute) {
        this.getContainerPolicy().sizeFor(attribute);
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        Object result = remoteValueHolder.getServerIndirectionObject();
        this.getContainerPolicy().sizeFor(result);
        return result;
    }

    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        super.setRealAttributeValueInObject(target, attributeValue);
    }

    public void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        if (attributeValue instanceof IndirectContainer) {
            iterator.iterateIndirectContainerForMapping((IndirectContainer)attributeValue, this.getMapping());
        } else {
            super.iterateOnAttributeValue(iterator, attributeValue);
        }
    }

    public void mergeRemoteValueHolder(Object clientSideDomainObject, Object serverSideDomainObject, MergeManager mergeManager) {
        IndirectContainer serverContainer = (IndirectContainer)this.getMapping().getAttributeValueFromObject(serverSideDomainObject);
        RemoteValueHolder serverValueHolder = (RemoteValueHolder)serverContainer.getValueHolder();
        this.mergeClientIntoServerValueHolder(serverValueHolder, mergeManager);
        this.getMapping().setAttributeValueInObject(clientSideDomainObject, serverContainer);
    }

    public Object nullValueFromRow() {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public boolean objectIsInstantiated(Object object) {
        if (object instanceof IndirectContainer) {
            return ((IndirectContainer)object).isInstantiated();
        }
        return true;
    }

    public boolean objectIsInstantiatedOrChanged(Object object) {
        return this.objectIsInstantiated(object) || object instanceof IndirectCollection && ((IndirectCollection)object).hasDeferredChanges();
    }

    public static void setDefaultContainerSize(int defaultSize) {
        defaultContainerSize = new Integer(defaultSize);
    }

    protected boolean typeIsValid(Class declaredType) {
        if (Helper.classIsSubclass(this.getContainerClass(), declaredType)) {
            return true;
        }
        return Helper.classImplementsInterface(this.getContainerClass(), declaredType);
    }

    public boolean usesTransparentIndirection() {
        return true;
    }

    public Object validateAttributeOfInstantiatedObject(Object attributeValue) {
        if (attributeValue == null) {
            return this.buildIndirectContainer();
        }
        return attributeValue;
    }

    public void validateContainerPolicy(IntegrityChecker checker) throws DescriptorException {
        super.validateContainerPolicy(checker);
        if (!this.containerPolicyIsValid()) {
            checker.handleError(DescriptorException.invalidContainerPolicyWithTransparentIndirection(this.getMapping(), this.getContainerPolicy()));
        }
        if (this.getContainerPolicy().isMapPolicy() && (((ForeignReferenceMapping)this.getMapping()).getRelationshipPartnerAttributeName() != null || this.getMapping().getRelationshipPartner() != null)) {
            checker.handleError(DescriptorException.unsupportedTypeForBidirectionalRelationshipMaintenance(this.getMapping(), this.getContainerPolicy()));
        }
    }

    public void validateDeclaredAttributeType(Class attributeType, IntegrityChecker checker) throws DescriptorException {
        super.validateDeclaredAttributeType(attributeType, checker);
        if (!this.typeIsValid(attributeType)) {
            checker.handleError(DescriptorException.attributeAndMappingWithTransparentIndirectionMismatch(this.getMapping(), attributeType, this.validTypeName()));
        }
    }

    public void validateGetMethodReturnType(Class returnType, IntegrityChecker checker) throws DescriptorException {
        super.validateGetMethodReturnType(returnType, checker);
        if (!this.typeIsValid(returnType)) {
            checker.handleError(DescriptorException.returnAndMappingWithTransparentIndirectionMismatch(this.getMapping(), returnType, this.validTypeName()));
        }
    }

    public void validateSetMethodParameterType(Class parameterType, IntegrityChecker checker) throws DescriptorException {
        super.validateSetMethodParameterType(parameterType, checker);
        if (!this.typeIsValid(parameterType)) {
            checker.handleError(DescriptorException.parameterAndMappingWithTransparentIndirectionMismatch(this.getMapping(), parameterType, this.validTypeName()));
        }
    }

    protected String validTypeName() {
        return Helper.getShortClassName(this.getContainerClass());
    }

    public Object valueFromBatchQuery(ReadQuery batchQuery, AbstractRecord row, ObjectLevelReadQuery originalQuery) {
        return this.buildIndirectContainer(new BatchValueHolder(batchQuery, row, this.getForeignReferenceMapping(), originalQuery));
    }

    public Object valueFromMethod(Object object, AbstractRecord row, AbstractSession session) {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public Object valueFromQuery(ReadQuery query, AbstractRecord row, AbstractSession session) {
        return this.buildIndirectContainer(new QueryBasedValueHolder(query, row, session));
    }

    public Object valueFromQuery(ReadQuery query, AbstractRecord row, Object object, AbstractSession session) {
        return this.valueFromQuery(query, row, session);
    }

    public Object valueFromRow(Object object) {
        return object;
    }
}

