/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class SerializePathTask
extends Task {
    private Vector<Path> paths = new Vector();
    private File filename;
    private String reference;

    public void add(Path path) {
        this.paths.add(path);
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setFile(File filename) {
        this.filename = filename;
    }

    public void execute() {
        if (this.filename == null) {
            throw new BuildException("'file' attribute must be defined");
        }
        if (this.filename != null && this.reference == null) {
            this.log("Dumping paths into file " + this.filename);
            try {
                OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), "UTF8");
                for (Path path : this.paths) {
                    String[] plist = path.list();
                    for (int i = 0; i < plist.length; ++i) {
                        os.write(plist[i] + "\n");
                    }
                }
                os.close();
            }
            catch (Exception exc) {
                throw new BuildException((Throwable)exc);
            }
        } else if (this.filename != null && this.reference != null) {
            this.log("Converting " + this.filename + " content into path.");
            try {
                Path path = new Path(this.getProject());
                BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), "UTF-8"));
                String line = null;
                while ((line = is.readLine()) != null) {
                    path.createPathElement().setPath(line);
                }
                this.log("Creating reference " + this.reference + ".");
                this.getProject().addReference(this.reference, (Object)path);
            }
            catch (Exception exc) {
                throw new BuildException((Throwable)exc);
            }
        } else {
            new BuildException("The task is not configured properly.");
        }
    }
}

