/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.listener.internaldata;

import com.nokia.ant.listener.internaldata.AssertNode;
import com.nokia.ant.listener.internaldata.BuildNode;
import com.nokia.ant.listener.internaldata.DataNode;
import com.nokia.ant.listener.internaldata.TargetNode;
import com.nokia.ant.listener.internaldata.TaskNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XMLRenderer {
    private Hashtable<String, String> properties;
    private BuildNode root;
    private BuildEvent buildEvent;
    private Document database;
    private Vector<String> targetList = new Vector();
    private Vector<String> taskList = new Vector();
    private Vector<String> assertList = new Vector();

    public XMLRenderer(BuildNode root, Document database, Hashtable<String, String> properties, BuildEvent event) {
        this.root = root;
        this.database = database;
        this.properties = properties;
        this.buildEvent = event;
    }

    protected void createTarget(DataNode node, Element targets) {
        TargetNode targetNode;
        if (node instanceof TargetNode && !this.targetList.contains((targetNode = (TargetNode)node).getName() + targetNode.getFilename())) {
            this.targetList.add(targetNode.getName() + targetNode.getFilename());
            Element target = targets.addElement("target");
            target.addAttribute("id", "target@" + this.targetList.indexOf(targetNode.getName() + targetNode.getFilename()));
            target.addAttribute("name", targetNode.getName());
            target.addAttribute("file", targetNode.getFilename());
            target.addAttribute("line", "" + targetNode.getLine());
        }
        Iterator<DataNode> i = node.iterator();
        while (i.hasNext()) {
            this.createTarget(i.next(), targets);
        }
    }

    protected void createTargets(Element statistics) {
        Element targets = statistics.addElement("targets");
        if (this.root != null) {
            this.createTarget(this.root, targets);
        }
    }

    protected void createTask(DataNode node, Element targets) {
        TaskNode taskNode;
        if (node instanceof TaskNode && !this.taskList.contains((taskNode = (TaskNode)node).getName())) {
            this.taskList.add(taskNode.getName());
            Element target = targets.addElement("task");
            target.addAttribute("id", "task@" + this.taskList.indexOf(taskNode.getName()));
            target.addAttribute("name", taskNode.getName());
        }
        Iterator<DataNode> i = node.iterator();
        while (i.hasNext()) {
            this.createTask(i.next(), targets);
        }
    }

    protected void createTasks(Element statistics) {
        Element tasks = statistics.addElement("tasks");
        if (this.root != null) {
            this.createTask(this.root, tasks);
        }
    }

    protected void createAsserts(Element statistics) {
        Element asserts = statistics.addElement("asserts");
        if (this.root != null) {
            this.createAssert(this.root, asserts);
        }
    }

    protected void createAssert(DataNode node, Element targets) {
        AssertNode assertNode;
        if (node instanceof AssertNode && (assertNode = (AssertNode)node).getAssertName() != null) {
            this.assertList.add(assertNode.getAssertName());
            Element target = targets.addElement("assert");
            target.addAttribute("id", "assert@" + this.assertList.indexOf(assertNode.getAssertName()));
            target.addAttribute("name", assertNode.getAssertName());
            target.addAttribute("file", assertNode.getFilename());
            target.addAttribute("line", "" + assertNode.getLine());
            target.addAttribute("message", "" + assertNode.getMessage());
        }
        Iterator<DataNode> i = node.iterator();
        while (i.hasNext()) {
            this.createAssert(i.next(), targets);
        }
    }

    protected void createTree(DataNode node, Element tree) {
        AssertNode assertNode;
        Element elt = null;
        if (node instanceof BuildNode) {
            BuildNode buildNode = (BuildNode)node;
            elt = tree.addElement("build");
            elt.addAttribute("name", buildNode.getName());
            elt.addAttribute("startTime", "" + buildNode.getStartTime().getTime());
            elt.addAttribute("endTime", "" + buildNode.getEndTime().getTime());
            elt.addAttribute("status", buildNode.getSuccessful() ? "successful" : "failed");
            elt.addAttribute("thread", "" + buildNode.getThreadId());
        } else if (node instanceof TargetNode) {
            TargetNode targetNode = (TargetNode)node;
            elt = tree.addElement("targetRef");
            elt.addAttribute("reference", "target@" + this.targetList.indexOf(targetNode.getName() + targetNode.getFilename()));
            elt.addAttribute("startTime", "" + targetNode.getStartTime().getTime());
            elt.addAttribute("endTime", "" + targetNode.getEndTime().getTime());
            elt.addAttribute("thread", "" + targetNode.getThreadId());
            elt.addAttribute("startUsedHeap", "" + targetNode.getStartUsedHeap());
            elt.addAttribute("startCommittedHeap", "" + targetNode.getStartCommittedHeap());
            elt.addAttribute("endUsedHeap", "" + targetNode.getEndUsedHeap());
            elt.addAttribute("endCommittedHeap", "" + targetNode.getEndCommittedHeap());
        } else if (node instanceof TaskNode) {
            TaskNode taskNode = (TaskNode)node;
            elt = tree.addElement("taskRef");
            elt.addAttribute("reference", "task@" + this.taskList.indexOf(taskNode.getName()));
            elt.addAttribute("startTime", "" + taskNode.getStartTime().getTime());
            elt.addAttribute("endTime", "" + taskNode.getEndTime().getTime());
            elt.addAttribute("thread", "" + taskNode.getThreadId());
        } else if (node instanceof AssertNode && (assertNode = (AssertNode)node).getAssertName() != null) {
            elt = tree.addElement("assertRef");
            elt.addAttribute("reference", "assert@" + this.assertList.indexOf(assertNode.getAssertName()));
            elt.addAttribute("startTime", "" + assertNode.getStartTime().getTime());
            elt.addAttribute("endTime", "" + assertNode.getEndTime().getTime());
            elt.addAttribute("thread", "" + assertNode.getThreadId());
        }
        if (elt != null) {
            Iterator<DataNode> i = node.iterator();
            while (i.hasNext()) {
                this.createTree(i.next(), elt);
            }
        }
    }

    protected void createExecutionTree(Element statistics) {
        Element executionTree = statistics.addElement("executionTree");
        if (this.root != null) {
            this.createTree(this.root, executionTree);
        }
    }

    protected void createProperties(Element statistics) {
        Element propertiesElt = statistics.addElement("properties");
        if (this.properties != null) {
            Enumeration<String> e = this.properties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Element propertyElt = propertiesElt.addElement("property");
                propertyElt.addAttribute("name", key);
                propertyElt.addAttribute("value", this.properties.get(key));
            }
        }
    }

    protected void insertDatabase(Element statistics) {
        if (this.database != null) {
            Element databaseElt = statistics.addElement("database");
            databaseElt.add(this.database.getRootElement().detach());
        }
    }

    public String toString() {
        Document document = DocumentHelper.createDocument();
        Element statistics = document.addElement("statistics");
        statistics.addAttribute("version", "1.0");
        this.insertDatabase(statistics);
        this.createTargets(statistics);
        this.createTasks(statistics);
        this.createAsserts(statistics);
        this.createExecutionTree(statistics);
        this.createProperties(statistics);
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            XMLWriter out = new XMLWriter((OutputStream)output, OutputFormat.createPrettyPrint());
            out.write(document);
            return output.toString();
        }
        catch (Exception exc) {
            return document.asXML();
        }
    }
}

