/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;

public class DeconfigureTask
extends Task {
    private String database;
    private String projectName;
    private String password;
    private Boolean considerBranchReleases;
    private Integer verbosity;

    public void setdatabase(String database) {
        this.database = database;
        this.log("Set database to " + database, 4);
    }

    public void setprojectName(String projectName) {
        this.projectName = projectName;
        this.log("Set projectName to " + projectName, 4);
    }

    public void setpassword(String password) {
        this.password = password;
        this.log("Set password to " + password, 4);
    }

    public void setconsiderBranchReleases(Boolean considerBranchReleases) {
        this.considerBranchReleases = considerBranchReleases;
        this.log("Set considerBranchReleases to " + considerBranchReleases, 4);
    }

    public void setverbosity(Integer verbosity) {
        this.verbosity = verbosity;
        this.log("Set verbosity to " + verbosity, 4);
    }

    public void execute() {
        String missingArgs = "";
        String commandArgs = "cmd /c deconfigure.pl ";
        if (this.database == null) {
            missingArgs = missingArgs + "database ";
        } else {
            commandArgs = commandArgs + "-d " + this.database + " ";
        }
        if (this.projectName == null) {
            missingArgs = missingArgs + "projectName ";
        } else {
            commandArgs = commandArgs + "-p " + this.projectName + " ";
        }
        if (this.password == null) {
            missingArgs = missingArgs + "password ";
        } else {
            commandArgs = commandArgs + "-P " + this.password + " ";
        }
        if (!missingArgs.equals("")) {
            throw new BuildException("[" + this.getTaskName() + "] Error: mandatory attributes are not defined - " + missingArgs);
        }
        if (this.considerBranchReleases != null && this.considerBranchReleases.booleanValue()) {
            commandArgs = commandArgs + "-b ";
        }
        if (this.verbosity != null) {
            switch (this.verbosity) {
                case 0: {
                    commandArgs = commandArgs + "-q ";
                    break;
                }
                case 1: {
                    commandArgs = commandArgs + "-V ";
                    break;
                }
                case 2: {
                    commandArgs = commandArgs + "-W ";
                    break;
                }
                default: {
                    throw new BuildException("[" + this.getTaskName() + "] Error: Verbosity level is not recognised. Legal values are: 0 - quiet, 1 - verbose or 2 - very verbose");
                }
            }
        }
        try {
            Execute exe = new Execute();
            Execute.runCommand((Task)this, (String[])commandArgs.split(" "));
        }
        catch (BuildException e) {
            throw new BuildException("[" + this.getTaskName() + "] Error: Script execution failure.");
        }
        this.log("Completed successfully.");
    }
}

