/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import fmpp.util.BugException;
import java.io.IOException;
import java.io.Reader;

public class BorderedReader
extends Reader {
    private static final int PHASE_HEADER = 0;
    private static final int PHASE_BODY = 1;
    private static final int PHASE_FOOTER = 2;
    private String header;
    private int headerLength;
    private Reader body;
    private String footer;
    private int footerLength;
    private int phase = 0;
    private int index = 0;

    public BorderedReader(String header, Reader body, String footer) {
        this.header = header;
        this.headerLength = header == null ? 0 : header.length();
        this.footer = footer;
        this.footerLength = footer == null ? 0 : footer.length();
        this.body = body;
    }

    public void close() throws IOException {
        this.body.close();
    }

    public int read() throws IOException {
        switch (this.phase) {
            case 0: {
                if (this.index < this.headerLength) {
                    return this.header.charAt(this.index++);
                }
                this.phase = 1;
            }
            case 1: {
                int i = this.body.read();
                if (i != -1) {
                    return i;
                }
                this.phase = 2;
                this.index = 0;
            }
            case 2: {
                if (this.index < this.footerLength) {
                    return this.footer.charAt(this.index++);
                }
                return -1;
            }
        }
        throw new BugException("Illegal phase: " + this.phase);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int total = 0;
        switch (this.phase) {
            case 0: {
                int i;
                int clen = this.headerLength - this.index;
                if (clen > 0) {
                    clen = clen > len ? len : clen;
                    for (i = 0; i < clen; ++i) {
                        cbuf[off++] = this.header.charAt(this.index++);
                    }
                    len -= clen;
                    total = clen;
                }
                if (len == 0) break;
                this.phase = 1;
            }
            case 1: {
                int i = this.body.read(cbuf, off, len);
                if (i != -1) {
                    total += i;
                    break;
                }
                this.phase = 2;
                this.index = 0;
            }
            case 2: {
                int i;
                int clen = this.footerLength - this.index;
                if (clen > 0) {
                    clen = clen > len ? len : clen;
                    for (i = 0; i < clen; ++i) {
                        cbuf[off++] = this.footer.charAt(this.index++);
                    }
                    total += clen;
                    break;
                }
                if (total != 0) break;
                total = -1;
                break;
            }
            default: {
                throw new BugException("Illegal phase: " + this.phase);
            }
        }
        return total;
    }

    public long skip(long n) throws IOException {
        long total = 0L;
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        switch (this.phase) {
            case 0: {
                long clen = this.headerLength - this.index;
                total = clen = clen > n ? n : clen;
                this.index = (int)((long)this.index + clen);
                if (n == total) break;
                this.phase = 1;
            }
            case 1: {
                long i;
                while ((i = this.body.skip(n - total)) != 0L && n > (total += i)) {
                }
                if (n == total) break;
                this.phase = 2;
                this.index = 0;
            }
            case 2: {
                long clen = this.footerLength - this.index;
                clen = clen > n - total ? n - total : clen;
                this.index = (int)((long)this.index + clen);
                total += clen;
            }
        }
        return total;
    }
}

