/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.signal;

import com.nokia.helium.signal.SignalStatus;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class SignalStatusList {
    private static SignalStatusList deferSignalList = new SignalStatusList();
    private static SignalStatusList nowSignalList = new SignalStatusList();
    private static SignalStatusList neverSignalList = new SignalStatusList();
    private Vector<SignalStatus> signals = new Vector();
    private Logger log = Logger.getLogger(this.getClass());

    private SignalStatusList() {
    }

    public Vector<SignalStatus> getSignalStatusList() {
        return new Vector<SignalStatus>(this.signals);
    }

    public void addSignalStatus(SignalStatus status) {
        this.log.debug((Object)("SignalStatusList:addSignalStatus:msg:" + status));
        this.signals.add(status);
    }

    public String getErrorMsg() {
        StringBuffer statusBuffer = new StringBuffer();
        for (SignalStatus signalStatus : this.signals) {
            statusBuffer.append(signalStatus);
            statusBuffer.append("\n");
        }
        this.log.debug((Object)("SignalStatusList:getErrorMsg:msg:" + statusBuffer.toString()));
        return statusBuffer.toString();
    }

    public boolean hasSignalInList() {
        this.log.debug((Object)("SignalStatusList:hasDeferMsgInList:size:" + this.signals.size()));
        return this.signals.size() > 0;
    }

    public void clearStatusList() {
        this.log.debug((Object)("SignalStatusList:clearStatusList:size1:" + this.signals.size()));
        this.signals.clear();
        this.log.debug((Object)("SignalStatusList:clearStatusList:size2:" + this.signals.size()));
    }

    public static SignalStatusList getDeferredSignalList() {
        return deferSignalList;
    }

    public static SignalStatusList getNowSignalList() {
        return nowSignalList;
    }

    public static SignalStatusList getNeverSignalList() {
        return neverSignalList;
    }
}

