/* Standard Library
 * Copyright  2005 Nokia Corporation.  All rights reserved.
 *
 * $Date: 2005/02/25 13:56:45 $
 * $Revision: 1.1.4.1 $
 */

#ifndef _MSL_TCHAR_H
#define _MSL_TCHAR_H

#ifdef UNICODE

#define _tcscmp wcscmp
#define _tcscspn wcscspn
#define _tcslen wcslen
#define _tcsncmp wcsncmp
#define _tcsspn wcsspn
#define _tcschr wcschr
#define _tcscoll wcscoll
#define _tcspbrk wcspbrk
#define _tcsstr wcsstr
#define _tcscat wcscat
#define _tcscpy wcscpy
#define _tcsncat wcsncat
#define _tcsncpy wcsncpy
#define _tcstok wcstok
#define _tcsxfrm wcsxfrm
#define _tcstod wcstod
#define _tcstof wcstof
#define _tcstol wcstol
#define _tcstold wcstold
#define _tcstoll wcstoll
#define _tcstoul wcstoul
#define _tcstoull wcstoull
#define _tcsftime wcsftime
#define _vtprintf vwprintf
#define _vftprintf vfwprintf
#define _vsntprintf vswprintf
#define _tprintf wprintf
#define _ftprintf fwprintf
#define _sntprintf swprintf
#define _ftscanf fwscanf
#define _stscanf swscanf
#define _tscanf wscanf
#define _gettchar getwchar
#define _puttchar putwchar
#define _fgettc fgetwc
#define _fgetts fgetws
#define _fputtc fputwc
#define _fputts fputws
#define _gettc getwc
#define _puttc putwc
#define _ungettc ungetwc
#define _istalnum iswalnum
#define _istalpha iswalpha
#define _istcntrl iswcntrl
#define _istdigit iswdigit
#define _istgraph iswgraph
#define _istlower iswlower
#define _istprint iswprint
#define _istpunct iswpunct
#define _istspace iswspace
#define _istupper iswupper
#define _istxdigit iswxdigit
#define _totlower towlower
#define _totupper towupper
#define _itot _itow
#define _ttoi _wtoi
#define _tcsicmp _wcsicmp
#define _tcsnicmp _wcsnicmp
#define _tcsrev _wcsrev
#define _tcsupr _wcsupr
#define _tcslwr _wcslwr
#define _tcsset _wcsset
#define _tcsnset _wcsnset
#define _tcsspnp _wcsspnp
#define _tcsdup _wcsdup
#define _tcsicoll _wcsicoll
#define _tcsnicoll _wcsnicoll
#define _tcsncoll _wcsncoll
#define _ltot _ltow
#define _ultot _ultoa
#define _texecl _wexecl /* not implemented! */
#define _texecle _wexecle /* not implemented! */
#define _texeclp _wexeclp /* not implemented! */
#define _texeclpe _wexeclpe /* not implemented! */
#define _texecv _wexecv /* not implemented! */
#define _texecve _wexecve /* not implemented! */
#define _texecvp _wexecvp /* not implemented! */
#define _texecvpe _wexecvpe /* not implemented! */
#define _tspawnl _wspawnl /* not implemented! */
#define _tspawnle _wspawnle /* not implemented! */
#define _tspawnlp _wspawnlp /* not implemented! */
#define _tspawnlpe _wspawnlpe /* not implemented! */
#define _tspawnv _wspawnv /* not implemented! */
#define _tspawnve _wspawnve /* not implemented! */
#define _tspawnvp _wspawnvp /* not implemented! */
#define _tspawnvpe _wspawnvpe /* not implemented! */
#define _tsystem _wsystem
#define _tasctime _wasctime /* not implemented! */
#define _tctime _wctime /* not implemented! */
#define _tcsdate _wstrdate /* not implemented! */
#define _tcstime _wstrtime /* not implemented! */
#define _tutime _wutime /* not implemented! */
#define _tchdir _wchdir /* not implemented! */
#define _tgetcwd _wgetcwd /* not implemented! */
#define _tmkdir _wmkdir /* not implemented! */
#define _trmdir _wrmdir /* not implemented! */
#define _tfullpath _wfullpath /* not implemented! */
#define _tgetenv _wgetenv
#define _tmakepath _wmakepath /* not implemented! */
#define _tputenv _wputenv /* not implemented! */
#define _tsearchenv _wsearchenv /* not implemented! */
#define _tsplitpath _wsplitpath /* not implemented! */
#define _tfdopen _wfdopen /* not implemented! */
#define _tfsopen _wfsopen /* not implemented! */
#define _tfopen _wfopen
#define _tfreopen _wfreopen
#define _tperror _wperror /* not implemented! */
#define _tpopen _wpopen /* not implemented! */
#define _ttempnam _wtempnam /* not implemented! */
#define _ttmpnam _wtmpnam
#define _taccess _waccess /* not implemented! */
#define _tchmod _wchmod /* not implemented! */
#define _tcreat _wcreat
#define _tfindfirst _wfindfirst /* not implemented! */
#define _tfindfirsti64 _wfindfirsti64 /* not implemented! */
#define _tfindnext _wfindnext /* not implemented! */
#define _tfindnexti64 _wfindnexti64 /* not implemented! */
#define _tmktemp _wmktemp /* not implemented! */
#define _topen _wopen
#define _tremove _wremove
#define _trename _wrename
#define _tsopen _wsopen /* not implemented! */
#define _tunlink _wunlink /* not implemented! */
#define _tfinddata _wfinddata_t /* not implemented! */
#define _tfinddatai64 _wfinddatai64_t /* not implemented! */
#define _tstat _wstat /* not implemented! */
#define _tstati64 _wstati64 /* not implemented! */
#define _tsetlocale _wsetlocale /* not implemented! */
#define _tmain wmain
#define _tWinMain wWinMain
#define _tenviron _wenviron
#define __targv __wargv

#else /* !UNICODE */

#define _tcscmp strcmp
#define _tcscspn strcspn
#define _tcslen strlen
#define _tcsncmp strncmp
#define _tcsspn strspn
#define _tcschr strchr
#define _tcscoll strcoll
#define _tcspbrk strpbrk
#define _tcsstr strstr
#define _tcscat strcat
#define _tcscpy strcpy
#define _tcsncat strncat
#define _tcsncpy strncpy
#define _tcstok strtok
#define _tcsxfrm strxfrm
#define _tcstod strtod
#define _tcstof strtof
#define _tcstol strtol
#define _tcstold strtold
#define _tcstoll strtoll
#define _tcstoul strtoul
#define _tcstoull strtoull
#define _tcsftime strftime
#define _vtprintf vprintf
#define _vftprintf vfprintf
#define _vsntprintf vsnprintf
#define _tprintf printf
#define _ftprintf fprintf
#define _sntprintf snprintf
#define _ftscanf fscanf
#define _stscanf sscanf
#define _tscanf scanf
#define _gettchar getchar
#define _puttchar putchar
#define _fgettc fgetc
#define _fgetts fgets
#define _fputtc fputc
#define _fputts fputs
#define _gettc getc
#define _puttc putc
#define _ungettc ungetc
#define _istalnum isalnum
#define _istalpha isalpha
#define _istcntrl iscntrl
#define _istdigit isdigit
#define _istgraph isgraph
#define _istlower islower
#define _istprint isprint
#define _istpunct ispunct
#define _istspace isspace
#define _istupper isupper
#define _istxdigit isxdigit
#define _totlower tolower
#define _totupper toupper
#define _itot itoa
#define _ttoi atoi
#define _tcsicmp _stricmp
#define _tcsnicmp _strnicmp
#define _tcsrev _strrev
#define _tcsupr _strupr
#define _tcslwr _strlwr
#define _tcsset _strset
#define _tcsnset _strnset
#define _tcsspnp _strspnp
#define _tcsdup _strdup
#define _tcsicoll _stricoll
#define _tcsnicoll _strnicoll
#define _tcsncoll _strncoll
#define _ltot _ltoa
#define _ultot _ultow
#define _texecl _execl
#define _texecle _execle
#define _texeclp _execlp
#define _texeclpe _execlpe
#define _texecv _execv
#define _texecve _execve
#define _texecvp _execvp
#define _texecvpe _execvpe
#define _tspawnl _spawnl
#define _tspawnle _spawnle
#define _tspawnlp _spawnlp
#define _tspawnlpe _spawnlpe
#define _tspawnv _spawnv
#define _tspawnve _spawnve
#define _tspawnvp _spawnvp
#define _tspawnvpe _spawnvpe
#define _tsystem system
#define _tasctime asctime
#define _tctime ctime
#define _tcsdate strdate
#define _tcstime strtime
#define _tutime utime
#define _tchdir chdir
#define _tgetcwd getcwd
#define _tmkdir mkdir
#define _trmdir rmdir
#define _tfullpath _fullpath
#define _tgetenv getenv
#define _tmakepath makepath
#define _tputenv putenv
#define _tsearchenv _searchenv
#define _tsplitpath splitpath
#define _tfdopen fdopen
#define _tfsopen fsopen /* not implemented! */
#define _tfopen fopen
#define _tfreopen freopen
#define _tperror perror
#define _tpopen popen /* not implemented! */
#define _ttempnam tempnam /* not implemented! */
#define _ttmpnam tmpnam
#define _taccess access
#define _tchmod chmod
#define _tcreat creat
#define _tfindfirst _findfirst
#define _tfindfirsti64 findfirsti64 /* not implemented! */
#define _tfindnext _findnext
#define _tfindnexti64 findnexti64 /* not implemented! */
#define _tmktemp mktemp /* not implemented! */
#define _topen open
#define _tremove remove
#define _trename rename
#define _tsopen sopen /* not implemented! */
#define _tunlink unlink
#define _tfinddata finddata_t
#define _tfinddatai64 finddatai64_t /* not implemented! */
#define _tstat stat
#define _tstati64 stati64 /* not implemented! */
#define _tsetlocale setlocale
#define _tmain main
#define _tWinMain WinMain
#define _tenviron _environ
#define __targv __argv

#endif /* UNICODE */


#ifdef UNICODE

#include <wchar.h>

_MSL_BEGIN_EXTERN_C

#ifndef _WCTYPE_T_DEFINED
typedef wchar_t wint_t;
typedef wchar_t wctype_t;
#define _WCTYPE_T_DEFINED
#endif

#ifndef __TCHAR_DEFINED
	typedef wchar_t     _TCHAR;
	typedef wchar_t     _TSCHAR;
	typedef wchar_t     _TUCHAR;
	typedef wchar_t     _TXCHAR;
	typedef wint_t      _TINT;
	#define __TCHAR_DEFINED
#endif

#ifndef _TCHAR_DEFINED
	#if     !__STDC__
		typedef wchar_t     TCHAR;
		#define _TCHAR_DEFINED
	#endif
#endif

_MSL_END_EXTERN_C


#define __T(x)      L ## x
#define _TEOF       WEOF

#else	/* !UNICODE */

#include <string.h>

_MSL_BEGIN_EXTERN_C

#ifndef __TCHAR_DEFINED
	typedef char            _TCHAR;
	typedef signed char     _TSCHAR;
	typedef unsigned char   _TUCHAR;
	typedef unsigned char   _TXCHAR;
	typedef unsigned int    _TINT;
	#define __TCHAR_DEFINED
#endif

#ifndef _TCHAR_DEFINED
	#if     !__STDC__
		typedef char            TCHAR;
		#define _TCHAR_DEFINED
	#endif
#endif

_MSL_END_EXTERN_C

#define __T(x)		x
#define _TEOF       EOF

#endif	/* UNICODE */

/* common macros */

#define _T(x)       __T(x)
#define _TEXT(x)    __T(x)


#endif /* _MSL_TCHAR_H */

/* EJS 050225 created to replace proprietary header
 */
 