/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2005/11/23 03:07:54 $
 * $Revision: 1.33.2.1 $
 */

#ifndef _MSL_THREADLOCALDATA_H
#define _MSL_THREADLOCALDATA_H

#include <ansi_parms.h>

#if (__dest_os	== __win32_os )
#include <cstdlib>
#include <cstdio>
#include <ctime>
#include <clocale>
#include <locale_api.h>	/*- mm 010615 -*/

#pragma options align=native

_MSL_BEGIN_EXTERN_C

	typedef struct _ThreadLocalData 
	{
		struct 					_ThreadLocalData *next;
		int 					_errno;
		unsigned long int 		random_next;
		unsigned char *			strtok_n;
		unsigned char *			strtok_s;
		void * /* HANDLE */		thread_handle;
		struct __std(tm) 		gmtime_tm; 							/*- hh 990124 -*/
		struct __std(tm)    	localtime_tm;						/*- mm 010516 -*/ 
		char 					asctime_result[26];
		char					temp_name[L_tmpnam];
		struct __std(lconv) *	unused; /* was tls_lconv */			/*- mm 010503 -*/
		char *					locale_name; 						/*- mm 010503 -*/
		struct __locale         _current_locale;					/*- mm 011130 -*/	/*- mm 011205 -*/
		void /* _se_translator_function */ (__cdecl *user_se_translator)();	/*- ejs 010625 -*/
		struct __std(lconv)		__lconv;
#if _MSL_WFILEIO_AVAILABLE
		wchar_t					wtemp_name[L_tmpnam];
#endif
		/* The heap object this TLD was allocated from */
		void * /* HANDLE */		heap_handle;						/*- sl 051103 -*/
	} _ThreadLocalData;
	
	_MSL_IMP_EXP_C int _MSL_CDECL  _InitializeThreadDataIndex(void) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C int _MSL_CDECL  _InitializeThreadData(void *threadHandle) _MSL_CANT_THROW; /* really HANDLE */
	_MSL_IMP_EXP_C void _MSL_CDECL _DisposeThreadData(void) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C void _MSL_CDECL _DisposeAllThreadData(void) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C int _MSL_CDECL  _InitializeMainThreadData(void) _MSL_CANT_THROW;
	_MSL_IMP_EXP_C _ThreadLocalData * _MSL_CDECL _GetThreadLocalData(int) _MSL_CANT_THROW;		/*- cc 010531 -*/
	_MSL_IMP_EXP_C void _MSL_CDECL _DisposeThreadDataIndex(void) _MSL_CANT_THROW;

_MSL_END_EXTERN_C

#pragma options align=reset

#endif /* __dest_os == __win32_os */
#endif /* _MSL_THREADLOCALDATA_H */

/* Change record:
 * hh  971206 Added namespace support
 * hh  990124 fixed __std
 * blc 990317 Added thread_handle to allow for beginthread/endthread support
 * blc 000308 Fixed prototypes to have function arguments
 * cc  000316 added _MSL_IMP_EXP_C
 * cc  010410 updated to new namespace macros
 * mm  010503 New fields for _ThreadLocalData
 * mm  010516 New field for localtime_tm
 * cc  010531 Added _GetThreadLocalData's flag
 * mm  010615 Changes to solve namespace problem for C++
 * JWW 010618 Use cname headers exclusively to prevent namespace pollution in C++
 * ejs 010625 Added user_se_translator for structured exception handling
 * mm  011130 Addec locale 
 * cc  011203 Added _MSL_CDECL for new name mangling
 * mm  011205 Changed _LOCALE to __locale 
 * hh  020603 Added no throw spec to functions
 * JWW 020604 Keep a complete copy of __lconv in the thread local data
 * JWW 021010 Added wchar_t file I/O routines controlled by _MSL_WFILEIO_AVAILABLE
 */