/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:11 $
 * $Revision: 1.24 $
 */
 
/*******************************************************************************/
/*  Project...: C++ and ANSI-C Compiler Environment                     ********/
/*  Purpose...: Interface functions to SIOUX for Windows			    ********/
/*******************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <commdlg.h>
#include <stdio.h>
#include <stdlib.h>
#include <WinSIOUX.h>
#include <setjmp.h>
#include <signal.h>
#include <process.h>                /*- mm 010111 -*/
#include <crtl.h>					/*- mm 980504 -*/ 
#include <math.h>

#define WM_LINEOUT   WM_USER
#define SB_SCROLLTO  WM_USER + 1
#define WM_CLRSCR    WM_USER + 2    /*- mm 980727 -*/ 
#define BOTTOMGAP       5
#define CARET_WIDTH     2
#define LEFT_MARGIN     5
#define SCROLLBARWIDTH 10
#define INITIALX      500			/* initial x size of window*/  	/*- mm 001205 -*/
#define INITIALY      300			/* initial y size of window*/	/*- mm 001205 -*/


			/* Function Prototypes */
static LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM); 		/*- mm 990416 -*/
static void  InitOpenFileNameStruct(HWND);							/*- mm 990416 -*/
static BOOL  ShowFileSaveDialog(HWND, PSTR, PSTR);					/*- mm 990416 -*/
static BOOL  WriteBufferToFile(PSTR);								/*- mm 990416 -*/
static short DoYouWantToSave(HWND, char *);							/*- mm 990416 -*/
static int   MessageLoop();											/*- mm 990416 -*/
static void  DisplayChar(HDC, char, int*, int*, int*, int*, int, int);	/*- mm 990526 -*/ /*- mm 991209 -*/ 
static void  ReplantCaret(int, int, int, int, int);					/*- mm 990416 -*/
static int   CheckBufOverflow(int);									/*- mm 990416 -*/
static void  StoreChar(char*, char*);								/*- mm 990416 -*/
static int   GetLengthOfTextLine(char*);							/*- mm 990416 -*/
static void  TextPtrToRowCol(char*, int*, int*);					/*- mm 990416 -*/
static char* RowColToTextPtr(int, int);								/*- mm 990416 -*/
static void  DeleteCharsFromBuffer(char*, int);						/*- mm 990416 -*/
static void  InsertCharsIntoBuffer(char*, int);						/*- mm 990416 -*/
static void  DfltIntHandler(int sig);								/*- mm 990416 -*/
static int   FindNumLines();										/*- mm 990416 -*/
static HFONT GetFont(HDC, int, int*, int*);							/*- mm 990416 -*/
static void  SizeWindow();											/*- mm 001205 -*/
static	MSG 		msg;											/*- mm 010111 -*/
static HANDLE ThreadHandle;											/*- mm 010111 -*/
static void  TerminateWinSIOUX();									/*- mm 020411 -*/

tSIOUXSettings	SIOUXSettings =				/*	User customizable SIOUX settings ...*/
			{											/* begin mm 010305 */
			 TRUE, 		/* Initialize the ToolBox? 								*/              
			 TRUE, 		/* WinSIOUX running in standalone mode?					*/
			 TRUE, 		/* Draw the WinSIOUX menus?								*/
			 FALSE, 	/* Close WinSIOUX window on program termination?		*/
			 TRUE, 		/* Offer to save on a close? 							*/
			 FALSE, 	/* Draw the status line?								*/
			 4, 		/* Replace tabs with 'tabspaces' spaces					*/
			 80, 		/* Initial number of columns in window					*/
			 24, 		/* Initial number of rows in window 					*/
			 0, 		/* Pixel posn of window on main screen					*/
			 0, 		/* The topleft window position (in pixels)				*/
			 "Courier", /* Fontname												*/
			 10, 		/* Pointsize of font									*/							
			 0			/* Normal fontface										*/
			};											/* end mm 010305 */

static tSIOUXBuffer SIOUXBuffer;

#define SIOUX_BUFSIZ      32768U	/*	SIOUX's internal buffer size ...*/
#define SIOUX_INPUTBUFSIZ   512U	/*  SIOUX's input buffer size       */

static HWND 	WindowHandle;
static HACCEL	AcceleratorHandle;
static char AppName[] = "WinSIOUX";
static OPENFILENAME OpenFileName;
static HINSTANCE ProgramInstance;
static BOOL atEOF = FALSE;				/*	Is the stream at EOF? */
static jmp_buf JumpBuf;
static jmp_buf TJumpBuf;				/*- mm 010111 -*/
static int CharsInLine = 0;				/*- mm 980522 -*/
static int WinSIOUX_Terminating = 0;	/*- mm 001205 -*/
static int WinSIOUX_Aborting    = 0;	/*- mm 990519 -*/
static int WinSIOUX_Terminated  = 0;	/*- mm 020411 -*/
static int CharWidth,          /* Average character width     */  /*- mm 001205 -*/
	       CharHeight;         /* Total height of characters  */  /*- mm 001205 -*/

RECT ClientRect = {0, 0, 0, 0};			/*- mm 001205 -*/
int   ResizeFlag = 0;					/*- mm 001205 -*/

          /* Function in WinSIOUXprnt.c  */
BOOL WinSIOUXprint(HINSTANCE, HWND, PSTR, tSIOUXBuffer);

int	  main(int argc, char **argv);  /* This is the user's main entry point   mm 980504 */


static void localmain(void*);			 	/*- mm 010111 -*/
static void localmain(void*)				/*- mm 010111 -*/
{									/*- mm 010111 -*/
	main(__argc, __argv);			/*- mm 010111 -*/
	/* When we arrive here, the user's application has terminated.  We must */
	/* flush the stdout and stderr buffers in case the user has left        */
	/* something that has yet to be displayed; e.g. no \n at end            */
	WinSIOUX_Terminating = TRUE;				/*- mm 990125 -*/
	fflush(stdout);								/*- mm 980304 -*/
	fflush(stderr);								/*- mm 980304 -*/

	if (!WinSIOUX_Terminated)					/*- mm 020411 -*/
		TerminateWinSIOUX();					/*- mm 020411 -*/
	_endthread();
	
}									/*- mm 010111 -*/


int WINAPI WinMain (HINSTANCE thisInstance, HINSTANCE prevInstance,
                    PSTR szCmdLine, int CmdShow)
{
#pragma unused(prevInstance)				/*- mm 990609 -*/
#pragma unused(szCmdLine)					/*- mm 990609 -*/
	WNDCLASSEX 	windowClass;                          	   /* Window class        */
	HICON 		progIcon = LoadIcon(NULL, IDI_APPLICATION);/* generic icon        */
	HCURSOR 	arrowCursor = LoadCursor(NULL, IDC_ARROW); /* Stock cursor        */
	HBRUSH 		bkBrush = (HBRUSH)(COLOR_WINDOW + 1);      /* Brush for background*/
	
	int         SetJmpResult;
	
	ProgramInstance = thisInstance;
	windowClass.cbSize        = sizeof(windowClass);/* Number of bytes in structure  */
	windowClass.style         = CS_HREDRAW | CS_VREDRAW;/* Redraw on size change     */
	windowClass.lpfnWndProc   = WndProc;        /* Use default window procedure   */
	windowClass.cbClsExtra    = 0;              /* No extra class data            */
	windowClass.cbWndExtra    = 0;              /* No extra window data           */
	windowClass.hInstance     = thisInstance;   /* Current instance is the owner  */
	windowClass.hIcon         = progIcon;       /* Set icon                       */
	windowClass.hCursor       = arrowCursor;    /* Set cursor                     */
	windowClass.hbrBackground = bkBrush;        /* Set window background brush    */
	windowClass.lpszMenuName  = "WinSIOUX";     /* Use program name as menu name  */
	windowClass.lpszClassName = AppName;      	/* Use program name as class name */
	windowClass.hIconSm       = progIcon;       /* Set icon                       */

	RegisterClassEx(&windowClass);              /* Register the class             */
 
    WindowHandle = CreateWindow(AppName,        /* window class name              */
		                "WinSIOUX Text Window", /* window caption                 */
                        WS_OVERLAPPEDWINDOW | WS_VSCROLL,    /* window style      */
                        CW_USEDEFAULT,          /* initial x position             */
                        CW_USEDEFAULT,          /* initial y position             */
                        INITIALX,         		/* initial x size                 */	/*- mm 001205 -*/
                        INITIALY,          		/* initial y size                 */	/*- mm 001205 -*/
                        NULL,                   /* parent window handle           */
                        NULL,                   /* window menu handle             */
                        thisInstance,           /* program instance handle        */
		                NULL);		            /* creation parameters            */

	if ((SIOUXBuffer.startpos = (char *)malloc(SIOUX_BUFSIZ)) == NULL)
		return -1;
	if ((SIOUXBuffer.inputstart = (char *)malloc(SIOUX_INPUTBUFSIZ)) == NULL)
		return -1;
	SIOUXBuffer.endpos		= SIOUXBuffer.curtop = SIOUXBuffer.startpos;
	SIOUXBuffer.inputlast	= SIOUXBuffer.inputcur = SIOUXBuffer.inputstart;
	SIOUXBuffer.SelStartPtr = NULL;
	SIOUXBuffer.SelEndPtr   = NULL;	
	SIOUXBuffer.WindowHeight= 0;				
	SIOUXBuffer.WindowWidth	= 0;
	SIOUXBuffer.row			= 0;				
	SIOUXBuffer.col			= 0;
	SIOUXBuffer.maxrow		= 30;				
	SIOUXBuffer.maxcol		= 80;
	SIOUXBuffer.VscrollPos  = 0, 	/*- Vert scroll button posn     -*/
	SIOUXBuffer.installed	= FALSE;
	SIOUXBuffer.inputavail	= FALSE;
	SIOUXBuffer.dirtybit    = FALSE;
	SIOUXBuffer.NeedInput   = FALSE;
	SIOUXBuffer.CmdShow     = CmdShow;
	SIOUXBuffer.numlines	= 0;				/*- mm 980120 -*/
	SIOUXBuffer.bufsize 	= SIOUX_BUFSIZ;

	SetJmpResult = setjmp(JumpBuf);
	if (!SetJmpResult)
	{
		signal(SIGINT, DfltIntHandler);
		ThreadHandle = (HANDLE)_beginthread(localmain, 0, NULL);	 	/*- mm 010111 -*/
		WaitForSingleObject(ThreadHandle, INFINITE);					/*- mm 010111 -*/
	}
	return((int)msg.wParam);			/*- mm 990609 -*/
}

static void DfltIntHandler(int sig)		/*- mm 990416 -*/
{
#pragma unused(sig)					/*- mm 990609 -*/
	longjmp(JumpBuf, 1);
}

static void TerminationIntHandler(int sig)		/*- mm 010111 -*/
{
#pragma unused(sig)					/*- mm 010111 -*/
	longjmp(TJumpBuf, 1);			/*- mm 010111 -*/
}

/*- Begin insert mm 020411 -*/
static void TerminateWinSIOUX()
{
	if (WinSIOUX_Aborting || SIOUXSettings.autocloseonquit)	
		SendMessage(WindowHandle, WM_CLOSE, 0, 0L);	

	if (SIOUXBuffer.installed)
		while(GetMessage(&msg, NULL, 0, 0))
		{
			if (!TranslateAccelerator(WindowHandle, AcceleratorHandle, &msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
 	    }
 	WinSIOUX_Terminated = 1;

}
/*- End insert mm 020411 -*/

void _MSL_CDECL WinSIOUXAbort()					/*- mm 981109 -*/
{										/*- mm 981109 -*/
	if (WinSIOUX_Terminating)           /*- mm 990125 -*/
	{									/*- mm 020411 -*/
		if (!WinSIOUX_Terminated)		/*- mm 020411 -*/
			TerminateWinSIOUX();		/*- mm 020411 -*/
		return;							/*- mm 990125 -*/
	}									/*- mm 020411 -*/
	else								/*- mm 990125 -*/
	{
   		WinSIOUX_Aborting    = 1;		/*- mm 020411 -*/
   		WinSIOUX_Terminating = 1;		/*- mm 020411 -*/
		longjmp(JumpBuf, 1);			/*- mm 981109 -*/
	}
}										/*- mm 981109 -*/

static int MessageLoop()				/*- mm 990416 -*/
{
	MSG msg;
	while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
	{
		if (!TranslateAccelerator(WindowHandle, AcceleratorHandle, &msg))
		{
			if (msg.message == WM_QUIT)
				return((int)msg.wParam);		/*- mm 990609 -*/
			
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
    }

	return (int)msg.wParam;			/*- mm 990609 -*/
}

static LRESULT CALLBACK WndProc (HWND WindowHandle, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	static char 		FileName[_MAX_PATH] = "";
	static char 		TitleName[_MAX_FNAME + _MAX_EXT_LEN] = "";
    static HINSTANCE	ThisInst;
	static int 			LastRowNum = 0;
	static int			Scrolling   = 0,
	            		MouseRow    = -1,
	            		MouseCol    = -1,
	            		SelStartRow = -1,
	            		SelStartCol = -1,
	            		SelEndRow   = -1,
	            		SelEndCol   = -1,
	            		CaretRow    = 0,	/* row position of caret	   */
	            		CaretCol    = 0;	/* col position of caret	   */
	HMENU       		hMenu;
	HDC         		hdc;
	PAINTSTRUCT 		ps;
	int         		j;
	char*       		mptr;
	char				msg[64 + _MAX_FNAME + _MAX_EXT_LEN];
	char        		aChar;
	
	switch (iMsg)
    {
		case WM_COMMAND:
			hMenu = GetMenu(WindowHandle);
			switch(LOWORD(wParam))
			{
				case IDM_SAVE:
					if (FileName[0])
					{
						if (WriteBufferToFile(FileName))
						{
							SIOUXBuffer.dirtybit = FALSE;
							return 1;
						}
						else
						{
							sprintf(msg, "Could not write to file %s", TitleName);
							MessageBox(WindowHandle, msg, AppName, 
															MB_OK | MB_ICONEXCLAMATION);
						}
					    return 0;
					}
					if (ShowFileSaveDialog(WindowHandle, FileName, TitleName))
					{
						sprintf(msg, "%s - %s", AppName, 
											TitleName[0] ? TitleName : "untitled");
						SetWindowText (WindowHandle, msg);
					
						if (WriteBufferToFile(FileName))
						{
							SIOUXBuffer.dirtybit = FALSE;
							return 1;
						}
						else
						{
							sprintf(msg, "Could not write to file %s", TitleName);
							MessageBox(WindowHandle, msg, AppName, 
															MB_OK | MB_ICONEXCLAMATION);
						}
					}
					return 0;
				
				case IDM_COPY:
				case IDM_CUT:
					if (SIOUXBuffer.SelStartPtr)
					{
						char* TextPtr, *SourcePtr;
						int   CharCount = SIOUXBuffer.SelEndPtr - SIOUXBuffer.SelStartPtr;
						HGLOBAL TextHandle = GlobalAlloc(GHND, (unsigned long)(CharCount + 1));
						if (TextHandle)
						{
							TextPtr = (char*)GlobalLock(TextHandle);
							for (SourcePtr = SIOUXBuffer.SelStartPtr;
										SourcePtr < SIOUXBuffer.SelEndPtr; SourcePtr++)
								*TextPtr++ = *SourcePtr;
							GlobalUnlock(TextHandle);
							OpenClipboard(WindowHandle);
							EmptyClipboard();
							SetClipboardData(CF_TEXT, TextHandle);
							CloseClipboard();
							if (LOWORD(wParam) == IDM_CUT)
							{
								DeleteCharsFromBuffer(SIOUXBuffer.SelStartPtr, CharCount); 
								TextPtrToRowCol(SIOUXBuffer.SelStartPtr, &CaretRow, 
																				&CaretCol);
								SIOUXBuffer.SelStartPtr = NULL;
								SIOUXBuffer.SelEndPtr   = NULL;
								HideCaret(WindowHandle);
								InvalidateRect(WindowHandle, NULL, TRUE);
								ReplantCaret(CaretRow, CaretCol, CharHeight, CharWidth, 
																	SIOUXBuffer.VscrollPos);
							}
						}
						else
							MessageBox(WindowHandle, "Could not get memory for clipboard",
												AppName, MB_OK | MB_ICONEXCLAMATION);
					}
					return 0;
					
                case IDM_ALL:
                	SIOUXBuffer.SelStartPtr = SIOUXBuffer.startpos;
                	SIOUXBuffer.SelEndPtr   = SIOUXBuffer.endpos;
					InvalidateRect(WindowHandle, NULL, TRUE);
					return 0;                	
                
                case IDM_PASTE:
                	if (IsClipboardFormatAvailable (CF_TEXT))
                	{
                		HGLOBAL ClipboardMemoryHandle;
                		char* ClipboardCopyPtr;
                		char* ClipboardMemoryPointer;
  						char* strptr;
  						int count;
  						unsigned int StringLength;	/*- mm 990609 -*/
 						hdc = GetDC(WindowHandle);
              			OpenClipboard(WindowHandle);
                		ClipboardMemoryHandle = GetClipboardData(CF_TEXT);
                		StringLength = (unsigned int)GlobalSize(ClipboardMemoryHandle);	/*- mm 990609 -*/
                		ClipboardCopyPtr = (char*)malloc(StringLength);
               			ClipboardMemoryPointer = (char*)GlobalLock(ClipboardMemoryHandle);
                		strcpy(ClipboardCopyPtr, ClipboardMemoryPointer);
                		GlobalUnlock(ClipboardMemoryHandle);
                		CloseClipboard();
                		StringLength = strlen(ClipboardCopyPtr);
                 		while((strptr = strstr(ClipboardCopyPtr, "\r\n")) != NULL)
                		{
                			while(strptr++ <= (ClipboardCopyPtr+StringLength))
                				*strptr = *(strptr+1);
                			StringLength--;
              			}
						for (count = 0; (count < StringLength) && 
													(*(ClipboardCopyPtr+count)); count++)
							SendMessage(WindowHandle, WM_CHAR, 
													(unsigned int)*(ClipboardCopyPtr+count), 0L);	/*- mm 990609 -*/
						free(ClipboardCopyPtr);
            		
                	}
                    return 0;
                    
				case IDM_PRINT:
                    if (!WinSIOUXprint(ThisInst, WindowHandle, TitleName, SIOUXBuffer))
						MessageBox(WindowHandle, "Could not print output", 
 										AppName, MB_OK | MB_ICONEXCLAMATION);
 					return 0;
					
				case IDM_EXIT:
					SendMessage(WindowHandle, WM_CLOSE, 0, 0L);
					return 0;
			}
			
		case WM_CREATE:/*  the window has just been created  */
			if (ResizeFlag)													/*- mm 001205 -*/
				return 0;
			GetClientRect(WindowHandle, &ClientRect);						/*- mm 000721 -*/
            ThisInst = ((LPCREATESTRUCT) lParam) -> hInstance ;
			hdc      = GetDC(WindowHandle);            /* Get device context */
			SelectObject(hdc, GetFont(hdc, 0, &CharWidth, &CharHeight));
			InitOpenFileNameStruct(WindowHandle);

			SetScrollRange(WindowHandle,        /* Window handle                    */
			               SB_VERT,             /* Vertical scroll bar              */
			               0,                   /* Starting position                */
			               SIOUXBuffer.numlines,/* Number of lines in scroll range. */
			               FALSE);              /* don't redraw scroll bar          */
			SetScrollPos(WindowHandle,          /* Window handle                    */
			             SB_VERT,               /* Vertical scroll bar              */
			             SIOUXBuffer.VscrollPos, 
			             TRUE);
			return 0 ;

		case WM_SETFOCUS:
			/* Create and show caret if position on current screen */
			CreateCaret(WindowHandle, NULL, CARET_WIDTH, CharHeight);
			SetCaretPos(CaretCol * CharWidth + LEFT_MARGIN, 
										(CaretRow - SIOUXBuffer.VscrollPos) * CharHeight);
			ShowCaret(WindowHandle);
			return 0;

		case WM_KILLFOCUS :
			/* hide and destroy the caret */
			HideCaret(WindowHandle);
			DestroyCaret();
			return 0;

		case WM_INITMENUPOPUP:
			if (lParam == 1)
			{
				EnableMenuItem((HMENU)wParam, IDM_COPY,
				     			(unsigned int)((SIOUXBuffer.SelStartPtr) ? MF_ENABLED : MF_GRAYED));	/*- mm 990609 -*/
				EnableMenuItem((HMENU)wParam, IDM_CUT,
				     			(unsigned int)((SIOUXBuffer.SelStartPtr) ? MF_ENABLED : MF_GRAYED));	/*- mm 990609 -*/
				EnableMenuItem((HMENU)wParam, IDM_PASTE,
				     (unsigned int)(IsClipboardFormatAvailable(CF_TEXT) ? MF_ENABLED : MF_GRAYED));		/*- mm 990609 -*/
				
				return 0;
			}
  			
			break;

		case WM_LBUTTONDOWN:	
			MouseRow = HIWORD(lParam) / CharHeight;
			MouseCol = LOWORD(lParam) / CharWidth;
			if (MK_SHIFT & wParam)
			{
				if (SIOUXBuffer.SelStartPtr)
				{
	    			char *TextPtr = RowColToTextPtr(MouseRow + SIOUXBuffer.VscrollPos, 
	    																		MouseCol);
	    			if (TextPtr < SIOUXBuffer.SelEndPtr)
	    				SIOUXBuffer.SelStartPtr = TextPtr;
	    			else
	    				SIOUXBuffer.SelEndPtr = TextPtr;
					InvalidateRect(WindowHandle, NULL, TRUE);
				}
			}
			else
			{
				SIOUXBuffer.SelStartPtr = NULL;
				SIOUXBuffer.SelEndPtr 	= NULL;
				InvalidateRect(WindowHandle, NULL, TRUE);
				Scrolling = TRUE;
			}				
				
	        return(0);

		case WM_LBUTTONUP:
			if ((MouseRow == HIWORD(lParam) / CharHeight) &&
								(MouseCol == LOWORD(lParam) / CharWidth))
			{
				HideCaret(WindowHandle);
				CaretRow = MouseRow + SIOUXBuffer.VscrollPos;
				CaretCol = min(MouseCol, 
								GetLengthOfTextLine(RowColToTextPtr(CaretRow, 0)));
				ReplantCaret(CaretRow, CaretCol, CharHeight, CharWidth, 
															SIOUXBuffer.VscrollPos);
				MouseRow = -1;
				MouseCol = -1;
			}
	        return(0);
	        
	    case WM_MOUSEMOVE:
	    	if (wParam & MK_LBUTTON)
	    	{
	    		BOOL SelChange = FALSE;
	    		char *TextPtr = 
	    				RowColToTextPtr(HIWORD(lParam) / CharHeight + SIOUXBuffer.VscrollPos, 
	    															LOWORD(lParam) / CharWidth);
	    		if (SIOUXBuffer.SelStartPtr == NULL)
	    		{
	    			SIOUXBuffer.SelBasePtr = TextPtr;
	    			SIOUXBuffer.SelStartPtr = TextPtr;
				}
	    		else if (SIOUXBuffer.SelBasePtr != TextPtr)
	    		{
	    			if (TextPtr < SIOUXBuffer.SelBasePtr)
	    			{
	    				SIOUXBuffer.SelEndPtr   = SIOUXBuffer.SelBasePtr;
	    				SIOUXBuffer.SelStartPtr = TextPtr;
	    				SelChange = TRUE;
	    			}
	    			else if (SIOUXBuffer.SelEndPtr != TextPtr)
	    			{
	    				SIOUXBuffer.SelStartPtr   = SIOUXBuffer.SelBasePtr;
	    				SIOUXBuffer.SelEndPtr = TextPtr;
	    				SelChange = TRUE;
	    			}
	    		}
	    		else
	    		{
	    			SIOUXBuffer.SelStartPtr = NULL;
	    			SIOUXBuffer.SelEndPtr = NULL;
    				SelChange = TRUE;
    			}
    			if (SelChange)
					InvalidateRect(WindowHandle, NULL, TRUE);
	    		Scrolling = TRUE;        					/*- mm 010111 -*/
	    	}
	    	return (0);
		
		case WM_SIZE:                        	/* Window size has changed           */
            SIOUXBuffer.WindowHeight = HIWORD(lParam);/* Obtain new WinSIOUX console height*/
            SIOUXBuffer.WindowWidth  = LOWORD(lParam);/* Obtain new WinSIOUX console width */
            SIOUXBuffer.maxrow   = SIOUXBuffer.WindowHeight / CharHeight;
			SIOUXBuffer.maxcol   = (SIOUXBuffer.WindowWidth-SCROLLBARWIDTH) / CharWidth;
			if (SIOUXBuffer.startpos != SIOUXBuffer.endpos)
				SIOUXBuffer.numlines = FindNumLines();
                                   /* set caret to upper left corner*/
            CaretRow = 0;
            CaretCol = 0;
            if (WindowHandle == GetFocus())
				SetCaretPos(CaretCol * CharWidth + LEFT_MARGIN, 
												(CaretRow - SIOUXBuffer.VscrollPos) * CharHeight);
            return 0;

		case WM_VSCROLL:                     /* V scrolling action has occurred  */
        	Scrolling    = TRUE; 
            switch(LOWORD(wParam))
            {
            	case SB_TOP:
            		SIOUXBuffer.VscrollPos = 0;
            		break;
            		
            	case SB_BOTTOM:
            		SIOUXBuffer.VscrollPos = SIOUXBuffer.numlines - SIOUXBuffer.maxrow + BOTTOMGAP;
            		break;
            		
            	case SB_LINEUP:              			/* Scroll bar one line up pressed   */
					SIOUXBuffer.VscrollPos -= 1;        /* Adjust vertical scroll posn      */
					break ;

				case SB_LINEDOWN:            			/* Scroll bar one line down pressed */
					SIOUXBuffer.VscrollPos += 1;        /* Adjust vertical scroll posn      */
					break;

				case SB_PAGEUP:              			/* Scroll bar one page up pressed   */
					SIOUXBuffer.VscrollPos -= SIOUXBuffer.maxrow;
					break;
				
				case SB_PAGEDOWN:            			/* Scroll bar one page down pressed */
					SIOUXBuffer.VscrollPos += SIOUXBuffer.maxrow;
					if (SIOUXBuffer.VscrollPos >= 
								(SIOUXBuffer.numlines - SIOUXBuffer.maxrow + BOTTOMGAP))
            			SIOUXBuffer.VscrollPos = 
            						SIOUXBuffer.numlines - SIOUXBuffer.maxrow + BOTTOMGAP;
					break;
				
				case SB_THUMBPOSITION:       /* Released thumb position          */
					SIOUXBuffer.VscrollPos = HIWORD(wParam);
					break;
				
				case SB_SCROLLTO:
					break;
					
				default :
				break ;
			}
            SIOUXBuffer.VscrollPos = max(0, min(SIOUXBuffer.VscrollPos, SIOUXBuffer.numlines));
            if (SIOUXBuffer.VscrollPos != GetScrollPos(WindowHandle, SB_VERT))
			{
				SIOUXBuffer.curtop = RowColToTextPtr(SIOUXBuffer.VscrollPos, 0);
				SetScrollPos(WindowHandle, SB_VERT, SIOUXBuffer.VscrollPos, TRUE);
				InvalidateRect(WindowHandle, NULL, TRUE);
			}
			return 0 ;

		case WM_PAINT:  /* the window needs repainting */
			{
				int BottomRow;
				int TopLineNum = SIOUXBuffer.VscrollPos;
				int DummyCaretRow = 0;
				int DummyCaretCol = 0;
				int SelectMode;								/*- mm 990526 -*/
				BottomRow = SIOUXBuffer.maxrow;
				if (!Scrolling)
				{
					TopLineNum = /*- mm 990521 -*/
						max(0, SIOUXBuffer.numlines - SIOUXBuffer.maxrow + 2 * BOTTOMGAP);
					SIOUXBuffer.curtop = RowColToTextPtr(TopLineNum, 0);					
				}
				SIOUXBuffer.VscrollPos = TopLineNum;

				HideCaret(WindowHandle);
				hdc = BeginPaint(WindowHandle, &ps);
				SelectObject(hdc, GetFont(hdc, 0, &CharWidth, &CharHeight));
				SIOUXBuffer.col = SIOUXBuffer.row = 0;
				for (mptr = SIOUXBuffer.curtop; 
					(mptr < SIOUXBuffer.endpos) && (SIOUXBuffer.row < BottomRow);
					 mptr++)
				{
					aChar = *mptr;
					if ((SIOUXBuffer.SelStartPtr) && (mptr >= SIOUXBuffer.SelStartPtr) && 
									(mptr < SIOUXBuffer.SelEndPtr))
						SelectMode = 1;
					else
						SelectMode = 0;
								/*- mm 990526 -*/
					if ((aChar == '\n') && (SIOUXBuffer.row == BottomRow))
						break;
					DisplayChar(hdc, aChar, &CharWidth, &CharHeight,  
					        &DummyCaretRow, &DummyCaretCol, SelectMode, Scrolling); /*- mm 991209 -*/
				}
				SetScrollPos(WindowHandle, SB_VERT, SIOUXBuffer.VscrollPos, TRUE);
				EndPaint(WindowHandle, &ps);
				if (!SIOUXBuffer.SelStartPtr)
					ReplantCaret(CaretRow, CaretCol, CharHeight, CharWidth, 
														SIOUXBuffer.VscrollPos);
 				Scrolling  = FALSE;   /*- mm991209 -*/
				return 0; 
			}
			
		case WM_CLRSCR:       /*- mm 980727 -*/
			SIOUXBuffer.endpos   	= SIOUXBuffer.startpos;
			SIOUXBuffer.curtop   	= SIOUXBuffer.startpos;
			SIOUXBuffer.numlines 	= 0;
			SIOUXBuffer.VscrollPos	= 0;
			CaretCol             	= 0;
			CaretCol             	= 0;
			SetScrollRange(WindowHandle,        /* Window handle                    */
			               SB_VERT,             /* Vertical scroll bar              */
			               0,                   /* Starting position                */
			               SIOUXBuffer.numlines,/* Number of lines in scroll range. */
			               FALSE);              /* don't redraw scroll bar          */
			SetScrollPos(WindowHandle,          /* Window handle                    */
			             SB_VERT,               /* Vertical scroll bar              */
			             SIOUXBuffer.VscrollPos, 
			             TRUE);
			HideCaret(WindowHandle);
			InvalidateRect(WindowHandle, NULL, TRUE);
			return 0;

		case WM_LINEOUT:
			hdc = GetDC(WindowHandle);
			SIOUXBuffer.SelStartPtr = NULL;
			SIOUXBuffer.SelEndPtr   = NULL;
			HideCaret(WindowHandle);
			SelectObject(hdc, GetFont(hdc, 0, &CharWidth, &CharHeight));
			mptr = (char*)wParam;
			for (j = 0; j < lParam; j++)
			{
				StoreChar(mptr + j, SIOUXBuffer.endpos);
				DisplayChar(hdc, *(mptr+j), &CharWidth, &CharHeight, 
													&CaretRow, &CaretCol, 0, Scrolling); /*- mm 991209 -*/
			}
			ReplantCaret(CaretRow, CaretCol, CharHeight, CharWidth, SIOUXBuffer.VscrollPos);
			
		    return 0;

		case WM_KEYDOWN:
			HideCaret(WindowHandle);
			switch(wParam)
			{
				case VK_HOME:
					SendMessage(WindowHandle, WM_VSCROLL, SB_TOP, 0L);
					break;
				
				case VK_END:
					SendMessage(WindowHandle, WM_VSCROLL, SB_BOTTOM, 0L);
					break;
				
				case VK_PRIOR:
					SendMessage(WindowHandle, WM_VSCROLL, SB_PAGEUP, 0L);
					break ;
				
				case VK_NEXT:
					SendMessage(WindowHandle, WM_VSCROLL, SB_PAGEDOWN, 0L);
					break;
				
				case VK_UP:
					if (CaretRow > 0)
						CaretRow--;
					if ((CaretRow >= SIOUXBuffer.VscrollPos) && 
							(CaretRow <= (SIOUXBuffer.VscrollPos + SIOUXBuffer.maxrow)))
					{
						if (CaretRow < SIOUXBuffer.VscrollPos)
							SendMessage(WindowHandle, WM_VSCROLL, SB_LINEUP, 0L);
					}
					else
					{
						SIOUXBuffer.VscrollPos = CaretRow - (SIOUXBuffer.maxrow/2);
						if (SIOUXBuffer.VscrollPos < 1)
							SIOUXBuffer.VscrollPos = 0;
						SendMessage(WindowHandle, WM_VSCROLL, SB_SCROLLTO, 0L);
					}
					break;
				
				case VK_DOWN:
					if (CaretRow < SIOUXBuffer.numlines)
						CaretRow++;
					if ((CaretRow >= SIOUXBuffer.VscrollPos) && 
							(CaretRow <= (SIOUXBuffer.VscrollPos + SIOUXBuffer.maxrow)))
					{
						if (CaretRow > (SIOUXBuffer.VscrollPos + SIOUXBuffer.maxrow))
							SendMessage(WindowHandle, WM_VSCROLL, SB_LINEDOWN, 0L);
					}
					else
					{
						SIOUXBuffer.VscrollPos = CaretRow - (SIOUXBuffer.maxrow/2);
						if (SIOUXBuffer.VscrollPos < 1)
							SIOUXBuffer.VscrollPos = 0;
						SendMessage(WindowHandle, WM_VSCROLL, SB_SCROLLTO, 0L);
					}
					break;
				
				case VK_LEFT:
					{
						BOOL NeedToScroll = FALSE;
						if (!((CaretRow >= SIOUXBuffer.VscrollPos) && 
								(CaretRow <= (SIOUXBuffer.VscrollPos + SIOUXBuffer.maxrow))))
						{
							NeedToScroll = TRUE;
							SIOUXBuffer.VscrollPos = max(CaretRow - (SIOUXBuffer.maxrow/2), 0);
						}
						if (CaretCol > 0)
							CaretCol--;
						else
						{
							CaretRow--;
							CaretCol = GetLengthOfTextLine(RowColToTextPtr(CaretRow, 0));
							if (CaretRow < SIOUXBuffer.VscrollPos)
							{
								SIOUXBuffer.VscrollPos--;
								NeedToScroll = TRUE;
							}
						}
						if (NeedToScroll)
							SendMessage(WindowHandle, WM_VSCROLL, SB_SCROLLTO, 0L);
							
					}
					break;
				
				case VK_RIGHT:
					{
						BOOL NeedToScroll = FALSE;
						if (!((CaretRow >= SIOUXBuffer.VscrollPos) && 
								(CaretRow <= (SIOUXBuffer.VscrollPos + SIOUXBuffer.maxrow))))
						{
							NeedToScroll = TRUE;
							SIOUXBuffer.VscrollPos = max(CaretRow - (SIOUXBuffer.maxrow/2), 0);
						}
						if (CaretCol < GetLengthOfTextLine(RowColToTextPtr(CaretRow, 0)))
							CaretCol++;
						else
						{
							CaretRow++;
							CaretCol = 0;
							if (CaretRow > (SIOUXBuffer.VscrollPos + SIOUXBuffer.maxrow))
							{
								SIOUXBuffer.VscrollPos++;
								NeedToScroll = TRUE;
							}
						}
						if (NeedToScroll)
							SendMessage(WindowHandle, WM_VSCROLL, SB_SCROLLTO, 0L);
							
					}
					break;
					
			}
			ReplantCaret(CaretRow, CaretCol, CharHeight, CharWidth, SIOUXBuffer.VscrollPos);
			
			return 0;
		
		case WM_CHAR :
			{
				char* WhereToStore;
				if (wParam == 0x03)                     /* Ctrl+C */
				{
					if (WinSIOUX_Terminating)				/*- mm 990125 -*/
					/* Interpret Ctrl+C as Copy command */
						SendMessage(WindowHandle, WM_COMMAND, IDM_COPY, 0L);
					else
					{
						if (SIOUXBuffer.SelStartPtr == NULL)
						/* Interpret Ctrl+C as Interrupt */
							raise(SIGINT);
						else
						/* Interpret Ctrl+C as Copy command */
							SendMessage(WindowHandle, WM_COMMAND, IDM_COPY, 0L);
					}
					return (0);
				}
				
				if (SIOUXBuffer.SelStartPtr && SIOUXBuffer.SelEndPtr)
				{
					DeleteCharsFromBuffer(SIOUXBuffer.SelStartPtr, 
										SIOUXBuffer.SelEndPtr - SIOUXBuffer.SelStartPtr);
					TextPtrToRowCol(SIOUXBuffer.SelStartPtr, &CaretRow, &CaretCol);
					SIOUXBuffer.SelStartPtr = NULL;
					SIOUXBuffer.SelEndPtr   = NULL;
					if (wParam == '\b')
					{
						HideCaret(WindowHandle);
						InvalidateRect(WindowHandle, NULL, TRUE);
						ReplantCaret(CaretRow, CaretCol, CharHeight, CharWidth, 
																		SIOUXBuffer.VscrollPos);
						return 0;
					}
				}
				if (SIOUXBuffer.NeedInput)
				{
					WhereToStore = SIOUXBuffer.endpos;
					TextPtrToRowCol(SIOUXBuffer.endpos, &CaretRow, &CaretCol);
					Scrolling    = FALSE;
				}
				else
				{
					WhereToStore = RowColToTextPtr(CaretRow, CaretCol);
					Scrolling 	 = TRUE;
				}
				HideCaret(WindowHandle);
				hdc = GetDC(WindowHandle);
				SelectObject(hdc, GetFont(hdc, 0, &CharWidth, &CharHeight));

				switch (wParam)
				{

					case 0x1a:                     /* Ctrl+Z */
					case 0x04:                     /* Ctrl+D */
								/* Both of these are interpreted as eof */
						if (SIOUXBuffer.NeedInput)
						{
							atEOF = TRUE;
							SIOUXBuffer.inputavail = TRUE;
						}
						break;
						
					case '\b':                    /* backspace */
						if (WhereToStore == SIOUXBuffer.endpos)
						{
							if (SIOUXBuffer.inputlast > SIOUXBuffer.inputstart)
							{
								SIOUXBuffer.inputlast--;
								*SIOUXBuffer.inputlast = ' ';
								StoreChar("\b", WhereToStore);
								DisplayChar(hdc, '\b', &CharWidth, &CharHeight, 
												&CaretRow, &CaretCol, 0, Scrolling); /*- mm 991209 -*/
							}
						}
						else
						{
							if (CaretCol > 0)
							{
								StoreChar("\b", WhereToStore-1);
								CaretCol--;
							}
							else
							{
								StoreChar("\b", WhereToStore-1);
								StoreChar("\b", WhereToStore-2);
								CaretRow--;
								CaretCol = 
									GetLengthOfTextLine(RowColToTextPtr(CaretRow, 0));
							}
						}
						break;
			
					case '\r':                    /* line feed */
						if (SIOUXBuffer.NeedInput)
						{
							if ((SIOUXBuffer.inputlast - SIOUXBuffer.inputstart) <= 
																	SIOUX_INPUTBUFSIZ)
							{
								SIOUXBuffer.inputlast[0] = '\r';
								SIOUXBuffer.inputlast[1] = '\n';
								StoreChar(SIOUXBuffer.inputlast, WhereToStore);
								WhereToStore++;
								SIOUXBuffer.inputlast++;
								StoreChar(SIOUXBuffer.inputlast, WhereToStore);
								SIOUXBuffer.inputlast++;
								DisplayChar(hdc, '\r', &CharWidth, &CharHeight,
												&CaretRow, &CaretCol, 0, Scrolling); /*- mm 991209 -*/
								DisplayChar(hdc, '\n', &CharWidth, &CharHeight, 
												&CaretRow, &CaretCol, 0, Scrolling); /*- mm 991209 -*/
		
							}
							else
								MessageBeep(0);
							SIOUXBuffer.inputavail = TRUE;
						}
						else
						{
							StoreChar("\r\n", WhereToStore++);
							StoreChar("\n", WhereToStore);
							InvalidateRect(WindowHandle, NULL, TRUE);
							CaretCol = 0;
							CaretRow++;
							
						}
						break;
							
					case '\t':
						if (!SIOUXBuffer.NeedInput)
						{
							int i;
							int SpacesToInsert;
							
							if (SIOUXSettings.tabspaces) 
							{
								/*	insert spaces for tabs*/
								i = CaretCol;
								SpacesToInsert = SIOUXSettings.tabspaces -
												 (i % SIOUXSettings.tabspaces);
								InsertCharsIntoBuffer(WhereToStore, SpacesToInsert);
								
								for (i = 0; i < SpacesToInsert; i++)
								{
									*WhereToStore = ' ';
									WhereToStore++;
									CaretCol++; 
								}
							} 
							else
							{
								StoreChar("\t", WhereToStore);
								CaretCol++;
							}
							break;
						}
						    /* else drop into default case */
						
					default:                       /* character codes */
						if (SIOUXBuffer.NeedInput)
						{
							if ((SIOUXBuffer.inputlast - SIOUXBuffer.inputstart) <= 
																	SIOUX_INPUTBUFSIZ-2)
							{
								*SIOUXBuffer.inputlast = (char)wParam;
								StoreChar(SIOUXBuffer.inputlast, WhereToStore);
								SIOUXBuffer.inputlast++;
								DisplayChar(hdc, (char)wParam, &CharWidth, &CharHeight, 
														&CaretRow, &CaretCol, 0, Scrolling); /*- mm 991209 -*/
							}
							else
								MessageBeep(0);
						}
						else
						{
							char ch = (char)wParam;
							StoreChar(&ch, WhereToStore);
							InvalidateRect(WindowHandle, NULL, TRUE);
							CaretCol++;
						}
				}
				if (!((CaretRow >= SIOUXBuffer.VscrollPos) && 
						(CaretRow <= (SIOUXBuffer.VscrollPos + SIOUXBuffer.maxrow))))
				{
					SIOUXBuffer.VscrollPos = max(CaretRow - SIOUXBuffer.maxrow/2, 0);
					SendMessage(WindowHandle, WM_VSCROLL, SB_SCROLLTO, 0L);
				}
				else if (SIOUXBuffer.row > SIOUXBuffer.maxrow)
					InvalidateRect(WindowHandle, NULL, TRUE);
				ReplantCaret(CaretRow, CaretCol, CharHeight, CharWidth, 
																SIOUXBuffer.VscrollPos);				
				
				return 0 ;
			}
			
		case WM_CLOSE:
			if (!SIOUXBuffer.dirtybit || !SIOUXSettings.asktosaveonclose || /*- mm 990210 -*/
						IDCANCEL != DoYouWantToSave(WindowHandle, TitleName))
            	DestroyWindow(WindowHandle);

            return 0;


		case WM_QUERYENDSESSION :
			if (!SIOUXBuffer.dirtybit || 
						IDCANCEL != DoYouWantToSave(WindowHandle, TitleName))
			    return 1 ;
			
			return 0;
			
		case WM_DESTROY:  /* the user has ordered the window to be destroyed Alt-F4 */
		{
			int SetJmpResult;				/*- mm 001205 -*/
			if (ResizeFlag)					/*- mm 001205 -*/
				return 0;					/*- mm 001205 -*/
			PostQuitMessage(0);
			if (!WinSIOUX_Terminating)      /*- mm 010111 -*/
			{
				WinSIOUX_Terminating = 1;
				SetJmpResult = setjmp(TJumpBuf);
				if (!SetJmpResult)
				{
					signal(SIGILL, TerminationIntHandler);
			
					TerminateThread(ThreadHandle, 0);		/*- mm 010111 -*/
				}
			}
			
			return 0;
		}
		
	}
	return DefWindowProc(WindowHandle, iMsg, wParam, lParam);
}

void _MSL_CDECL WriteCharsToConsole(const char * mess, long len)		
{
	if (!SIOUXBuffer.installed)
	{
		SizeWindow();												/*- mm 001205 -*/
		ShowWindow(WindowHandle, SIOUXBuffer.CmdShow);
		UpdateWindow(WindowHandle);
		AcceleratorHandle     = NULL;
		AcceleratorHandle     = LoadAccelerators(ProgramInstance, AppName);
		SIOUXBuffer.installed = TRUE;
	}
	SendMessage(WindowHandle, WM_LINEOUT, (unsigned int)mess, len);
	MessageLoop();
}

static void DisplayChar(HDC hdc, char aChar, int*  CharWidthPtr, int* CharHeightPtr, 
                        int* CaretRowPtr, int* CaretColPtr, int SelectMode, int Scrolling) /*- mm 990416 -*//*- mm 990526 -*/
{
	int   i, spaces, SpacesToInsert;
	SelectObject(hdc, GetFont(hdc, 0, CharWidthPtr, CharHeightPtr));
	if (SelectMode)
	{
		SetBkColor(hdc, 0L);
		SetTextColor(hdc, 0x00ffffffL);
	}
	else
	{
		SetBkColor(hdc, GetSysColor(COLOR_WINDOW));
		SetTextColor(hdc, 0L);
	}
	switch(aChar)
	{
		case '\a':           /* Audible alarm */
			MessageBeep(0);
			break;
			
		case '\r':
			SIOUXBuffer.col = 0;
			*CaretColPtr    = 0;
			break;
			
		case '\f':
			SIOUXBuffer.row += SIOUXBuffer.maxrow;
			*CaretRowPtr    += SIOUXBuffer.maxrow;
			*CaretColPtr     = 0;
			SIOUXBuffer.col  = 0;
			break;
			
		case '\n':
			SIOUXBuffer.row++;
			(*CaretRowPtr)++;
			*CaretColPtr    = 0;
			SIOUXBuffer.col = 0;
			break;
			
		case '\b':
			if (SIOUXBuffer.col > 0)
			{
				SIOUXBuffer.col--;
				DisplayChar(hdc, ' ', CharWidthPtr, CharHeightPtr, CaretRowPtr, 
													CaretColPtr, 0, Scrolling); /*- mm 990526 -*/
				SIOUXBuffer.col--;
				*CaretColPtr -= 2;
			}
			break;

		case '\t':	/*	Tab character*/
			if (SIOUXSettings.tabspaces)
				spaces = SIOUXSettings.tabspaces;
			else
				spaces = 4;
			SpacesToInsert = spaces - (SIOUXBuffer.col % spaces);
			for (i = 0; i < SpacesToInsert; i++)
				DisplayChar(hdc, ' ', CharWidthPtr, CharHeightPtr, CaretRowPtr, 
													CaretColPtr, 0, Scrolling); /*- mm 990526 -*/
			break;
			
		default:
			TextOut(hdc,              		 		/* Handle to device context       */
		            *CharWidthPtr * SIOUXBuffer.col + LEFT_MARGIN,	
		            								/* Position of lh end of text     */
		            *CharHeightPtr * SIOUXBuffer.row,	/* Position of top of chars       */
		                                     		/* relative top of client area    */
		            &aChar,                  		/* Text to be printed             */
		            1);                      		/* Length of string to be printed */
		    SIOUXBuffer.col++;
		    (*CaretColPtr)++;
		    if (SIOUXBuffer.col >= SIOUXBuffer.maxcol)
		    {
		    	SIOUXBuffer.col = 0;
		    	SIOUXBuffer.row++;
		    	*CaretColPtr = 0;
		    	(*CaretRowPtr)++;
		    }
		    break;
	}
	if (SIOUXBuffer.row > (SIOUXBuffer.maxrow - BOTTOMGAP))	/*- mm 990521 -*/
	{
		if (!Scrolling) /*- mm 991209 -*/
			SIOUXBuffer.VscrollPos += (SIOUXBuffer.row - (SIOUXBuffer.maxrow - BOTTOMGAP));/*- mm 991209 -*/
		SetScrollPos(WindowHandle, SB_VERT, SIOUXBuffer.VscrollPos, TRUE);
		i = 0;
		while((i < (SIOUXBuffer.row - SIOUXBuffer.maxrow)) &&
							(SIOUXBuffer.curtop < SIOUXBuffer.endpos))
			if (*SIOUXBuffer.curtop++ == '\n')
				i++;
		if (!Scrolling) /*- mm 991209 -*/
			InvalidateRect(WindowHandle, NULL, TRUE);
	}
}

static void StoreChar(char* chptr, char* where)		/*- mm 990416 -*/
{
	int i, SpacesToInsert;
	SIOUXBuffer.dirtybit = TRUE;
	switch(*chptr)
	{
		case '\a':       /*Audible Alert---don't store*/
			break;
			
		case '\b':
			if (where == SIOUXBuffer.endpos)
			{
				if (SIOUXBuffer.endpos > SIOUXBuffer.startpos)
				{
					if (SIOUXBuffer.endpos[-1] != '\n')
					{
						SIOUXBuffer.endpos--;
						*SIOUXBuffer.endpos = ' ';
					}
				}
			}
			else
				DeleteCharsFromBuffer(where, 1);
			break;
			
		case '\f':
			if (where == SIOUXBuffer.endpos)
			{
				if (!CheckBufOverflow(2*SIOUXBuffer.maxrow))
				{
					for (i = 0; i < SIOUXBuffer.maxrow; i++)
					{
						*SIOUXBuffer.endpos     = '\r';
						*(SIOUXBuffer.endpos+1) = '\n';
						SIOUXBuffer.endpos += 2;
					}
					SIOUXBuffer.numlines += SIOUXBuffer.maxrow;
				}
			}
			break;
		
		case '\r':
			if (where == SIOUXBuffer.endpos)
			{
				if (chptr[1] == '\n')
				{
					*SIOUXBuffer.endpos = '\r';
					SIOUXBuffer.endpos++;
					if (CheckBufOverflow(1))
						break;
				}
				else
				{
					while (SIOUXBuffer.endpos > SIOUXBuffer.startpos)
						if (*SIOUXBuffer.endpos == '\n')
						{
							SIOUXBuffer.endpos++;
							CheckBufOverflow(1);
							break;
						}
						else
						{
							*SIOUXBuffer.endpos = ' ';
							SIOUXBuffer.endpos--;
						}
					CharsInLine = 0;       
				}
					
			}
			else
			{
				InsertCharsIntoBuffer(where, 1);
				*where = '\r';
			}
			break;

		case '\t':	/*	Tab character*/
			if (SIOUXSettings.tabspaces) 
			{
				/*	insert spaces for tabs*/
				if (CheckBufOverflow(SIOUXSettings.tabspaces))
					break;

				i = SIOUXBuffer.col;

				SpacesToInsert = SIOUXSettings.tabspaces -
								 (i % SIOUXSettings.tabspaces);
				for (i = 0; i < SpacesToInsert; i++)
				{
					*SIOUXBuffer.endpos = ' ';
					SIOUXBuffer.endpos++;
				}
			} 
			else
			{
				*SIOUXBuffer.endpos = '\t';
				SIOUXBuffer.endpos++;
			}

			break;
							
		case '\n':
			SIOUXBuffer.numlines++;
			CharsInLine = 0;
			SetScrollRange(WindowHandle,        /* Window handle                    */
		       			   SB_VERT,             /* Vertical scroll bar              */
		       			   0,                   /* Starting position                */
		       			   SIOUXBuffer.numlines,/* Number of lines in scroll range. */
		       			   FALSE);              /* don't redraw scroll bar          */

		default:
			if (where == SIOUXBuffer.endpos)
			{
				*SIOUXBuffer.endpos = *chptr;
				SIOUXBuffer.endpos++;
				if (CheckBufOverflow(1))
					break;
				CharsInLine++;						/*- mm 980522 -*/
				if (CharsInLine > SIOUXBuffer.maxcol)
				{
					SIOUXBuffer.numlines++;
					SetScrollRange(WindowHandle,        /* Window handle                    */
				       			   SB_VERT,             /* Vertical scroll bar              */
				       			   0,                   /* Starting position                */
				       			   SIOUXBuffer.numlines,/* Number of lines in scroll range. */
				       			   FALSE);              /* don't redraw scroll bar          */
					CharsInLine = 0;
				}
			}
			else
			{
				InsertCharsIntoBuffer(where, 1);
				*where = *chptr;
			}
			break;
		
	}
}	

/* begin mm 001205 */
static void SizeWindow()
{
	int HorizontBorder, VerticalBorder;
	HorizontBorder = INITIALY - ClientRect.bottom;
	VerticalBorder = INITIALX - ClientRect.right + 10;
	ResizeFlag = 1;
    DestroyWindow(WindowHandle);
    WindowHandle = CreateWindow(AppName,        
		                "WinSIOUX Text Window", 
                        WS_OVERLAPPEDWINDOW | WS_VSCROLL,    
                        CW_USEDEFAULT,          
                        CW_USEDEFAULT,          
                        SIOUXSettings.columns * CharWidth + VerticalBorder,         
                        SIOUXSettings.rows * CharHeight + HorizontBorder,          
                        NULL,                   
                        NULL,                   
                        ProgramInstance,           
		                NULL);		            
	ResizeFlag = 0;
	return;
}	
/* end /*- mm 001205 -*/

static void InitOpenFileNameStruct(HWND WindowHandle)			  /*- mm 990416 -*/
{
	static char szFilter[] = "Text Files (*.TXT)\0*.txt\0"  \
	                      "ASCII Files (*.ASC)\0*.asc\0" \
	                      "All Files (*.*)\0*.*\0\0";
	
	OpenFileName.lStructSize       = sizeof(OPENFILENAME);
	OpenFileName.hwndOwner         = WindowHandle;
	OpenFileName.hInstance         = NULL;
	OpenFileName.lpstrFilter       = szFilter;
	OpenFileName.lpstrCustomFilter = NULL;
	OpenFileName.nMaxCustFilter    = 0;
	OpenFileName.nFilterIndex      = 0;
	OpenFileName.lpstrFile         = NULL;    
	OpenFileName.nMaxFile          = _MAX_PATH;
	OpenFileName.lpstrFileTitle    = NULL;          
	OpenFileName.nMaxFileTitle     = _MAX_FNAME + _MAX_EXT_LEN;
	OpenFileName.lpstrInitialDir   = NULL;
	OpenFileName.lpstrTitle        = NULL;
	OpenFileName.Flags             = 0;             
	OpenFileName.nFileOffset       = 0;
	OpenFileName.nFileExtension    = 0;
	OpenFileName.lpstrDefExt       = "txt";
	OpenFileName.lCustData         = 0L;
	OpenFileName.lpfnHook          = NULL;
	OpenFileName.lpTemplateName    = NULL;
}

static BOOL ShowFileSaveDialog(HWND WindowHandle, PSTR FileName, PSTR TitleName)	/*- mm 990416 -*/
{
	OpenFileName.hwndOwner         = WindowHandle;
	OpenFileName.lpstrFile         = FileName;
	OpenFileName.lpstrFileTitle    = TitleName;
	OpenFileName.Flags             = OFN_OVERWRITEPROMPT;
	
	return GetSaveFileName(&OpenFileName);
}

static BOOL WriteBufferToFile(PSTR FileName)			/*- mm 990416 -*/
{
	FILE  *OutputFile;
	int    TextLength;
	if (NULL == (OutputFile = fopen(FileName, "wb")))
		return FALSE;
	
	TextLength = SIOUXBuffer.endpos - SIOUXBuffer.startpos;
	if (TextLength != fwrite(SIOUXBuffer.startpos, 1, (unsigned int)TextLength, OutputFile))	/*- mm 990609 -*/
	{
		fclose(OutputFile);
		return FALSE;
	}
	
	fclose (OutputFile);
	
	return TRUE;
}

static int CheckBufOverflow(int NumOfBytes)			/*- mm 990416 -*/
{
	char* BufPtr = SIOUXBuffer.startpos + NumOfBytes + 1;
	if ((SIOUXBuffer.endpos - BufPtr) >= SIOUXBuffer.bufsize)
	{
		*SIOUXBuffer.endpos = '\0';    /* Search stopper */			/*- mm 981210 -*/
		BufPtr = strstr(BufPtr, "\r\n");							/*- mm 981210 -*/
		DeleteCharsFromBuffer(SIOUXBuffer.startpos, 				/*- mm 981210 -*/
							BufPtr - SIOUXBuffer.startpos + 1);		/*- mm 981210 -*/
    }
    return 0;
}

int _MSL_CDECL ReadCharsFromConsole(void * buf, unsigned long bufsize, unsigned long* charsread)
{
	int 	i;
	char* 	ptr;
	MSG 	msg;
	if (!SIOUXBuffer.installed)
	{
		SizeWindow();									/*- mm 001205 -*/
		ShowWindow(WindowHandle, SIOUXBuffer.CmdShow);
		UpdateWindow(WindowHandle);
		SIOUXBuffer.installed = TRUE;
	}
	if (atEOF)
	{
		*(char*)buf= EOF;
		*charsread = 0;
		return 1;
	}
    SIOUXBuffer.NeedInput = TRUE;
	while(!SIOUXBuffer.inputavail && GetMessage(&msg, NULL, 0, 0))
	{
		if (WinSIOUX_Terminating)				/*- mm 990210 -*/
			return(1);							/*- mm 990210 -*/
		TranslateMessage(&msg);
		DispatchMessage(&msg);
    }
    if (SIOUXBuffer.inputavail)
    {
    	for (i = 0, ptr = (char*)buf; 
    	     (i < bufsize) && (SIOUXBuffer.inputcur < SIOUXBuffer.inputlast); i++)
    	{
    		*ptr = *SIOUXBuffer.inputcur;
    		SIOUXBuffer.inputcur++;
    		ptr++;
    	}
    	*charsread = (unsigned long)i;		/*- mm 990609 -*/
    	if (SIOUXBuffer.inputcur >= SIOUXBuffer.inputlast)
    	{
    		SIOUXBuffer.inputavail = FALSE;
    		SIOUXBuffer.inputcur = SIOUXBuffer.inputlast = SIOUXBuffer.inputstart;
    	}
    	SIOUXBuffer.NeedInput = FALSE;
    	return(1);
    }
    else
    	exit(1);
    
    return 1;
}
    
static short DoYouWantToSave(HWND WindowHandle, char *TitleName)	/*- mm 990416 -*/
{
     char msg[64 + _MAX_FNAME + _MAX_EXT_LEN];
     int  result;

     sprintf(msg, "Do you wish to save %s before quitting?",
               		TitleName[0] ? TitleName : "WinSIOUX.txt");    /*- mm 990301 -*/

     result = MessageBox(WindowHandle, msg, AppName, MB_YESNOCANCEL | MB_ICONQUESTION);

     if (result == IDYES)
     	if (!SendMessage(WindowHandle, WM_COMMAND, IDM_SAVE, 0L))
          	result = IDCANCEL;

     return (short)result;		/*- mm 990609 -*/
}

static void ReplantCaret(int NewCaretRow, int NewCaretCol, int CharHeight, int CharWidth, 
																int TopLine)/*- mm 990416 -*/
{
	int ActualLineLength;
	if ((NewCaretRow >= TopLine) && 
							(NewCaretRow <= (TopLine + SIOUXBuffer.maxrow)))
	{
		ActualLineLength = GetLengthOfTextLine(RowColToTextPtr(NewCaretRow, 0));
		if (ActualLineLength < NewCaretCol)
			NewCaretCol = ActualLineLength;
		CreateCaret(WindowHandle, NULL, CARET_WIDTH, CharHeight);
		SetCaretPos(NewCaretCol * CharWidth + LEFT_MARGIN, 
											(NewCaretRow - TopLine) * CharHeight);
		if (!SIOUXBuffer.SelStartPtr)
			ShowCaret(WindowHandle);
	}
}

static int GetLengthOfTextLine(char* BeginningPtr)			/*- mm 990416 -*/
{
	int LineLength = 0;
	char* ChPtr;

	*SIOUXBuffer.endpos = '\0';         /* Search stopper */
	ChPtr = strstr(BeginningPtr, "\r\n");
	if (ChPtr == NULL)
		LineLength = SIOUXBuffer.endpos - BeginningPtr;
	else
		LineLength = ChPtr - BeginningPtr;
	return ((LineLength > SIOUXBuffer.maxcol) ? SIOUXBuffer.maxcol : LineLength);
}

static char* RowColToTextPtr(int RowNumber, int ColNumber)		/*- mm 990416 -*/
{
	int   LineNumber = 0;
	int   LastLineNumber = 0;
	char* CurrPtr       = SIOUXBuffer.startpos;
	char* LastLineStart = SIOUXBuffer.startpos;

	if (RowNumber > (SIOUXBuffer.numlines+1))
		return (SIOUXBuffer.endpos);
	*SIOUXBuffer.endpos = '\0';         /* Search stopper */
	while(LineNumber < RowNumber)
	{
		CurrPtr = strstr(LastLineStart, "\r\n");
		if (CurrPtr == NULL)
		{
			CurrPtr = LastLineStart;
			break;
		}
		LastLineNumber = LineNumber;
		LineNumber++;
		LineNumber += (CurrPtr - LastLineStart) / SIOUXBuffer.maxcol;
		CurrPtr += 2;
		if (LineNumber < RowNumber)
			LastLineStart = CurrPtr;
	}
	if (LineNumber > RowNumber)
		CurrPtr = LastLineStart + (RowNumber - LastLineNumber) * SIOUXBuffer.maxcol;
	CurrPtr += ColNumber;
	return (min(SIOUXBuffer.endpos, CurrPtr));
}

static void TextPtrToRowCol(char* TextPtr, int* CharRow, int* CharCol)	/*- mm 990416 -*/
{
	int   LineCount = 0;
	char* CurrPtr       = SIOUXBuffer.startpos;
	char* LastLineStart = SIOUXBuffer.startpos;

	*SIOUXBuffer.endpos = '\0';         /* Search stopper */
	while(CurrPtr < TextPtr)
	{
		CurrPtr = strstr(LastLineStart, "\r\n");
		if (CurrPtr == NULL)
			break;
		if (CurrPtr < TextPtr)
		{
			LineCount++;
			LineCount += (CurrPtr - LastLineStart) / SIOUXBuffer.maxcol;
			LastLineStart = CurrPtr + 2;
		}
	}
	*CharRow = LineCount + (TextPtr - LastLineStart) / SIOUXBuffer.maxcol;
	*CharCol = (TextPtr - LastLineStart) % SIOUXBuffer.maxcol;
	return;
}

static void DeleteCharsFromBuffer(char* FirstChar, int NumberToDelete)		/*- mm 990416 -*/
{
	char* chptr = FirstChar;
	int   count;
	
	for (count = 0; count <= NumberToDelete; count++, chptr++)			/*- mm 981210 -*/
	{
		if ((*chptr == '\r') && (*(chptr+1) == '\n'))
		{
			SIOUXBuffer.numlines--;
			NumberToDelete++;
			chptr++;
		}
	}
	for (chptr = FirstChar; (chptr + NumberToDelete) < SIOUXBuffer.endpos; chptr++)
		*chptr = *(chptr + NumberToDelete);
	
	SIOUXBuffer.endpos -= NumberToDelete;
	InvalidateRect(WindowHandle, NULL, TRUE);
	return;
}

static void InsertCharsIntoBuffer(char* FirstChar, int NumberToInsert)	/*- mm 990416 -*/
{
	char* chptr;
	
	CheckBufOverflow(NumberToInsert);
	for (chptr = SIOUXBuffer.endpos; chptr >= FirstChar; chptr--)
		*(chptr + NumberToInsert) = *chptr;
	SIOUXBuffer.endpos += NumberToInsert;
	
	return;
}


static int FindNumLines()							/*- mm 990416 -*/
{
	int LineCount       = 0;
	char* LastLineStart = SIOUXBuffer.startpos;
	char* CurrPtr       = SIOUXBuffer.startpos;
	
	*SIOUXBuffer.endpos = '\0';         /* Search stopper */
	while(CurrPtr < SIOUXBuffer.endpos)
	{
		CurrPtr = strstr(LastLineStart, "\r\n");
		if (CurrPtr == NULL)
		{
			LineCount += (SIOUXBuffer.endpos - LastLineStart)/SIOUXBuffer.maxcol;
			break;
		}
		else
		{
			LineCount++;
			LineCount += (CurrPtr - LastLineStart)/SIOUXBuffer.maxcol;
			LastLineStart = CurrPtr + 2;
		}
	}
	return(LineCount);
}

void _MSL_CDECL WinSIOUXclrscr(void)
{
	fflush(stdout);									/*- mm 990427 -*/
	SendMessage(WindowHandle, WM_CLRSCR, 0, 0);
}

void _MSL_CDECL clrscr()
{
	WinSIOUXclrscr();
}


static HFONT GetFont(HDC hdc, int iAttributes, int* Width, int* Height)	/*- mm 990416 -*/
{
	static HFONT TheFont = NULL;
	static char  TheFontName[32] = "";
	static int   TheFontPoints = 0; 
	FLOAT      cxDpi, cyDpi;
	LOGFONT    lf;
	POINT      pt;
	TEXTMETRIC tm;
	int        OldMaxRow;
	if ((strcmp(SIOUXSettings.fontname, TheFontName) != 0) ||
					(SIOUXSettings.fontsize != TheFontPoints))
	{
		SaveDC (hdc);
		strcpy(TheFontName, SIOUXSettings.fontname);
		TheFontPoints = SIOUXSettings.fontsize;
		SetGraphicsMode(hdc, GM_ADVANCED);
		ModifyWorldTransform(hdc, NULL, MWT_IDENTITY);
		SetViewportOrgEx(hdc, 0, 0, NULL);
		SetWindowOrgEx(hdc, 0, 0, NULL);
		
		cxDpi = (FLOAT)GetDeviceCaps(hdc, LOGPIXELSX);
		cyDpi = (FLOAT)GetDeviceCaps(hdc, LOGPIXELSY);
		
		pt.x = 0;
		pt.y = (int) (10 * TheFontPoints * cyDpi / 72);
		
		DPtoLP (hdc, &pt, 1);
		
		lf.lfHeight         = - (int) (fabs (pt.y) / 10.0 + 0.5);
		lf.lfWidth          = 0;
		lf.lfEscapement     = 0;
		lf.lfOrientation    = 0;
		lf.lfWeight         = iAttributes & EZ_ATTR_BOLD      ? 700 : 0;
		lf.lfItalic         = (unsigned char)(iAttributes & EZ_ATTR_ITALIC    ?   1 : 0);/*- mm 990609 -*/
		lf.lfUnderline      = (unsigned char)(iAttributes & EZ_ATTR_UNDERLINE ?   1 : 0);/*- mm 990609 -*/
		lf.lfStrikeOut      = (unsigned char)(iAttributes & EZ_ATTR_STRIKEOUT ?   1 : 0);/*- mm 990609 -*/
		lf.lfCharSet        = 0;
		lf.lfOutPrecision   = 0;
		lf.lfClipPrecision  = 0;
		lf.lfQuality        = 0;
		lf.lfPitchAndFamily = 0;
	
		strcpy(lf.lfFaceName, TheFontName);
		
		TheFont = CreateFontIndirect(&lf);
		SelectObject(hdc, TheFont);
		GetTextMetrics(hdc, &tm);
		*Width  = tm.tmAveCharWidth;                 /* Average character width    */
		*Height = tm.tmHeight + tm.tmExternalLeading;/* Total height of characters */
		RestoreDC (hdc, -1);
		OldMaxRow            = SIOUXBuffer.maxrow;
        SIOUXBuffer.maxrow   = SIOUXBuffer.WindowHeight / *Height;
		SIOUXBuffer.maxcol   = (SIOUXBuffer.WindowWidth-SCROLLBARWIDTH) / *Width;
		if (SIOUXBuffer.maxrow > SIOUXBuffer.row)
			SIOUXBuffer.row = SIOUXBuffer.maxrow - (OldMaxRow - SIOUXBuffer.row);
		else
			SIOUXBuffer.row = SIOUXBuffer.maxrow - BOTTOMGAP;
		SIOUXBuffer.VscrollPos = SIOUXBuffer.VscrollPos + OldMaxRow - SIOUXBuffer.maxrow;
		SetScrollPos(WindowHandle, /* Window handle                    */
			         SB_VERT,      /* Vertical scroll bar              */
			         SIOUXBuffer.VscrollPos, 
			         TRUE);
		InvalidateRect(WindowHandle, NULL, TRUE);
	}
	
	return TheFont;
}

/* Change record:
 * mm  980119 First restricted function version 
 * mm  980219 Added printing capability
 * mm  980304 Made sure the stdout and stderr buffers were flushed before termination
 * mm  980411 Added caret control, cut, copy, paste and detection of eof from keyboard
 * mm  980421 Added code to handle Ctrl+C as interrupt.  MW00288
 * mm  980504 Added code to handle variable length arguments for user's main program
 * mm  980528 Many changes to handle long length lines correctly
 * mm  980727 Added code for WinSIOUXclrscr()
 * mm  980729 Added code for hard limit to WinSIOUX buffer size.
 * mm  981105 Added code to change font from settings structure
 * mm  981109 Added code for WinSIOUXAbort to handle assert failures.
 * mm  981210 Changes to allow program to continue after buffer full
 * mm  990125 Insert guard against recursive termination through WinSIOUX
 * mm  990210 Changes to ensure that task termination when it occurs while waiting for input
 * mm  990210 Added code to take note of SIOUXSettings autocloseonquit and asktosaveonclose
 * mm  990301 Made dialog for "Do you want to save WinSIOUX.out" to "...WinSIOUX.txt" WB1-3774
 * mm  990416 Changes to give internal functions file scope only
 * mm  990427 Make sure stdout buffer flushed before clearing screen in WinSIOUXclrscr.
 * mm  990519 Make abort behaviour match SIOUX.
 * mm  990521 Avoid caret falling off bottom of screen
 * mm  990526 Make window background color match system background color
 * mm  990609 Inserted a couple of #pragma unused()'s and some explict casts to avoid warnings
 * mm  991209 Corrections to make scrolling work better.
 * mm  001205 Changes to allow resizing of WinSIOUX window
 * mm  010111 Changes to make termination of WinSIOUX also terminate the main program
 * mm  010305 Made SIOUXSettings initialization readable and corrected initial size of window
 * cc  011203 Added _MSL_CDECL for new name mangling
 * mm  020411 Added code to make exit work better. 
 */